/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import java.util.function.Supplier;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.DataCollectors;
import org.eclipse.n4js.smith.Measurement;

public final class N4JSDataCollectors {
    public static final DataCollector dcN4JSResource = N4JSDataCollectors.create("N4JSResource");
    public static final DataCollector dcTranspiler = N4JSDataCollectors.create("Transpiler");
    public static final DataCollector dcBuild = N4JSDataCollectors.create("Build");
    public static final DataCollector dcAstPostprocess = N4JSDataCollectors.create("AstPostprocess", dcBuild);
    public static final DataCollector dcRuntimeDepsCollect = N4JSDataCollectors.create("RuntimeDepsCollect", dcAstPostprocess);
    public static final DataCollector dcRuntimeDepsFindCycles = N4JSDataCollectors.create("RuntimeDepsFindCycles", dcAstPostprocess);
    public static final DataCollector dcValidations = N4JSDataCollectors.create("Validations", dcBuild);
    public static final DataCollector dcValidationsPackageJson = N4JSDataCollectors.create("Validations (package.json)", dcBuild);
    public static final DataCollector dcTranspilation = N4JSDataCollectors.create("Transpilation", dcBuild);
    public static final DataCollector dcTranspilationStep1 = N4JSDataCollectors.create("T1", dcTranspilation);
    public static final DataCollector dcTranspilationStep2 = N4JSDataCollectors.create("T2", dcTranspilation);
    public static final DataCollector dcTranspilationStep3 = N4JSDataCollectors.create("T3", dcTranspilation);
    public static final DataCollector dcLibMngr = N4JSDataCollectors.create("Library Manager");
    public static final DataCollector dcNpmInstall = N4JSDataCollectors.create("Install NPMs", dcLibMngr);
    public static final DataCollector dcNpmUninstall = N4JSDataCollectors.create("Uninstall NPMs", dcLibMngr);
    public static final DataCollector dcIndexSynchronizer = N4JSDataCollectors.create("Index Synchronizer", dcLibMngr);
    public static final DataCollector dcInstallHelper = N4JSDataCollectors.create("External Libraries Install Helper");
    public static final DataCollector dcCollectMissingDeps = N4JSDataCollectors.create("Collect missing dependencies", dcInstallHelper);
    public static final DataCollector dcInstallMissingDeps = N4JSDataCollectors.create("Install missing dependencies", dcInstallHelper);
    public static final DataCollector dcExtLibBuilder = N4JSDataCollectors.create("External Library Builder");
    public static final DataCollector dcFlowGraphs = N4JSDataCollectors.create("Flow Graphs");
    public static final DataCollector dcCreateGraph = N4JSDataCollectors.create("Create Graphs", dcFlowGraphs);
    public static final DataCollector dcAugmentEffectInfo = N4JSDataCollectors.create("Augment Effect Information", dcCreateGraph);
    public static final DataCollector dcCreateNodes = N4JSDataCollectors.create("Create Nodes", dcCreateGraph);
    public static final DataCollector dcConnectNodes = N4JSDataCollectors.create("Connect Nodes", dcCreateGraph);
    public static final DataCollector dcJumpEdges = N4JSDataCollectors.create("Jump Edges", dcCreateGraph);
    public static final DataCollector dcPerformAnalyses = N4JSDataCollectors.create("Perform Analyses", dcFlowGraphs);
    public static final DataCollector dcForwardAnalyses = N4JSDataCollectors.create("Forward", dcPerformAnalyses);
    public static final DataCollector dcBackwardAnalyses = N4JSDataCollectors.create("Backward", dcPerformAnalyses);
    public static final DataCollector dcFlowGraphPostprocessing = N4JSDataCollectors.create("PostProcessing", dcFlowGraphs);
    public static final DataCollector dcManifestAwareResourceValidator = N4JSDataCollectors.create("ManifestAwareResourceValidator");
    public static final String HEADLESS_N4JS_COMPILER_COLLECTOR_NAME = "Headless N4JS Compiler";
    public static final DataCollector dcHeadless = N4JSDataCollectors.create("Headless N4JS Compiler");
    public static final DataCollector dcHeadlessBuildSetComputation = N4JSDataCollectors.create("Compute build set", dcHeadless);
    public static final DataCollector dcHeadlessProjectRegistration = N4JSDataCollectors.create("Register project", dcHeadless);
    public static final DataCollector dcHeadlessInstallMissingDeps = N4JSDataCollectors.create("Install missing dependencies", dcHeadless);
    public static final DataCollector dcHeadlessCompilation = N4JSDataCollectors.create("Compilation", dcHeadless);
    public static final DataCollector dcHeadlessRunnerTester = N4JSDataCollectors.create("Execute runner/tester", dcHeadless);
    public static final String N4JS_CLI_COLLECTOR_NAME = "n4jsc goal";
    public static final String N4JS_CLI_COMPILER_COLLECTOR_NAME = "n4jsc compile";
    public static final DataCollector dcCli = N4JSDataCollectors.create("n4jsc goal");
    public static final DataCollector dcCliCompile = N4JSDataCollectors.create("n4jsc compile", dcCli);

    public static DataCollector createDataCollectorForCheckMethod(String methodName) {
        DataCollector parent;
        if (dcValidationsPackageJson.hasActiveMeasurement()) {
            parent = dcValidationsPackageJson;
        } else if (dcValidations.hasActiveMeasurement()) {
            parent = dcValidations;
        } else {
            if (!dcValidations.isPaused()) {
                DataCollectors.INSTANCE.warn("check method " + methodName + " invoked without data collector " + dcValidations.getId() + " being active");
            }
            parent = dcValidations;
        }
        return DataCollectors.INSTANCE.getOrCreateDataCollector(methodName, parent);
    }

    public static void measure(String key, Runnable operation) {
        DataCollector dc = DataCollectors.INSTANCE.getOrCreateDataCollector("TEMP " + key);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Measurement m = dc.getMeasurement();){
            operation.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T measure(String key, Supplier<T> operation) {
        DataCollector dc = DataCollectors.INSTANCE.getOrCreateDataCollector("TEMP " + key);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Measurement m = dc.getMeasurement();){
            return operation.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static DataCollector create(String key) {
        return DataCollectors.INSTANCE.getOrCreateDataCollector(key);
    }

    private static DataCollector create(String key, DataCollector parent) {
        return DataCollectors.INSTANCE.getOrCreateDataCollector(key, parent);
    }

    private N4JSDataCollectors() {
    }
}

