/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.EffectType;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.util.N4JSSwitch;

class CFEEffectInfos {
    CFEEffectInfos() {
    }

    static void set(SymbolFactory symbolFactory, Map<ControlFlowElement, ComplexNode> cnMap, ComplexNode cNode, ControlFlowElement cfe) {
        new InternalEffectInfos(symbolFactory, cnMap, cNode).doSwitch((EObject)cfe);
    }

    private static class InternalEffectInfos
    extends N4JSSwitch<Void> {
        private final SymbolFactory symbolFactory;
        final Map<ControlFlowElement, ComplexNode> cnMap;
        final ComplexNode cNode;

        InternalEffectInfos(SymbolFactory symbolFactory, Map<ControlFlowElement, ComplexNode> cnMap, ComplexNode cNode) {
            this.symbolFactory = symbolFactory;
            this.cnMap = cnMap;
            this.cNode = cNode;
        }

        public Void caseVariableDeclaration(VariableDeclaration feature) {
            Node entryNode = this.cNode.getEntry();
            Node exitNode = this.cNode.getExit();
            this.addEffect(EffectType.Declaration, (ControlFlowElement)feature, entryNode);
            this.addEffect(EffectType.Write, (ControlFlowElement)feature, exitNode);
            return null;
        }

        public Void caseAssignmentExpression(AssignmentExpression feature) {
            Expression lhs = feature.getLhs();
            if (lhs == null) {
                return null;
            }
            LinkedList<Expression> idRefs = new LinkedList<Expression>();
            if (DestructureUtils.isTopOfDestructuringAssignment((EObject)feature)) {
                idRefs.addAll(DestructNode.getAllDeclaredIdRefs((EObject)feature));
            } else {
                idRefs.add(lhs);
            }
            Node exitNode = this.cNode.getExit();
            for (Expression assignedVar : idRefs) {
                this.clearEffectsOfExitNode(assignedVar);
                this.addEffect(EffectType.Write, (ControlFlowElement)assignedVar, exitNode);
            }
            return null;
        }

        public Void caseForStatement(ForStatement feature) {
            Expression initExpr;
            if (feature.isForOf() && (initExpr = feature.getInitExpr()) instanceof IdentifierRef) {
                this.clearEffectsOfExitNode(initExpr);
                ComplexNode cn = this.cnMap.get(initExpr);
                Node exitNode = cn.getExit();
                this.addEffect(EffectType.Write, (ControlFlowElement)initExpr, exitNode);
            }
            return null;
        }

        public Void casePostfixExpression(PostfixExpression feature) {
            if (feature.getExpression() == null) {
                return null;
            }
            this.clearEffectsOfExitNode(feature.getExpression());
            Node exitNode = this.cNode.getExit();
            Node expressionNode = this.cnMap.get(feature.getExpression()).getExit();
            this.addEffect(EffectType.Read, (ControlFlowElement)feature.getExpression(), expressionNode);
            this.addEffect(EffectType.Write, (ControlFlowElement)feature.getExpression(), exitNode);
            return null;
        }

        public Void caseUnaryExpression(UnaryExpression feature) {
            if (feature.getExpression() == null) {
                return null;
            }
            boolean addEffects = false;
            addEffects |= feature.getOp() == UnaryOperator.INC;
            if (!(addEffects |= feature.getOp() == UnaryOperator.DEC)) {
                return null;
            }
            this.clearEffectsOfExitNode(feature.getExpression());
            Node exitNode = this.cNode.getExit();
            Node expressionNode = this.cnMap.get(feature.getExpression()).getExit();
            this.addEffect(EffectType.Write, (ControlFlowElement)feature.getExpression(), expressionNode);
            this.addEffect(EffectType.Read, (ControlFlowElement)feature.getExpression(), exitNode);
            return null;
        }

        public Void caseParameterizedCallExpression(ParameterizedCallExpression feature) {
            Expression targetExpr = feature.getTarget();
            if (targetExpr == null) {
                return null;
            }
            Node exitNode = this.cNode.getExit();
            this.addEffect(EffectType.MethodCall, (ControlFlowElement)targetExpr, exitNode);
            return null;
        }

        public Void caseParameterizedPropertyAccessExpression(ParameterizedPropertyAccessExpression feature) {
            this.setRead((Expression)feature);
            return null;
        }

        public Void caseIdentifierRef(IdentifierRef feature) {
            this.setRead((Expression)feature);
            return null;
        }

        public Void caseIndexedAccessExpression(IndexedAccessExpression feature) {
            this.setRead((Expression)feature);
            return null;
        }

        private void setRead(Expression feature) {
            Node exitNode = this.cNode.getExit();
            this.addEffect(EffectType.Read, (ControlFlowElement)feature, exitNode);
        }

        private void clearEffectsOfExitNode(Expression feature) {
            ComplexNode cn = this.cnMap.get(feature);
            if (cn != null) {
                Node exitNode = cn.getExit();
                exitNode.effectInfos.clear();
            }
        }

        private void addEffect(EffectType effectType, ControlFlowElement expr, Node node) {
            boolean supportsEffectInfo = node instanceof HelperNode || node instanceof RepresentingNode;
            Preconditions.checkState((boolean)supportsEffectInfo, (Object)"Effect info can be attached to Helper-/Representing- nodes only");
            Symbol symbol = this.symbolFactory.create(expr);
            if (symbol != null) {
                EffectInfo eiDecl = new EffectInfo(effectType, expr, symbol);
                node.addEffectInfo(eiDecl);
                if (effectType == EffectType.Write) {
                    symbol.addDefinitionCFE(expr);
                }
            }
        }
    }
}

