/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4FieldAccessor;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.ClassConstructorAssistant;
import org.eclipse.n4js.transpiler.es.assistants.ClassifierAssistant;
import org.eclipse.n4js.transpiler.es.assistants.DelegationAssistant;
import org.eclipse.n4js.transpiler.es.assistants.ReflectionAssistant;
import org.eclipse.n4js.transpiler.es.transform.MemberPatchingTransformation;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@TransformationDependency.RequiresBefore(value={MemberPatchingTransformation.class})
public class ClassDeclarationTransformation
extends Transformation {
    @Inject
    private ClassConstructorAssistant classConstructorAssistant;
    @Inject
    private ClassifierAssistant classifierAssistant;
    @Inject
    private ReflectionAssistant reflectionAssistant;
    @Inject
    private DelegationAssistant delegationAssistant;
    @Inject
    private TypeAssistant typeAssistant;

    public void assertPreConditions() {
        this.typeAssistant.assertClassifierPreConditions();
        Functions.Function1 _function = it -> it instanceof N4ClassExpression;
        this.assertFalse("class expressions are not supported yet", IteratorExtensions.exists((Iterator)this.getState().im.eAllContents(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            boolean _isTopLevel = this.typeAssistant.isTopLevel((TypeDefiningElement)it);
            return !_isTopLevel;
        };
        this.assertFalse("only top-level classes are supported, for now", IterableExtensions.exists((Iterable)this.collectNodes((EObject)this.getState().im, N4ClassDeclaration.class, false), (Functions.Function1)_function_1));
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4ClassDeclaration> _function = it -> this.transformClassDecl((N4ClassDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4ClassDeclaration.class, false).forEach(_function);
    }

    private void transformClassDecl(N4ClassDeclaration classDecl) {
        SymbolTableEntry classSTE = this.findSymbolTableEntryForElement((NamedElement)classDecl, false);
        SymbolTableEntryOriginal superClassSTE = this.typeAssistant.getSuperClassSTE(classDecl);
        LinkedHashSet<N4FieldDeclaration> fieldsRequiringExplicitDefinition = this.classifierAssistant.findFieldsRequiringExplicitDefinition(classDecl);
        this.reflectionAssistant.addN4TypeGetter((N4TypeDeclaration)classDecl, (N4ClassifierDeclaration)classDecl);
        this.classConstructorAssistant.amendConstructor(classDecl, classSTE, superClassSTE, fieldsRequiringExplicitDefinition);
        ArrayList belowClassDecl = CollectionLiterals.newArrayList();
        List<Statement> _createExplicitFieldDefinitions = this.classifierAssistant.createExplicitFieldDefinitions(classSTE, true, fieldsRequiringExplicitDefinition);
        Iterables.addAll((Collection)belowClassDecl, _createExplicitFieldDefinitions);
        List<Statement> _createStaticFieldInitializations = this.classifierAssistant.createStaticFieldInitializations((N4ClassifierDeclaration)classDecl, classSTE, fieldsRequiringExplicitDefinition);
        Iterables.addAll((Collection)belowClassDecl, _createStaticFieldInitializations);
        List<Statement> _createAdditionalClassDeclarationCode = this.createAdditionalClassDeclarationCode(classDecl, classSTE);
        Iterables.addAll((Collection)belowClassDecl, _createAdditionalClassDeclarationCode);
        this.insertAfter(TranspilerUtils.orContainingExportDeclaration((EObject)classDecl), (EObject[])Conversions.unwrapArray((Object)belowClassDecl, EObject.class));
        this.removeFieldsAndAbstractMembers(classDecl);
        this.delegationAssistant.replaceDelegatingMembersByOrdinaryMembers((N4ClassifierDeclaration)classDecl);
        this.removeTypeInformation(classDecl);
        classDecl.setSuperClassRef(null);
        classDecl.setSuperClassExpression((Expression)this.__NSSafe_IdentRef((SymbolTableEntry)superClassSTE));
    }

    private void removeFieldsAndAbstractMembers(N4ClassDeclaration classDecl) {
        Predicate<N4MemberDeclaration> _function = m -> {
            boolean _switchResult = false;
            boolean _matched = false;
            if (m instanceof N4FieldDeclaration) {
                _matched = true;
                _switchResult = true;
            }
            if (!_matched && m instanceof N4FieldAccessor) {
                _matched = true;
                _switchResult = ((N4FieldAccessor)m).isAbstract();
            }
            if (!_matched && m instanceof N4MethodDeclaration) {
                _matched = true;
                _switchResult = ((N4MethodDeclaration)m).isAbstract();
            }
            if (!_matched) {
                _switchResult = false;
            }
            return _switchResult;
        };
        classDecl.getOwnedMembersRaw().removeIf(_function);
    }

    private void removeTypeInformation(N4ClassDeclaration classDecl) {
        EList _ownedMembersRaw = classDecl.getOwnedMembersRaw();
        for (N4MemberDeclaration currMember : _ownedMembersRaw) {
            if (currMember instanceof GenericDeclaration) {
                ((GenericDeclaration)currMember).getTypeVars().clear();
            }
            boolean _matched = false;
            if (currMember instanceof N4GetterDeclaration) {
                _matched = true;
                ((N4GetterDeclaration)currMember).setDeclaredTypeRef(null);
            }
            if (_matched || !(currMember instanceof N4MethodDeclaration)) continue;
            _matched = true;
            ((N4MethodDeclaration)currMember).setReturnTypeRef(null);
        }
    }

    protected List<Statement> createAdditionalClassDeclarationCode(N4ClassDeclaration classDecl, SymbolTableEntry classSTE) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }
}

