/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist.imports;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ide.editor.contentassist.imports.ImportRewriter;
import org.eclipse.n4js.ide.editor.contentassist.imports.NameAndAlias;
import org.eclipse.n4js.n4JS.ImportCallExpression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.scoping.IContentAssistScopeProvider;
import org.eclipse.n4js.scoping.imports.PlainAccessOfAliasedImportDescription;
import org.eclipse.n4js.scoping.imports.PlainAccessOfNamespacedImportDescription;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IPrefixMatcher;
import org.eclipse.xtext.ide.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ReplaceRegion;

public class ImportsAwareReferenceProposalCreator {
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ImportRewriter importRewriter;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;
    @Inject
    private IPrefixMatcher prefixMatcher;
    @Inject
    private IProposalConflictHelper conflictHelper;

    public void lookupCrossReference(EObject model, EReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        if (model == null) {
            return;
        }
        IContentAssistScopeProvider contentAssistScopeProvider = (IContentAssistScopeProvider)this.scopeProvider;
        IScope scope = contentAssistScopeProvider.getScopeForContentAssist(model, reference);
        Iterable candidates = scope.getAllElements();
        HashSet<URI> candidateURIs = new HashSet<URI>();
        for (IEObjectDescription candidate : candidates) {
            if (!acceptor.canAcceptMoreProposals() || !filter.apply((Object)candidate)) {
                return;
            }
            ContentAssistEntry proposal = this.getProposal(candidate, model, scope, context);
            if (proposal == null || !candidateURIs.add(candidate.getEObjectURI())) continue;
            int prio = this.proposalPriorities.getCrossRefPriority(candidate, proposal);
            acceptor.accept(proposal, prio);
        }
    }

    private ContentAssistEntry getProposal(IEObjectDescription candidate, EObject model, IScope scope, ContentAssistContext context) {
        CAECandidate caec = new CAECandidate(candidate, scope, context);
        if (!caec.isValid) {
            return null;
        }
        try {
            ContentAssistEntry cae = new ContentAssistEntry();
            int version = N4JSResourceDescriptionStrategy.getVersion((IEObjectDescription)candidate);
            String proposal = this.getProposal(caec);
            String label = this.getLabel(caec, version);
            String description = this.getDescription(caec);
            String kind = this.getKind(caec);
            cae.setProposal(proposal);
            cae.setPrefix(context.getPrefix());
            cae.setLabel(label);
            cae.setDescription(description);
            cae.setKind(kind);
            cae.setSource((Object)candidate.getEObjectURI());
            this.addImportIfNecessary(caec, model, cae);
            return cae;
        }
        catch (ValueConverterException valueConverterException) {
            return null;
        }
    }

    private String getProposal(CAECandidate caec) {
        switch (caec.accessType) {
            case alias: {
                return caec.aliasName;
            }
            case namespace: {
                return caec.namespaceName.toString();
            }
        }
        if (caec.newImportHasAlias()) {
            return caec.addedImportNameAndAlias.alias;
        }
        return caec.shortName;
    }

    private String getLabel(CAECandidate caec, int version) {
        String typeVersion;
        String string = typeVersion = version == 0 ? "" : "#" + String.valueOf(version);
        if (caec.isAlias()) {
            return String.valueOf(caec.aliasName) + typeVersion;
        }
        if (caec.isNamespace()) {
            return caec.namespaceName + typeVersion;
        }
        if (caec.newImportHasAlias()) {
            return String.valueOf(caec.shortName) + typeVersion;
        }
        return String.valueOf(caec.shortName) + typeVersion;
    }

    private String getDescription(CAECandidate caec) {
        if (caec.isAlias()) {
            return "alias for " + this.qualifiedNameConverter.toString(caec.qualifiedName);
        }
        if (caec.isNamespace()) {
            return this.qualifiedNameConverter.toString(caec.qualifiedName);
        }
        if (caec.newImportHasAlias()) {
            String descr = "via new alias " + caec.addedImportNameAndAlias.alias;
            descr = String.valueOf(descr) + " for " + this.qualifiedNameConverter.toString(caec.qualifiedName);
            descr = String.valueOf(descr) + "\n\n";
            descr = String.valueOf(descr) + "Introduces the new alias '" + caec.addedImportNameAndAlias.alias;
            descr = String.valueOf(descr) + "' for element " + this.qualifiedNameConverter.toString(caec.qualifiedName);
            return descr;
        }
        QualifiedName caecQN = caec.qualifiedName;
        QualifiedName descrQN = caecQN.getSegmentCount() > 1 ? caecQN.skipLast(1) : caecQN;
        return this.qualifiedNameConverter.toString(descrQN);
    }

    private String getKind(CAECandidate caec) {
        EClass eClass = caec.candidate.getEClass();
        if (TypesPackage.eINSTANCE.getTClass() == eClass) {
            return "CLASS";
        }
        if (TypesPackage.eINSTANCE.getTInterface() == eClass) {
            return "INTERFACE";
        }
        if (TypesPackage.eINSTANCE.getTField() == eClass) {
            return "FIELD";
        }
        if (TypesPackage.eINSTANCE.getTEnum() == eClass) {
            return "ENUM";
        }
        if (TypesPackage.eINSTANCE.getTFunction() == eClass) {
            return "FUNCTION";
        }
        if (TypesPackage.eINSTANCE.getTVariable() == eClass) {
            return "VARIABLE";
        }
        if (N4JSPackage.eINSTANCE.getVariableDeclaration() == eClass) {
            return "VARIABLE";
        }
        if (TypesPackage.eINSTANCE.getModuleNamespaceVirtualType() == eClass) {
            return "COLOR";
        }
        return "TEXT";
    }

    private void addImportIfNecessary(CAECandidate caec, EObject model, ContentAssistEntry proposal) {
        if (caec.addedImportNameAndAlias != null) {
            Resource resource = model.eResource();
            ImportRewriter.ImportChanges importChanges = this.importRewriter.create("\n", resource);
            importChanges.addImport(caec.addedImportNameAndAlias);
            Collection<ReplaceRegion> regions = importChanges.toReplaceRegions();
            if (regions != null && !regions.isEmpty()) {
                proposal.getTextReplacements().addAll(regions);
            }
        }
    }

    private class CAECandidate {
        final IEObjectDescription candidate;
        final IEObjectDescription candidateViaScopeShortName;
        final boolean isScopedCandidateEqual;
        final boolean isScopedCandidateCollisioning;
        final boolean isValid;
        final EObject parentImportElement;
        final String parentImportModuleName;
        final QualifiedName qualifiedName;
        final String shortName;
        final QualifiedName namespaceName;
        final String aliasName;
        final CandidateAccessType accessType;
        final NameAndAlias addedImportNameAndAlias;

        CAECandidate(IEObjectDescription candidate, IScope scope, ContentAssistContext context) {
            this.candidate = candidate;
            this.shortName = this.getShortName();
            this.qualifiedName = this.getQualifiedName();
            this.parentImportElement = this.getParentImportElement(context);
            this.parentImportModuleName = this.getParentImportModuleName();
            this.candidateViaScopeShortName = this.getCorrectCandidateViaScope(scope);
            this.isScopedCandidateEqual = this.isEqualCandidateName(this.candidateViaScopeShortName, this.qualifiedName);
            this.isScopedCandidateCollisioning = this.isScopedCandidateCollisioning();
            this.accessType = this.getAccessType();
            this.aliasName = this.getAliasName();
            this.namespaceName = this.getNamespaceName();
            this.addedImportNameAndAlias = this.getImportChanges();
            this.isValid = this.isValid(context);
        }

        private String getShortName() {
            QualifiedName qName = this.candidate.getQualifiedName();
            return N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)qName);
        }

        private boolean isValid(ContentAssistContext context) {
            String prefix = context.getPrefix();
            boolean validName = false;
            validName |= ImportsAwareReferenceProposalCreator.this.prefixMatcher.isCandidateMatchingPrefix(this.shortName, prefix);
            validName |= this.isAlias() && ImportsAwareReferenceProposalCreator.this.prefixMatcher.isCandidateMatchingPrefix(this.aliasName, prefix);
            boolean valid = validName |= this.isNamespace() && ImportsAwareReferenceProposalCreator.this.prefixMatcher.isCandidateMatchingPrefix(this.namespaceName.getLastSegment(), prefix);
            valid &= !Strings.isNullOrEmpty((String)this.shortName);
            valid &= !ImportsAwareReferenceProposalCreator.this.conflictHelper.existsConflict(this.shortName, context);
            return valid &= this.parentImportModuleName == null || this.qualifiedName.toString("/").startsWith(this.parentImportModuleName);
        }

        private QualifiedName getQualifiedName() {
            QualifiedName qnOfEObject;
            QualifiedName qName = this.candidate.getQualifiedName();
            if (qName.toString().equals(this.shortName) && (qnOfEObject = this.getCompleteQualifiedName(this.candidate)) != null) {
                return qnOfEObject;
            }
            return qName;
        }

        private IEObjectDescription getCorrectCandidateViaScope(IScope scope) {
            IEObjectDescription candidateViaScope = this.getCandidateViaScope(scope);
            candidateViaScope = this.specialcaseNamespaceShadowsOwnElement(scope, candidateViaScope);
            return candidateViaScope;
        }

        private IEObjectDescription getCandidateViaScope(IScope scope) {
            ArrayList elements = Lists.newArrayList((Iterable)scope.getElements(QualifiedName.create((String)this.shortName)));
            if (elements.isEmpty()) {
                return null;
            }
            if (elements.size() > 1) {
                for (IEObjectDescription element : elements) {
                    if (!this.isEqualCandidateName(element, this.qualifiedName)) continue;
                    return element;
                }
            }
            if (!elements.isEmpty()) {
                return (IEObjectDescription)elements.get(0);
            }
            return null;
        }

        private IEObjectDescription specialcaseNamespaceShadowsOwnElement(IScope scope, IEObjectDescription candidateViaScope) {
            if (candidateViaScope == null) {
                return candidateViaScope;
            }
            if (this.candidate.getEObjectOrProxy() instanceof ModuleNamespaceVirtualType) {
                return candidateViaScope;
            }
            EObject eObject = candidateViaScope.getEObjectOrProxy();
            if (!(candidateViaScope.getEObjectOrProxy() instanceof ModuleNamespaceVirtualType)) {
                return candidateViaScope;
            }
            ModuleNamespaceVirtualType mnvt = (ModuleNamespaceVirtualType)eObject;
            TModule module = mnvt.getModule();
            if (module == null) {
                return candidateViaScope;
            }
            String moduleQN = module.getQualifiedName();
            String candidateNamespaceName = candidateViaScope.getName().toString();
            if (!candidateNamespaceName.equals(this.shortName)) {
                return candidateViaScope;
            }
            QualifiedName qualifiedNameViaModule = QualifiedName.create((String)moduleQN).append(this.shortName);
            IEObjectDescription shadowedCandidateViaScope = scope.getSingleElement(qualifiedNameViaModule);
            if (shadowedCandidateViaScope == null) {
                return candidateViaScope;
            }
            QualifiedName qualifiedNameViaNamespace = QualifiedName.create((String)candidateNamespaceName).append(this.shortName);
            if (!this.qualifiedName.equals((Object)qualifiedNameViaModule)) {
                return candidateViaScope;
            }
            return new PlainAccessOfNamespacedImportDescription(shadowedCandidateViaScope, qualifiedNameViaNamespace);
        }

        private QualifiedName getCompleteQualifiedName(IEObjectDescription objDescr) {
            if (objDescr == null) {
                return null;
            }
            EObject eObjectOrProxy = objDescr.getEObjectOrProxy();
            if (eObjectOrProxy == null) {
                return null;
            }
            QualifiedName qnOfEObject = ImportsAwareReferenceProposalCreator.this.qualifiedNameProvider.getFullyQualifiedName(eObjectOrProxy);
            return qnOfEObject;
        }

        private boolean isEqualCandidateName(IEObjectDescription objDescr, QualifiedName qName) {
            QualifiedName qnOfEObject = this.getCompleteQualifiedName(objDescr);
            if (qnOfEObject == null) {
                return false;
            }
            return qnOfEObject.equals((Object)qName);
        }

        private boolean isScopedCandidateCollisioning() {
            QualifiedName candidateNamespaceName;
            String candidateAlias;
            if (this.isScopedCandidateEqual) {
                return false;
            }
            if (this.candidateViaScopeShortName instanceof PlainAccessOfAliasedImportDescription && !this.shortName.equals(candidateAlias = ((PlainAccessOfAliasedImportDescription)this.candidateViaScopeShortName).getAlias())) {
                return false;
            }
            return !(this.candidateViaScopeShortName instanceof PlainAccessOfNamespacedImportDescription) || this.shortName.equals((candidateNamespaceName = ((PlainAccessOfNamespacedImportDescription)this.candidateViaScopeShortName).getNamespacedName()).toString());
        }

        private CandidateAccessType getAccessType() {
            if (this.isScopedCandidateEqual) {
                if (this.candidateViaScopeShortName instanceof PlainAccessOfAliasedImportDescription) {
                    return CandidateAccessType.alias;
                }
                if (this.candidateViaScopeShortName instanceof PlainAccessOfNamespacedImportDescription) {
                    return CandidateAccessType.namespace;
                }
            }
            if (this.candidate instanceof AliasedEObjectDescription) {
                return CandidateAccessType.alias;
            }
            return CandidateAccessType.direct;
        }

        private String getAliasName() {
            if (this.accessType == CandidateAccessType.alias) {
                if (this.candidate instanceof AliasedEObjectDescription) {
                    return this.candidate.getName().toString();
                }
                return ((PlainAccessOfAliasedImportDescription)this.candidateViaScopeShortName).getAlias();
            }
            return null;
        }

        private QualifiedName getNamespaceName() {
            if (this.accessType == CandidateAccessType.namespace) {
                return ((PlainAccessOfNamespacedImportDescription)this.candidateViaScopeShortName).getNamespacedName();
            }
            return null;
        }

        private EObject getParentImportElement(ContentAssistContext context) {
            INode currentNode = context.getCurrentNode();
            while (currentNode != null) {
                EObject semanticElement = currentNode.getSemanticElement();
                if (semanticElement instanceof ImportCallExpression || semanticElement instanceof ImportDeclaration) {
                    return semanticElement;
                }
                currentNode = currentNode.getParent();
            }
            return null;
        }

        private String getParentImportModuleName() {
            if (this.parentImportElement instanceof ImportCallExpression) {
                return null;
            }
            if (this.parentImportElement instanceof ImportDeclaration) {
                ImportDeclaration impDecl = (ImportDeclaration)this.parentImportElement;
                return impDecl.getModuleSpecifierAsText();
            }
            return null;
        }

        private NameAndAlias getImportChanges() {
            if (this.parentImportElement != null) {
                return null;
            }
            if (this.accessType != CandidateAccessType.direct) {
                return null;
            }
            QualifiedName importName = this.getImportName();
            if (importName == null) {
                return null;
            }
            if (importName.getSegmentCount() == 1) {
                return null;
            }
            if (importName.getSegmentCount() == 2 && N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT.equals(importName.getFirstSegment())) {
                return null;
            }
            String alias = null;
            if (this.candidateViaScopeShortName != null && this.isScopedCandidateCollisioning) {
                boolean cfr_ignored_0 = this.candidateViaScopeShortName.getEObjectOrProxy() instanceof ModuleNamespaceVirtualType;
                alias = "Alias_" + UtilN4.toUpperCaseFirst((String)this.qualifiedName.toString().replace(".", "_"));
            }
            return new NameAndAlias(importName, alias);
        }

        private QualifiedName getImportName() {
            QualifiedName candidateName;
            QualifiedName qfn = this.candidate.getQualifiedName();
            int qfnSegmentCount = qfn.getSegmentCount();
            String tmodule = qfnSegmentCount >= 2 ? qfn.getSegment(qfnSegmentCount - 2) : null;
            IN4JSProject project = (IN4JSProject)ImportsAwareReferenceProposalCreator.this.n4jsCore.findProject(this.candidate.getEObjectURI()).orNull();
            if (project != null && tmodule != null && tmodule.equals(project.getMainModule())) {
                N4JSProjectName projectName = project.getProjectName();
                N4JSProjectName definesPackage = project.getDefinesPackageName();
                if (definesPackage != null) {
                    projectName = definesPackage;
                }
                String lastSegmentOfQFN = this.candidate.getQualifiedName().getLastSegment().toString();
                candidateName = QualifiedName.create((String[])new String[]{projectName.getRawName(), lastSegmentOfQFN});
            } else {
                candidateName = this.candidate.getQualifiedName();
            }
            return candidateName;
        }

        public boolean hasNewImport() {
            return this.addedImportNameAndAlias != null;
        }

        public boolean newImportHasAlias() {
            return this.hasNewImport() && !Strings.isNullOrEmpty((String)this.addedImportNameAndAlias.alias);
        }

        public boolean isAlias() {
            return this.accessType == CandidateAccessType.alias;
        }

        public boolean isNamespace() {
            return this.accessType == CandidateAccessType.namespace;
        }
    }

    private static enum CandidateAccessType {
        direct,
        alias,
        namespace;

    }
}

