/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.xtext.ui.resource.JarEntryURIHelper;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;

public class JarEntryLocator {
    private static final Logger log = Logger.getLogger(JarEntryLocator.class);

    public URI getURI(IPackageFragmentRoot root, IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
        if (root.isArchive()) {
            URI jarURI = JarEntryURIHelper.getUriForPackageFragmentRoot(root);
            URI storageURI = URI.createURI((String)jarEntry.getFullPath().toString());
            return this.createJarURI(root.isArchive(), jarURI, storageURI);
        }
        if (root instanceof ExternalPackageFragmentRoot) {
            IResource resource = ((ExternalPackageFragmentRoot)root).resource();
            IPath result = resource.getFullPath();
            int i = 1;
            while (i < state.getParents().size()) {
                Object obj = state.getParents().get(i);
                if (obj instanceof IPackageFragment) {
                    result = result.append((IPath)new Path(((IPackageFragment)obj).getElementName().replace('.', '/')));
                } else if (obj instanceof IJarEntryResource) {
                    result = result.append(((IJarEntryResource)obj).getName());
                }
                ++i;
            }
            result = result.append(jarEntry.getName());
            return URI.createPlatformResourceURI((String)result.toString(), (boolean)true);
        }
        throw new IllegalStateException("Unexpeced root type: " + root.getClass().getName());
    }

    protected URI createJarURI(boolean isArchive, URI uriToRoot, URI pathToResourceInRoot) {
        if (isArchive) {
            String fullURI = "archive:" + uriToRoot.toString() + "!" + pathToResourceInRoot.toString();
            return URI.createURI((String)fullURI);
        }
        return null;
    }
}

