/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.imports;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.formatting2.FormattingUserPreferenceHelper;
import org.eclipse.n4js.ide.imports.ImportDescriptor;
import org.eclipse.n4js.ide.imports.ImportRegionHelper;
import org.eclipse.n4js.ide.imports.ReferenceDescriptor;
import org.eclipse.n4js.ide.imports.ReferenceResolution;
import org.eclipse.n4js.ide.imports.ReferenceResolutionFinder;
import org.eclipse.n4js.ide.imports.XReplaceRegion;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.organize.imports.ImportSpecifiersUtil;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;

@Singleton
public class ImportHelper {
    private static final EReference identifierRef_id = N4JSPackage.eINSTANCE.getIdentifierRef_Id();
    private static final EReference parameterizedTypeRef_declaredType = TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType();
    @Inject
    private ReferenceResolutionFinder referenceResolutionFinder;
    @Inject
    private ImportRegionHelper importRegionHelper;
    @Inject
    private FormattingUserPreferenceHelper formattingUserPreferenceHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private N4JSGrammarAccess grammarAccess;
    @Inject
    private IValueConverterService valueConverters;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public ImportDescriptor createImportDescriptorFromAST(ImportDeclaration importDecl, ImportSpecifier importSpec, int originalIndex) {
        Objects.requireNonNull(importDecl);
        if (importSpec != null && !importSpec.isFlaggedUsedInCode()) {
            throw new IllegalArgumentException("must not create an ImportDescriptor for unused imports");
        }
        if (importSpec == null && ImportSpecifiersUtil.isBrokenImport((ImportDeclaration)importDecl) || importSpec != null && ImportSpecifiersUtil.isBrokenImport((ImportSpecifier)importSpec)) {
            throw new IllegalArgumentException("must not create an ImportDescriptor for broken imports");
        }
        TModule module = importDecl.getModule();
        String targetProjectName = module.getProjectName();
        QualifiedName targetModule = this.qualifiedNameConverter.toQualifiedName(module.getQualifiedName());
        String moduleSpecifier = importDecl.getModuleSpecifierAsText();
        if (importDecl.isBare()) {
            return ImportDescriptor.createBareImport(moduleSpecifier, targetProjectName, targetModule, originalIndex);
        }
        if (importSpec instanceof NamedImportSpecifier) {
            NamedImportSpecifier importSpecCasted = (NamedImportSpecifier)importSpec;
            if (importSpecCasted.isDefaultImport()) {
                String localName = importSpecCasted.getAlias();
                return ImportDescriptor.createDefaultImport(localName, moduleSpecifier, targetProjectName, targetModule, originalIndex);
            }
            String elementName = importSpecCasted.getImportedElementAsText();
            String alias = importSpecCasted.getAlias();
            return ImportDescriptor.createNamedImport(elementName, alias, moduleSpecifier, targetProjectName, targetModule, originalIndex);
        }
        if (importSpec instanceof NamespaceImportSpecifier) {
            String localNamespaceName = ((NamespaceImportSpecifier)importSpec).getAlias();
            return ImportDescriptor.createNamespaceImport(localNamespaceName, moduleSpecifier, targetProjectName, targetModule, originalIndex);
        }
        if (importSpec != null) {
            throw new IllegalArgumentException("unknown subclass of ImportSpecifier: " + importSpec.getClass().getSimpleName());
        }
        throw new IllegalArgumentException("importSpec may be null only if importDecl is a bare import");
    }

    public ReplaceRegion getReplacementForImport(Script script, ImportDescriptor importDesc) {
        int insertionOffset = this.importRegionHelper.findInsertionOffset(script);
        String spacing = this.formattingUserPreferenceHelper.getSpacingPreference(script.eResource());
        String lineDelimiter = "\n";
        String insertedCode = String.valueOf(insertionOffset != 0 ? lineDelimiter : "") + importDesc.toCode(spacing, this.valueConverters, this.grammarAccess) + (insertionOffset != 0 ? "" : lineDelimiter);
        TextRegion region = new TextRegion(insertionOffset, 0);
        XReplaceRegion textReplacement = new XReplaceRegion((ITextRegion)region, insertedCode);
        return textReplacement;
    }

    public List<ReferenceResolution> findResolutionsForAllUnresolvedReferences(Script script, CancelIndicator cancelIndicator) {
        this.triggerProxyResolution((EObject)script, cancelIndicator);
        ArrayList<ReferenceResolution> result = new ArrayList<ReferenceResolution>();
        HashSet<String> donePrefixes = new HashSet<String>();
        TreeIterator iter = script.eAllContents();
        while (iter.hasNext()) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            EObject curr = (EObject)iter.next();
            ReferenceDescriptor reference = this.getUnresolvedReferenceForASTNode(curr);
            if (reference == null || !donePrefixes.add(reference.text)) continue;
            ResolutionAcceptor acceptor = new ResolutionAcceptor(2, cancelIndicator);
            this.referenceResolutionFinder.findResolutions(reference, true, true, (Predicate<String>)Predicates.alwaysFalse(), (Predicate<IEObjectDescription>)Predicates.alwaysTrue(), acceptor);
            List<ReferenceResolution> resolutions = acceptor.getResolutions();
            if (resolutions.size() != 1) continue;
            result.add(resolutions.get(0));
        }
        return result;
    }

    public List<ReferenceResolution> findResolutionsForUnresolvedReference(EObject astNode, CancelIndicator cancelIndicator) {
        this.triggerProxyResolution(astNode, cancelIndicator);
        ReferenceDescriptor reference = this.getUnresolvedReferenceForASTNode(astNode);
        if (reference == null) {
            return Collections.emptyList();
        }
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        ResolutionAcceptor acceptor = new ResolutionAcceptor(-1, cancelIndicator);
        this.referenceResolutionFinder.findResolutions(reference, true, true, (Predicate<String>)Predicates.alwaysFalse(), (Predicate<IEObjectDescription>)Predicates.alwaysTrue(), acceptor);
        return acceptor.getResolutions();
    }

    private void triggerProxyResolution(EObject eObject, CancelIndicator cancelIndicator) {
        Resource resource = eObject.eResource();
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(cancelIndicator);
        }
    }

    private ReferenceDescriptor getUnresolvedReferenceForASTNode(EObject astNode) {
        String prefix;
        EReference eReference;
        if (astNode instanceof IdentifierRef) {
            eReference = identifierRef_id;
            prefix = ((IdentifierRef)astNode).getIdAsText();
        } else if (astNode instanceof ParameterizedTypeRef) {
            eReference = parameterizedTypeRef_declaredType;
            prefix = ((ParameterizedTypeRef)astNode).getDeclaredTypeAsText();
        } else {
            return null;
        }
        if (eReference == null || prefix == null) {
            return null;
        }
        Object targetObj = astNode.eGet((EStructuralFeature)eReference, false);
        if (!(targetObj instanceof EObject)) {
            return null;
        }
        if (!((EObject)targetObj).eIsProxy()) {
            return null;
        }
        ICompositeNode currentNode = NodeModelUtils.findActualNodeFor((EObject)astNode);
        if (currentNode == null) {
            return null;
        }
        return new ReferenceDescriptor(prefix, astNode, eReference, (INode)currentNode);
    }

    private static final class ResolutionAcceptor
    implements ReferenceResolutionFinder.IResolutionAcceptor {
        private final int maxAcceptedProposals;
        private final CancelIndicator cancelIndicator;
        private final List<ReferenceResolution> resolutions = new ArrayList<ReferenceResolution>();

        private ResolutionAcceptor(int maxAcceptedProposals, CancelIndicator cancelIndicator) {
            this.maxAcceptedProposals = maxAcceptedProposals >= 0 ? maxAcceptedProposals : Integer.MAX_VALUE;
            this.cancelIndicator = cancelIndicator;
        }

        @Override
        public void accept(ReferenceResolution newEntry) {
            this.resolutions.add(newEntry);
        }

        public List<ReferenceResolution> getResolutions() {
            return this.resolutions;
        }

        @Override
        public boolean canAcceptMoreProposals() {
            return this.resolutions.size() < this.maxAcceptedProposals && !this.cancelIndicator.isCanceled();
        }
    }
}

