/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import java.util.Iterator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class ContentModelTypeSection
extends AbstractSection {
    private final String CONTENT_TYPE = DTDPropertiesMessages._UI_LABEL_CONTENT_TYPE;
    private CCombo typeCombo;
    private String[] typeComboValues = new String[]{CMNode.ANY, CMNode.EMPTY, CMNode.PCDATA, CMNode.CHILDREN, CMNode.MIXED};

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel cLabel = this.getWidgetFactory().createCLabel(composite, this.CONTENT_TYPE);
        Point p = cLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        cLabel.setLayoutData((Object)data);
        this.typeCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        data = new FormData();
        data.left = new FormAttachment((Control)cLabel, -5);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment((Control)cLabel, 0, 0x1000000);
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        this.typeCombo.setItems(this.typeComboValues);
    }

    @Override
    public void refresh() {
        Object input = this.getInput();
        if (input != null && input instanceof CMNode) {
            this.typeCombo.removeAll();
            this.typeCombo.add(CMNode.ANY);
            this.typeCombo.add(CMNode.EMPTY);
            this.typeCombo.add(CMNode.PCDATA);
            this.typeCombo.add(CMNode.CHILDREN);
            this.typeCombo.add(CMNode.MIXED);
            Iterator iterator = ((CMNode)input).getDTDFile().getNodes().iterator();
            String nodeName = null;
            while (iterator.hasNext()) {
                DTDNode node = (DTDNode)iterator.next();
                nodeName = node.getName();
                if (node instanceof Element && this.typeCombo.indexOf(nodeName) == -1) {
                    this.typeCombo.add(nodeName);
                    continue;
                }
                if (!(node instanceof Entity) || !((Entity)node).isParameterEntity() || this.typeCombo.indexOf(nodeName) != -1) continue;
                this.typeCombo.add("%" + nodeName + ";");
            }
            if (input instanceof CMGroupNode) {
                this.typeCombo.setText(((CMGroupNode)input).getType());
            } else if (input instanceof CMBasicNode) {
                this.typeCombo.setText(((CMBasicNode)input).getType());
            }
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Object input;
        if (e.widget == this.typeCombo && ((input = this.getInput()) instanceof CMGroupNode || input instanceof CMBasicNode)) {
            CMNode node = (CMNode)input;
            String selected = this.typeCombo.getText();
            if (CMNode.MIXED.equals(selected)) {
                node.setMixedContent();
            } else if (CMNode.CHILDREN.equals(selected)) {
                node.setChildrenContent("");
            } else if (CMNode.EMPTY.equals(selected) || CMNode.ANY.equals(selected) || CMNode.PCDATA.equals(selected)) {
                node.setContent(selected);
            } else {
                node.setChildrenContent(selected);
            }
        }
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return false;
    }
}

