/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.adoc.FileSystem;
import org.eclipse.n4js.jsdoc2spec.adoc.IndexEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecListingFile;

class WebContentFileWriter {
    private final SortedMap<String, PackageEntry> allPackages = new TreeMap<String, PackageEntry>();
    private final StringBuilder allPackagesStrb = new StringBuilder();
    private final StringBuilder allModulesStrb = new StringBuilder();

    WebContentFileWriter() {
    }

    public void serialize(ArrayList<IndexEntry> entries) throws UnsupportedEncodingException {
        for (IndexEntry ie : entries) {
            if (ie.project.endsWith("tests")) continue;
            String packageName = ie.packageName;
            if (!this.allPackages.containsKey(packageName)) {
                int packageCount = ie.modulePackageCount;
                this.allPackages.put(packageName, new PackageEntry(packageName, packageCount));
            }
            PackageEntry pe = (PackageEntry)this.allPackages.get(packageName);
            String moduleName = ie.moduleName;
            if (ie.isStaticPolyfillAware || pe.modules.containsKey(moduleName)) continue;
            pe.modules.put(moduleName, new ModuleEntry(moduleName, ie));
        }
        this.buildAllPackagesFile();
        this.buildAllModulesFile();
        for (PackageEntry pe : this.allPackages.values()) {
            this.buildPackageModulesFile(pe);
        }
    }

    public List<SpecFile> getSpecFiles(File rootDir) {
        File adocGenDir = new File(String.valueOf(rootDir.getAbsolutePath()) + FileSystem.SEP + "api-gen");
        File packageDir = new File(String.valueOf(adocGenDir.getAbsolutePath()) + FileSystem.SEP + "packages");
        ArrayList<SpecFile> specFiles = new ArrayList<SpecFile>();
        this.generateAllPackagesFile(adocGenDir, specFiles);
        this.generateAllModulesFile(adocGenDir, specFiles);
        for (PackageEntry pe : this.allPackages.values()) {
            this.generatePackageModulesFile(packageDir, pe, specFiles);
        }
        return specFiles;
    }

    private void buildAllPackagesFile() throws UnsupportedEncodingException {
        WebContentFileWriter.appendHeading(this.allPackagesStrb, "Packages");
        for (PackageEntry pe : this.allPackages.values()) {
            String moduleStyleName = pe.name.replace("/", ".");
            String url = "";
            url = String.valueOf(url) + "packages/";
            url = String.valueOf(url) + pe.name + ".html";
            url = this.escapeURL(url);
            this.buildLink(this.allPackagesStrb, moduleStyleName, url, "packageModulesBar");
        }
        WebContentFileWriter.appendFooter(this.allPackagesStrb);
    }

    private void buildAllModulesFile() throws UnsupportedEncodingException {
        ArrayList<ModuleEntry> allModules = new ArrayList<ModuleEntry>();
        for (PackageEntry pe : this.allPackages.values()) {
            allModules.addAll(pe.modules.values());
        }
        Collections.sort(allModules);
        WebContentFileWriter.appendHeading(this.allModulesStrb, "All Modules");
        for (ModuleEntry me : allModules) {
            String url = "";
            url = String.valueOf(url) + "modules/";
            url = String.valueOf(url) + me.ie.adocPath.replace(".adoc", ".html");
            url = this.escapeURL(url);
            this.buildLink(this.allModulesStrb, me.name, url, "moduleView");
        }
        WebContentFileWriter.appendFooter(this.allModulesStrb);
    }

    private void buildPackageModulesFile(PackageEntry pe) throws UnsupportedEncodingException {
        WebContentFileWriter.appendHeadingModulePackages(pe);
        for (ModuleEntry me : pe.modules.values()) {
            String url = "";
            int packageCount = pe.getPackageCount();
            int i = 0;
            while (i < packageCount) {
                url = String.valueOf(url) + "../";
                ++i;
            }
            url = String.valueOf(url) + "modules/";
            url = String.valueOf(url) + me.ie.adocPath.replace(".adoc", ".html");
            url = this.escapeURL(url);
            this.buildLink(pe.modulesStrb, me.name, url, "moduleView");
        }
        WebContentFileWriter.appendFooter(pe.modulesStrb);
    }

    private void buildLink(StringBuilder strb, String label, String url, String target) {
        strb.append("* ");
        strb.append("link:");
        strb.append(url);
        strb.append("[" + label);
        strb.append(", window=\"" + target + "\"");
        strb.append("]");
        strb.append("\n");
    }

    private static void appendFooter(StringBuilder strb) {
        strb.append("\n--");
        strb.append("\n\n");
    }

    private static void appendHeadingModulePackages(PackageEntry pe) {
        WebContentFileWriter.appendHeading(pe.modulesStrb, pe.name.replace("/", "."), pe.getPackageCount());
    }

    private static void appendHeading(StringBuilder strb, String heading) {
        WebContentFileWriter.appendHeading(strb, heading, -1);
    }

    private static void appendHeading(StringBuilder strb, String heading, int upLinkDepth) {
        String basedir = "../";
        int i = 0;
        while (i < upLinkDepth) {
            basedir = String.valueOf(basedir) + "../";
            ++i;
        }
        strb.append(":linkattrs:\n");
        strb.append(":docinfodir: ");
        strb.append(basedir);
        strb.append("headers/apiListings\n");
        strb.append(":linkcss:\n");
        strb.append(":stylesheet: ");
        strb.append(basedir);
        strb.append("styles/stdlib_api_listings.css\n");
        strb.append("\n");
        strb.append("[.barHeader]\n");
        strb.append("--\n");
        if (upLinkDepth >= 0) {
            strb.append("image:");
            strb.append(basedir);
            strb.append("images/up-arrow.png");
            strb.append("[link=\"");
            strb.append(basedir);
            strb.append("api-gen");
            strb.append("/allModules.html");
            strb.append("\", window=\"packageModulesBar\"");
            strb.append("]");
            strb.append("\n");
        }
        strb.append(heading);
        strb.append("\n--");
        strb.append("\n\n");
        strb.append("[.barBody]\n");
        strb.append("--\n");
    }

    private void generateAllPackagesFile(File rootDir, List<SpecFile> specFiles) {
        String fileName = "allPackages.adoc";
        String absFileName = rootDir + FileSystem.SEP + fileName;
        File indexFile = new File(absFileName);
        String indexContent = this.allPackagesStrb.toString();
        SpecListingFile scf = new SpecListingFile(indexFile, indexContent, "All Packages Overview");
        specFiles.add(scf);
    }

    private void generateAllModulesFile(File rootDir, List<SpecFile> specFiles) {
        String fileName = "allModules.adoc";
        String absFileName = rootDir + FileSystem.SEP + fileName;
        File indexFile = new File(absFileName);
        String indexContent = this.allModulesStrb.toString();
        SpecListingFile scf = new SpecListingFile(indexFile, indexContent, "All Modules Overview");
        specFiles.add(scf);
    }

    private void generatePackageModulesFile(File rootDir, PackageEntry pe, List<SpecFile> specFiles) {
        String fileName = String.valueOf(pe.name) + ".adoc";
        String absFileName = rootDir + FileSystem.SEP + fileName;
        File indexFile = new File(absFileName);
        String indexContent = pe.modulesStrb.toString();
        SpecListingFile scf = new SpecListingFile(indexFile, indexContent, "Modules Overview");
        specFiles.add(scf);
    }

    private String escapeURL(String fileName) throws UnsupportedEncodingException {
        String[] parts = fileName.split("/");
        String newFileName = URLEncoder.encode(parts[0], "UTF-8");
        int i = 1;
        while (i < parts.length) {
            newFileName = String.valueOf(newFileName) + "/" + URLEncoder.encode(parts[i], "UTF-8");
            ++i;
        }
        return newFileName;
    }

    private static class ModuleEntry
    implements Comparable<ModuleEntry> {
        final String name;
        final IndexEntry ie;

        ModuleEntry(String name, IndexEntry ie) {
            this.name = name;
            this.ie = ie;
        }

        @Override
        public int compareTo(ModuleEntry o) {
            return this.name.compareTo(o.name);
        }
    }

    private static class PackageEntry
    implements Comparable<PackageEntry> {
        static final String NO_PACKAGE_NAME = "NO_PACKAGE";
        final String name;
        final int modulePackageCount;
        final SortedMap<String, ModuleEntry> modules = new TreeMap<String, ModuleEntry>();
        final StringBuilder modulesStrb = new StringBuilder();

        PackageEntry(String name, int modulePackageCount) {
            String packageName = NO_PACKAGE_NAME;
            if (name != null && !name.isEmpty()) {
                packageName = name;
            }
            this.name = packageName;
            this.modulePackageCount = modulePackageCount;
        }

        @Override
        public int compareTo(PackageEntry o) {
            return this.name.compareTo(o.name);
        }

        public int getPackageCount() {
            return this.modulePackageCount;
        }
    }
}

