/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ide.xtext.server.WorkspaceUriResourceMap;

public class ProjectUriResourceMap
extends ForwardingMap<URI, Resource> {
    private final WorkspaceUriResourceMap globalMap;
    private final Set<URI> localContents;

    @Inject
    public ProjectUriResourceMap(WorkspaceUriResourceMap globalMap) {
        this.globalMap = globalMap;
        this.localContents = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    protected Map<URI, Resource> delegate() {
        return this.globalMap;
    }

    public void clear() {
        this.delegate().keySet().removeAll(this.localContents);
        this.localContents.clear();
    }

    public Resource put(URI key, Resource value) {
        this.localContents.add(key);
        return (Resource)super.put((Object)key, (Object)value);
    }

    public void putAll(Map<? extends URI, ? extends Resource> map) {
        this.localContents.addAll(map.keySet());
        super.putAll(map);
    }

    public boolean remove(Object key, Object value) {
        if (this.localContents.remove(key)) {
            return super.remove(key, value);
        }
        return false;
    }

    public Collection<Resource> values() {
        if (this.localContents.isEmpty()) {
            return Collections.emptyList();
        }
        Collection base = super.values();
        final Collection delegate = Collections2.filter((Collection)base, resource -> this.localContents.contains(resource.getURI()));
        return new ForwardingCollection<Resource>(){

            protected Collection<Resource> delegate() {
                return delegate;
            }

            public Iterator<Resource> iterator() {
                Iterator<URI> delegateIterator = ProjectUriResourceMap.this.localContents.iterator();
                final Iterator resourceIterator = Iterators.transform(delegateIterator, ProjectUriResourceMap.this.globalMap::get);
                return new ForwardingIterator<Resource>(){
                    private URI prev = null;

                    protected Iterator<Resource> delegate() {
                        return resourceIterator;
                    }

                    public Resource next() {
                        Resource result = (Resource)super.next();
                        this.prev = result.getURI();
                        return result;
                    }

                    public void remove() {
                        super.remove();
                        (this).ProjectUriResourceMap.this.globalMap.remove(this.prev);
                    }
                };
            }
        };
    }
}

