/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.eclipse.n4js.ide.xtext.server.concurrent.XAbstractRequest;
import org.eclipse.n4js.ide.xtext.server.concurrent.XRequestManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

public class XReadRequest<V>
extends XAbstractRequest<V> {
    private final Functions.Function1<? super CancelIndicator, ? extends V> readOperation;
    private final CompletableFuture<Void> initializer;
    private final ExecutorService executor;

    public XReadRequest(XRequestManager requestManager, String description, Functions.Function1<? super CancelIndicator, ? extends V> readOperation, ExecutorService executor) {
        super(requestManager, description);
        this.readOperation = readOperation;
        this.executor = executor;
        this.initializer = new CompletableFuture();
        this.initializer.thenRun(this::doRun);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.initializer.cancel(true)) {
            this.cancelResult();
        }
    }

    @Override
    public void run() {
        this.initializer.complete(null);
    }

    private void doRun() {
        if (this.isDone()) {
            return;
        }
        this.executor.submit(() -> {
            try {
                if (this.isDone()) {
                    return;
                }
                this.cancelIndicator.checkCanceled();
                Object readResult = this.readOperation.apply((Object)this.cancelIndicator);
                this.complete(readResult);
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
            }
        });
    }
}

