/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class URIUtils {
    private static final String L = "L/";
    private static final String P = "P/";

    public static IFile convertFileUriToPlatformFile(URI fileUri) {
        if (fileUri.isFile()) {
            String fileString = fileUri.toFileString();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath iPath = Path.fromOSString((String)fileString);
            if (iPath != null) {
                IFile iFile = root.getFileForLocation(iPath);
                return iFile;
            }
        }
        return null;
    }

    public static IContainer convertFileUriToPlatformContainer(URI fileUri) {
        if (fileUri.isFile()) {
            String fileString = fileUri.toFileString();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath iPath = Path.fromOSString((String)fileString);
            if (iPath != null) {
                IContainer iContainer = root.getContainerForLocation(iPath);
                return iContainer;
            }
        }
        return null;
    }

    public static URI convert(IResource iResource) {
        if (iResource == null) {
            return null;
        }
        String projectPath = iResource.toString();
        String fullPathString = iResource.getFullPath().toString();
        URI uri = projectPath.startsWith(P) || projectPath.startsWith(L) ? URI.createPlatformResourceURI((String)fullPathString, (boolean)true) : URI.createFileURI((String)fullPathString);
        return URIUtils.addEmptyAuthority(uri);
    }

    public static URI toFileUri(IResource iResource) {
        URI rUri = URIUtils.convert(iResource);
        return URIUtils.toFileUri(rUri);
    }

    public static boolean isPlatformResourceUriPointingToProject(URI uri) {
        return uri.isPlatformResource() && uri.segmentCount() == 2;
    }

    public static URI deriveProjectURIFromFileLocation(File file) {
        try {
            URI createURI = URI.createURI((String)file.getAbsoluteFile().toURI().toURL().toString());
            String last = createURI.lastSegment();
            if (last != null && last.isEmpty()) {
                createURI = createURI.trimSegments(1);
            }
            return createURI;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URI toFileUri(java.net.URI jnUri) {
        if (jnUri == null) {
            return null;
        }
        File file = new File(jnUri);
        String path = file.getAbsolutePath();
        URI uri = URI.createFileURI((String)path);
        return URIUtils.addEmptyAuthority(uri);
    }

    public static boolean equals(URI uri1, URI uri2) {
        if (uri1 == uri2) {
            return true;
        }
        String string1 = URIUtils.toString(uri1);
        String string2 = URIUtils.toString(uri2);
        return string1.equals(string2);
    }

    public static int hashCode(URI uri) {
        return URIUtils.toString(uri).hashCode();
    }

    public static String toString(URI uri) {
        String result = null;
        if (uri.isFile()) {
            String fileString = uri.toFileString();
            File file = new File(fileString);
            java.nio.file.Path path = file.toPath();
            try {
                String newResult = path.toRealPath(new LinkOption[0]).toFile().toURI().toString();
                if (newResult.endsWith("/")) {
                    newResult = newResult.substring(0, newResult.length() - 1);
                }
                result = newResult;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = uri.toString();
        }
        return result;
    }

    public static URI normalize(URI uri) {
        return URIUtils.addEmptyAuthority(URI.createURI((String)URIUtils.toString(uri)));
    }

    public static URI toFileUri(IProject project) {
        String pathStr = project.getLocation().toString();
        return URIUtils.toFileUri(pathStr);
    }

    public static URI toFileUri(java.nio.file.Path path) {
        return URIUtils.toFileUri(path.toFile());
    }

    public static URI toFileUri(File file) {
        return URIUtils.toFileUri(file.getAbsolutePath());
    }

    public static URI toFileUri(String filePath) {
        URI uri = filePath.startsWith("file:") ? URI.createURI((String)filePath) : URI.createFileURI((String)filePath);
        return URIUtils.addEmptyAuthority(uri);
    }

    public static URI toFileUri(Resource resource) {
        URI rUri = resource.getURI();
        return URIUtils.toFileUri(rUri);
    }

    public static URI toFileUri(URI rUri) {
        URI fileUri = rUri;
        if (!rUri.isFile()) {
            fileUri = CommonPlugin.resolve((URI)rUri);
        }
        return URIUtils.addEmptyAuthority(fileUri);
    }

    public static URI tryToPlatformUri(URI fileUri) {
        if (fileUri.isFile()) {
            java.net.URI jnUri = java.net.URI.create(fileUri.toString());
            IFile[] platformFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(jnUri);
            if (platformFiles.length > 0 && platformFiles[0].isAccessible()) {
                IFile localTargetFile = platformFiles[0];
                URI uri = URIUtils.convert((IResource)localTargetFile);
                if (fileUri.hasFragment()) {
                    uri = uri.appendFragment(fileUri.fragment());
                }
                return uri;
            }
        }
        return fileUri;
    }

    public static URI addEmptyAuthority(URI uri) {
        if (uri.isFile() && !uri.hasAuthority() && !uri.isRelative()) {
            uri = URI.createHierarchicalURI((String)uri.scheme(), (String)"", (String)uri.device(), (String[])uri.segments(), (String)uri.query(), (String)uri.fragment());
        }
        return uri;
    }

    public static java.net.URI toJavaURI(URI uri) throws URISyntaxException {
        return new java.net.URI(uri.toString());
    }

    public static URI toEmfURI(java.net.URI uri) {
        return URI.createURI((String)uri.toString());
    }

    public static File toFile(URI uri) {
        return uri != null && uri.isFile() ? new File(uri.toFileString()) : null;
    }

    public static java.nio.file.Path toPath(URI uri) {
        return URIUtils.toFile(uri).toPath();
    }
}

