/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.JSXElementName;
import org.eclipse.n4js.n4JS.JSXPropertyAttribute;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4jsx.ReactHelper;
import org.eclipse.n4js.organize.imports.RefNameUtil;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ui.organize.imports.ReferenceProxyInfo;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class UnresolveProxyCrossRefHelper {
    @Inject
    private ReactHelper reactHelper;

    public Iterable<ReferenceProxyInfo> findProxyCrossRefInfo(Script script) {
        ResourceType resourceType = ResourceType.getResourceType((EObject)script);
        Iterable<EObject> unresolvedCrossRefs = this.findBrokenCrossRefs(script, resourceType);
        Functions.Function1 _function = it -> {
            String _refName = this.getRefName((EObject)it);
            return new ReferenceProxyInfo((EObject)it, _refName);
        };
        Iterable proxyInfos = IterableExtensions.map(unresolvedCrossRefs, (Functions.Function1)_function);
        return this.filter(proxyInfos, resourceType);
    }

    private Iterable<EObject> findBrokenCrossRefs(Script script, ResourceType resourceType) {
        ArrayList list = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> it.getEObject();
        list.add(IterableExtensions.map((Iterable)Iterables.concat(EcoreUtil.UnresolvedProxyCrossReferencer.find((EObject)script).values()), (Functions.Function1)_function));
        if (resourceType == ResourceType.N4JSX) {
            list.add(this.findBrokenJSXBindings(script));
        }
        return Iterables.concat((Iterable)list);
    }

    private Iterable<ReferenceProxyInfo> filter(Iterable<ReferenceProxyInfo> references, ResourceType resourceType) {
        if (resourceType != null) {
            switch (resourceType) {
                case N4JSX: {
                    Functions.Function1 _function = it -> {
                        boolean _n4jxIsToBeIgnored = this.n4jxIsToBeIgnored((ReferenceProxyInfo)it);
                        return !_n4jxIsToBeIgnored;
                    };
                    return IterableExtensions.filter(references, (Functions.Function1)_function);
                }
            }
            return references;
        }
        return references;
    }

    private boolean n4jxIsToBeIgnored(ReferenceProxyInfo proxyInfo) {
        String usedName = proxyInfo.name;
        boolean _xifexpression = false;
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)usedName);
        _xifexpression = _isNullOrEmpty ? false : Character.isLowerCase(usedName.charAt(0));
        boolean isLikeHTML = _xifexpression;
        if (isLikeHTML) {
            return false;
        }
        EObject refContainer = proxyInfo.eobject.eContainer();
        if (refContainer == null) {
            return false;
        }
        return refContainer instanceof JSXElementName || refContainer instanceof JSXPropertyAttribute;
    }

    private Iterable<JSXElementName> findBrokenJSXBindings(Script script) {
        Functions.Function1 _function = jsxe -> {
            TypeRef _jsxElementBindingType = this.reactHelper.getJsxElementBindingType(jsxe);
            return Pair.of((Object)jsxe, (Object)_jsxElementBindingType);
        };
        Functions.Function1 _function_1 = it -> {
            TypeRef _value = (TypeRef)it.getValue();
            return _value instanceof UnknownTypeRef;
        };
        Functions.Function1 _function_2 = it -> ((JSXElement)it.getKey()).getJsxElementName();
        return IteratorExtensions.toIterable((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)script.eAllContents(), JSXElement.class), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }

    private String getRefName(EObject obj) {
        boolean _matched = false;
        if (obj instanceof IdentifierRef) {
            _matched = true;
            return RefNameUtil.findIdentifierName((IdentifierRef)((IdentifierRef)obj));
        }
        if (!_matched && obj instanceof ParameterizedTypeRef) {
            boolean _not;
            _matched = true;
            String name = RefNameUtil.findTypeName((ParameterizedTypeRef)((ParameterizedTypeRef)obj));
            boolean _isParameterized = ((ParameterizedTypeRef)obj).isParameterized();
            boolean bl = _not = !_isParameterized;
            if (_not) {
                return name;
            }
            int index = name.indexOf("<");
            if (index > -1) {
                return name.substring(0, index);
            }
            return name;
        }
        return NodeModelUtils.getTokenText((INode)NodeModelUtils.getNode((EObject)obj));
    }
}

