/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.ui.adoc;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.jsdoc2spec.CheckCanceled;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.SubMonitorMsg;
import org.eclipse.n4js.jsdoc2spec.adoc.FileSystem;
import org.eclipse.n4js.jsdoc2spec.adoc.JSDoc2ADocSpecProcessor;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecIndexFile;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecModuleFile;
import org.eclipse.n4js.jsdoc2spec.ui.SpecProcessPage;
import org.eclipse.n4js.jsdoc2spec.ui.adoc.ConfigAdoc;
import org.eclipse.n4js.jsdoc2spec.ui.adoc.SpecConfigAdocPage;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

class TaskGenerateAdoc
implements IRunnableWithProgress {
    final JSDoc2ADocSpecProcessor jsDoc2SpecProcessor;
    final IResourceSetProvider resourceSetProvider;
    final IN4JSCore n4JSCore;
    final IStructuredSelection selection;
    final SpecConfigAdocPage configAdocPage;
    final SpecProcessPage processAdocPage;
    final Collection<SpecInfo> specInfos = new LinkedList<SpecInfo>();
    private Set<SpecFile> specChangeSet;
    private ConfigAdoc configAdoc;

    TaskGenerateAdoc(JSDoc2ADocSpecProcessor jsDoc2SpecProcessor, IResourceSetProvider resourceSetProvider, IN4JSCore n4jsCore, IStructuredSelection selection, SpecConfigAdocPage configAdocPage, SpecProcessPage processAdocPage) {
        this.jsDoc2SpecProcessor = jsDoc2SpecProcessor;
        this.resourceSetProvider = resourceSetProvider;
        this.n4JSCore = n4jsCore;
        this.selection = selection;
        this.configAdocPage = configAdocPage;
        this.processAdocPage = processAdocPage;
    }

    void setConfig(ConfigAdoc configAdoc) {
        this.configAdoc = configAdoc;
    }

    Set<SpecFile> getSpecChangeSet() {
        return this.specChangeSet;
    }

    boolean noOrEmptySpecChangeSet() {
        return this.specChangeSet == null || this.specChangeSet.isEmpty();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this.performTasks(monitor);
        }
        catch (InterruptedException e) {
            this.processAdocPage.displayMessage("User canceled tasks.");
        }
        catch (Exception e) {
            this.processAdocPage.displayMessageRed(e.getMessage());
            e.printStackTrace();
        }
    }

    int getPackagesCountTotal() {
        File docRootDir = this.configAdocPage.getConfig().getDocRootDir();
        String packagesDir = docRootDir + FileSystem.SEP + "api-gen" + FileSystem.SEP + "packages";
        ArrayList packageFileNames = FileSystem.getAdocFileNames((String)packagesDir);
        Collections.sort(packageFileNames);
        int changedPackageFiles = 0;
        int updated = 0;
        if (this.specChangeSet != null) {
            for (SpecFile specFile : this.specChangeSet) {
                if (!(specFile instanceof SpecIndexFile)) continue;
                ++changedPackageFiles;
                if (!packageFileNames.contains(specFile.getFile().getName())) continue;
                ++updated;
            }
        }
        return packageFileNames.size() + changedPackageFiles - updated;
    }

    int getModulesCountTotal() {
        File docRootDir = this.configAdocPage.getConfig().getDocRootDir();
        String modulesDir = docRootDir + FileSystem.SEP + "api-gen" + FileSystem.SEP + "modules";
        ArrayList moduleFileNames = FileSystem.getAdocFileNames((String)modulesDir);
        Collections.sort(moduleFileNames);
        int changedModuleFiles = 0;
        int updatedModuleFiles = 0;
        if (this.specChangeSet != null) {
            for (SpecFile specFile : this.specChangeSet) {
                if (!(specFile instanceof SpecModuleFile)) continue;
                ++changedModuleFiles;
                if (!moduleFileNames.contains(specFile.getFile().getName())) continue;
                ++updatedModuleFiles;
            }
        }
        return moduleFileNames.size() + changedModuleFiles - updatedModuleFiles;
    }

    private void performTasks(IProgressMonitor monitor) throws IOException, InterruptedException {
        SubMonitorMsg subMonitor;
        this.jsDoc2SpecProcessor.resetIssues();
        File rootDir = this.configAdoc.getDocRootDir();
        FileSystem.ensureFileStructure((File)rootDir);
        int workload = 0;
        if (this.specInfos.isEmpty()) {
            workload += 2;
        }
        if (this.specChangeSet == null) {
            workload += 2;
        }
        SubMonitor completeProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)workload);
        SubMonitorMsg cmplProgAcceptor = new SubMonitorMsg(completeProgress, this.processAdocPage::displayMessage, this.processAdocPage::displayMessageRed, CheckCanceled::checkUserCanceled);
        if (this.specInfos.isEmpty()) {
            subMonitor = cmplProgAcceptor.newChild(2);
            this.computeTypes(subMonitor);
            subMonitor.done();
        }
        if (this.specChangeSet == null) {
            subMonitor = cmplProgAcceptor.newChild(2);
            this.computeChangeSet(subMonitor);
            subMonitor.done();
        }
        cmplProgAcceptor.subTask("Finished.");
        if (this.specChangeSet.isEmpty()) {
            this.processAdocPage.displayMessage("No Changes found.");
        }
        completeProgress.done();
    }

    private void computeTypes(SubMonitorMsg completeProgress) throws IllegalStateException, InterruptedException {
        Set<IN4JSProject> projects = this.getProjects();
        if (projects.isEmpty()) {
            throw new IllegalStateException("No project selected, cannot export spec");
        }
        completeProgress.subTask("Parsing code base ...");
        Collection m = this.jsDoc2SpecProcessor.readN4JSDs(projects, this.resourceSetMapper(), completeProgress);
        CheckCanceled.checkUserCanceled((IProgressMonitor)completeProgress);
        this.specInfos.addAll(m);
        this.processAdocPage.displayMessageRed(this.jsDoc2SpecProcessor.getWarnings());
        this.jsDoc2SpecProcessor.resetIssues();
    }

    private Set<IN4JSProject> getProjects() {
        HashSet<IN4JSProject> projects = new HashSet<IN4JSProject>();
        for (Object element : this.selection.toList()) {
            if (!(element instanceof IResource)) continue;
            URI uri = URI.createPlatformResourceURI((String)((IResource)element).getFullPath().toString(), (boolean)true);
            Optional optProject = this.n4JSCore.findProject(uri);
            IN4JSProject project = (IN4JSProject)optProject.get();
            projects.add(project);
        }
        return projects;
    }

    private Function<IN4JSProject, ResourceSet> resourceSetMapper() {
        return p -> this.resourceSetProvider.get(((N4JSEclipseProject)p).getProject());
    }

    private void computeChangeSet(SubMonitorMsg completeProgress) throws IOException, InterruptedException {
        this.specChangeSet = new TreeSet<SpecFile>();
        completeProgress.subTask("Reading existing documentation ...");
        SubMonitorMsg readSpecProgress = completeProgress.newChild(1);
        this.jsDoc2SpecProcessor.setRootDir(this.configAdoc.getDocRootDir());
        CheckCanceled.checkUserCanceled((IProgressMonitor)readSpecProgress);
        readSpecProgress.done();
        completeProgress.subTask("Computing updates ...");
        SubMonitorMsg compUpdtsProgress = completeProgress.newChild(1);
        Collection changes = this.jsDoc2SpecProcessor.computeUpdates(this.specInfos, compUpdtsProgress);
        CheckCanceled.checkUserCanceled((IProgressMonitor)compUpdtsProgress);
        compUpdtsProgress.done();
        this.specChangeSet.addAll(changes);
    }
}

