/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONBooleanLiteral;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONFactory;
import org.eclipse.n4js.json.JSON.JSONNumericLiteral;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonHelper;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class ProjectDescriptionLoader {
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private PackageJsonHelper packageJsonHelper;
    private static final Pattern windowsPattern = Pattern.compile("[\\/]");

    public ProjectDescription loadProjectDescriptionAtLocation(SafeURI<?> location) {
        JSONDocument packageJSON = this.loadPackageJSONAtLocation(location);
        if (packageJSON == null) {
            return null;
        }
        return this.loadProjectDescriptionAtLocation(location.toURI(), packageJSON);
    }

    public ProjectDescription loadProjectDescriptionAtLocation(URI location, JSONDocument packageJSON) {
        ProjectDescription pdFromPackageJSON;
        this.adjustMainPath(location, packageJSON);
        String defaultProjectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(location);
        ProjectDescription projectDescription = pdFromPackageJSON = packageJSON != null ? this.packageJsonHelper.convertToProjectDescription(packageJSON, true, defaultProjectName) : null;
        if (pdFromPackageJSON != null) {
            this.setInformationFromFileSystem(location, pdFromPackageJSON);
            return pdFromPackageJSON;
        }
        return null;
    }

    public Pair<String, Boolean> loadVersionAndN4JSNatureFromProjectDescriptionAtLocation(SafeURI<?> location) {
        JSONDocument packageJSON = this.loadPackageJSONAtLocation(location);
        JSONValue versionValue = null;
        boolean hasN4JSNature = false;
        if (packageJSON != null) {
            versionValue = JSONModelUtils.getProperty((JSONDocument)packageJSON, (String)PackageJsonProperties.VERSION.name).orElse(null);
            hasN4JSNature = JSONModelUtils.getProperty((JSONDocument)packageJSON, (String)PackageJsonProperties.N4JS.name).isPresent();
        }
        Pair result = Tuples.create((Object)JSONModelUtils.asNonEmptyStringOrNull(versionValue), (Object)hasN4JSNature);
        return result;
    }

    public List<String> loadWorkspacesFromProjectDescriptionAtLocation(SafeURI<?> location) {
        JSONValue value;
        JSONDocument packageJSON = this.loadPackageJSONAtLocation(location);
        if (packageJSON != null && (value = (JSONValue)JSONModelUtils.getProperty((JSONDocument)packageJSON, (String)PackageJsonProperties.WORKSPACES.name).orElse(null)) instanceof JSONArray) {
            ArrayList<String> result = new ArrayList<String>();
            for (JSONValue element : ((JSONArray)value).getElements()) {
                if (!(element instanceof JSONStringLiteral)) continue;
                result.add(((JSONStringLiteral)element).getValue());
            }
            return result;
        }
        return null;
    }

    private void adjustMainPath(URI location, JSONDocument packageJSON) {
        String[] mainSegments;
        JSONValue content = packageJSON.getContent();
        if (!(content instanceof JSONObject)) {
            return;
        }
        JSONObject contentCasted = (JSONObject)content;
        NameValuePair mainProperty = JSONModelUtils.getNameValuePair((JSONObject)contentCasted, (String)PackageJsonProperties.MAIN.name).orElse(null);
        if (mainProperty == null) {
            return;
        }
        String main = JSONModelUtils.asNonEmptyStringOrNull((JSONValue)mainProperty.getValue());
        if (main == null) {
            return;
        }
        if (File.separatorChar == '/') {
            List splitted = Strings.split((String)main, (char)'/');
            mainSegments = (String[])splitted.toArray(String[]::new);
        } else {
            mainSegments = windowsPattern.split(main);
        }
        URI locationWithMain = location.appendSegments(mainSegments);
        if (!main.endsWith(".js") && this.isFile(URIConverter.INSTANCE, locationWithMain.appendFileExtension("js"))) {
            main = String.valueOf(main) + ".js";
            mainProperty.setValue((JSONValue)JSONModelUtils.createStringLiteral((String)main));
        } else if (this.isDirectory(URIConverter.INSTANCE, locationWithMain)) {
            if (!main.endsWith("/") && !main.endsWith(File.separator)) {
                main = String.valueOf(main) + "/";
            }
            main = String.valueOf(main) + "index.js";
            mainProperty.setValue((JSONValue)JSONModelUtils.createStringLiteral((String)main));
        }
    }

    private void setInformationFromFileSystem(URI location, ProjectDescription target) {
        boolean hasNestedNodeModulesFolder = this.exists(URIConverter.INSTANCE, location.appendSegment("node_modules"));
        target.setHasNestedNodeModulesFolder(hasNestedNodeModulesFolder);
    }

    private JSONDocument loadPackageJSONAtLocation(SafeURI<?> location) {
        Path path = ((SafeURI)location.appendSegment("package.json")).toFileSystemPath();
        if (!Files.isReadable(path) && !Files.isReadable(path = ((SafeURI)location.appendSegment("package.json.xt")).toFileSystemPath())) {
            return null;
        }
        try {
            String jsonString = Files.readString(path, StandardCharsets.UTF_8);
            try {
                JSONDocument doc = JSONFactory.eINSTANCE.createJSONDocument();
                JsonElement jsonElement = new JsonParser().parse(jsonString);
                doc.setContent(this.copy(jsonElement));
                return doc;
            }
            catch (JsonParseException e) {
                JSONDocument packageJSON = this.loadXtextFileAtLocation(location, "package.json", jsonString, JSONDocument.class);
                return packageJSON;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private <T extends EObject> T loadXtextFileAtLocation(SafeURI<?> location, String name, String content, Class<T> expectedTypeOfRoot) {
        block14: {
            Object fullLocation;
            block13: {
                fullLocation = location.appendSegment(name);
                try {
                    if (((SafeURI)fullLocation).exists()) break block13;
                }
                catch (Exception e) {
                    throw new WrappedException("failed to load Xtext file at " + fullLocation, e);
                }
                return null;
            }
            ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
            Resource resource = resourceSet.createResource(((SafeURI)fullLocation).toURI());
            if (resource == null) break block14;
            Throwable throwable = null;
            Object var9_11 = null;
            try (LazyStringInputStream contentAsStream = new LazyStringInputStream(content, StandardCharsets.UTF_8);){
                EObject root;
                resource.load((InputStream)contentAsStream, resourceSet.getLoadOptions());
                EList contents = resource.getContents();
                if (!contents.isEmpty() && expectedTypeOfRoot.isInstance(root = (EObject)contents.get(0))) {
                    EObject rootCasted = (EObject)expectedTypeOfRoot.cast(root);
                    contents.clear();
                    return (T)rootCasted;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private JSONValue copy(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return JSONFactory.eINSTANCE.createJSONNullLiteral();
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                JSONBooleanLiteral result = JSONFactory.eINSTANCE.createJSONBooleanLiteral();
                result.setBooleanValue(primitive.getAsBoolean());
                return result;
            }
            if (primitive.isNumber()) {
                JSONNumericLiteral result = JSONFactory.eINSTANCE.createJSONNumericLiteral();
                result.setValue(primitive.getAsBigDecimal());
                return result;
            }
            if (primitive.isString()) {
                JSONStringLiteral result = JSONFactory.eINSTANCE.createJSONStringLiteral();
                result.setValue(primitive.getAsString());
                return result;
            }
            throw new IllegalArgumentException(jsonElement.toString());
        }
        if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            JSONObject result = JSONFactory.eINSTANCE.createJSONObject();
            for (Map.Entry entry : object.entrySet()) {
                NameValuePair pair = JSONFactory.eINSTANCE.createNameValuePair();
                pair.setName((String)entry.getKey());
                pair.setValue(this.copy((JsonElement)entry.getValue()));
                result.getNameValuePairs().add((Object)pair);
            }
            return result;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            JSONArray result = JSONFactory.eINSTANCE.createJSONArray();
            for (JsonElement arrayElement : array) {
                result.getElements().add((Object)this.copy(arrayElement));
            }
            return result;
        }
        throw new IllegalArgumentException(jsonElement.toString());
    }

    private boolean exists(URIConverter uriConverter, URI uri) {
        return uriConverter.exists(uri, null);
    }

    private boolean isDirectory(URIConverter uriConverter, URI uri) {
        Map attributes = uriConverter.getAttributes(uri, Collections.singletonMap("requestedAttributes", Collections.singleton("directory")));
        boolean isDirectory = Boolean.TRUE.equals(attributes.get("directory"));
        return isDirectory;
    }

    private boolean isFile(URIConverter uriConverter, URI uri) {
        return this.exists(uriConverter, uri) && !this.isDirectory(uriConverter, uri);
    }
}

