/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.hover;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlCreatorExtension;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.genericeditor.hover.CompositeInformationControl;

public class CompositeInformationControlCreator
implements IInformationControlCreator,
IInformationControlCreatorExtension {
    private final LinkedHashMap<ITextHover, IInformationControlCreator> creators;

    public CompositeInformationControlCreator(List<ITextHover> hovers) {
        this.creators = new LinkedHashMap();
        for (ITextHover hover : hovers) {
            this.creators.put(hover, CompositeInformationControlCreator.getInformationControlCreator(hover));
        }
    }

    public CompositeInformationControlCreator(LinkedHashMap<ITextHover, IInformationControlCreator> creators) {
        this.creators = creators;
    }

    private static IInformationControlCreator getInformationControlCreator(ITextHover hover) {
        Object controlCreator = null;
        if (hover instanceof ITextHoverExtension) {
            controlCreator = ((ITextHoverExtension)hover).getHoverControlCreator();
        }
        if (controlCreator == null) {
            controlCreator = new AbstractReusableInformationControlCreator(){

                protected IInformationControl doCreateInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, true);
                }
            };
        }
        return controlCreator;
    }

    public boolean canReuse(IInformationControl control) {
        if (control.getClass() != CompositeInformationControl.class) {
            return false;
        }
        CompositeInformationControl other = (CompositeInformationControl)control;
        if (!other.creators.equals(this.creators)) {
            return false;
        }
        Iterator<Map.Entry<ITextHover, IInformationControlCreator>> thisIterator = this.creators.entrySet().iterator();
        Iterator<Map.Entry<ITextHover, IInformationControl>> otherIterator = other.controls.entrySet().iterator();
        do {
            Map.Entry<ITextHover, IInformationControlCreator> thisEntry = thisIterator.next();
            Map.Entry<ITextHover, IInformationControl> otherEntry = otherIterator.next();
            if (!thisEntry.getKey().equals(otherEntry.getKey())) {
                return false;
            }
            if (!(thisEntry.getValue() instanceof IInformationControlCreatorExtension)) {
                return false;
            }
            if (((IInformationControlCreatorExtension)thisEntry.getValue()).canReuse(otherEntry.getValue())) continue;
            return false;
        } while (thisIterator.hasNext());
        return true;
    }

    public boolean canReplace(IInformationControlCreator creator) {
        if (creator.getClass() != this.getClass()) {
            return false;
        }
        CompositeInformationControlCreator other = (CompositeInformationControlCreator)creator;
        if (other.creators.size() != this.creators.size()) {
            return false;
        }
        Iterator<Map.Entry<ITextHover, IInformationControlCreator>> thisIterator = this.creators.entrySet().iterator();
        Iterator<Map.Entry<ITextHover, IInformationControlCreator>> otherIterator = other.creators.entrySet().iterator();
        do {
            Map.Entry<ITextHover, IInformationControlCreator> thisEntry = thisIterator.next();
            Map.Entry<ITextHover, IInformationControlCreator> otherEntry = otherIterator.next();
            if (!thisEntry.getKey().equals(otherEntry.getKey())) {
                return false;
            }
            if (!(thisEntry.getValue() instanceof IInformationControlCreatorExtension)) {
                return false;
            }
            if (((IInformationControlCreatorExtension)thisEntry.getValue()).canReplace(otherEntry.getValue())) continue;
            return false;
        } while (thisIterator.hasNext());
        return true;
    }

    public IInformationControl createInformationControl(Shell parent) {
        return new CompositeInformationControl(parent, this.creators);
    }
}

