/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.expectation.IExpectationRegion;
import org.eclipse.xpect.expectation.impl.MultiLineExpectationRegion;
import org.eclipse.xpect.expectation.impl.SingleLineExpectationRegion;
import org.eclipse.xpect.parameter.IStatementRelatedRegionProvider;
import org.eclipse.xpect.parameter.StatementRelatedRegionProvider;
import org.eclipse.xpect.text.Text;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@StatementRelatedRegionProvider
public class ExpectationRegionProvider
implements IStatementRelatedRegionProvider {
    @Override
    public IExpectationRegion getRegion(XpectInvocation invocation) {
        int closingSepStart;
        int paramStart;
        ICompositeNode node = NodeModelUtils.getNode((EObject)invocation);
        Text document = new Text(node.getRootNode().getText());
        int paramEnd = document.currentLineEnd(paramStart = node.getOffset() + node.getLength());
        if (paramEnd < 0) {
            paramEnd = document.length();
        }
        String param = document.substring(paramStart, paramEnd);
        String SEP = "-->";
        int slStart = param.indexOf("-->");
        if (slStart >= 0) {
            int tokenStart = slStart + "-->".length();
            if (tokenStart < param.length() && Character.isWhitespace(param.charAt(tokenStart))) {
                ++tokenStart;
            }
            int start = paramStart + tokenStart;
            return new SingleLineExpectationRegion(invocation, document.toString(), start, paramEnd - start, "-->", paramStart + slStart);
        }
        int openingSeparatorEnd = paramEnd;
        while (Character.isWhitespace(document.charAt(openingSeparatorEnd))) {
            --openingSeparatorEnd;
        }
        char separatorChar = document.charAt(openingSeparatorEnd);
        String separator = String.valueOf(separatorChar);
        int i = openingSeparatorEnd - 1;
        while (i >= 0 && document.charAt(i--) == separatorChar) {
            separator = String.valueOf(separator) + separatorChar;
        }
        if (separator.length() > 2 && (closingSepStart = document.indexOf(separator, paramEnd)) >= 0) {
            String indentationPrefix = document.substring(document.currentLineStart(node.getOffset()), node.getOffset());
            int expectationStart = document.nextLineStart(paramStart);
            int expectationEnd = document.previousLineEnd(closingSepStart);
            String indentation = document.findIndentation(indentationPrefix, expectationStart, expectationEnd);
            int lenght = expectationEnd - expectationStart;
            int openingSepOffset = openingSeparatorEnd + 1 - separator.length();
            return new MultiLineExpectationRegion(invocation, document.toString(), expectationStart, lenght, indentation, separator, openingSepOffset, closingSepStart);
        }
        return null;
    }
}

