/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.IfStatement;

class IfFactory {
    IfFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, IfStatement ifStmt) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)ifStmt);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)ifStmt);
        Node conditionNode = DelegatingNodeFactory.createOrHelper(astpp, "condition", (ControlFlowElement)ifStmt, (ControlFlowElement)ifStmt.getExpression());
        HelperNode conditionForkNode = new HelperNode("conditionFork", astpp.pos(), (ControlFlowElement)ifStmt);
        Node thenNode = DelegatingNodeFactory.createOrHelper(astpp, "then", (ControlFlowElement)ifStmt, (ControlFlowElement)ifStmt.getIfStmt());
        DelegatingNode elseNode = DelegatingNodeFactory.create(astpp, "else", (ControlFlowElement)ifStmt, (ControlFlowElement)ifStmt.getElseStmt());
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)ifStmt);
        cNode.addNode(entryNode);
        cNode.addNode(conditionNode);
        cNode.addNode(conditionForkNode);
        cNode.addNode(thenNode);
        cNode.addNode(elseNode);
        cNode.addNode(exitNode);
        cNode.connectInternalSucc(entryNode, conditionNode, conditionForkNode);
        cNode.connectInternalSucc(ControlFlowType.IfTrue, conditionForkNode, thenNode);
        cNode.connectInternalSucc(thenNode, exitNode);
        thenNode.addCatchToken(new CatchToken(ControlFlowType.IfTrue));
        if (ifStmt.getElseStmt() == null) {
            cNode.connectInternalSucc(ControlFlowType.IfFalse, conditionForkNode, exitNode);
            exitNode.addCatchToken(new CatchToken(ControlFlowType.IfFalse));
        } else {
            cNode.connectInternalSucc(ControlFlowType.IfFalse, conditionForkNode, elseNode);
            cNode.connectInternalSucc(elseNode, exitNode);
            elseNode.addCatchToken(new CatchToken(ControlFlowType.IfFalse));
        }
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        return cNode;
    }
}

