/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.xpect.text.Text;
import org.eclipse.xtext.validation.Issue;

public class IssueVisualizer {
    protected String issueToString(Issue issue) {
        StringBuffer result = new StringBuffer();
        result.append(issue.getSeverity().toString().toLowerCase());
        result.append(" - ");
        result.append(new Text(issue.getMessage()).escapeNewLines());
        return result.toString();
    }

    public String visualize(String documentString, Collection<Issue> issues) {
        Text document = new Text(documentString);
        List[] mapped = new List[document.length()];
        ArrayList unmapped = Lists.newArrayList();
        for (Issue issue : issues) {
            if (issue.getOffset() != null && issue.getLength() != null && issue.getOffset() >= 0 && issue.getOffset() < document.length() && issue.getLength() > 0) {
                int max = Math.min(issue.getOffset() + issue.getLength(), document.length());
                int i = issue.getOffset();
                while (i < max) {
                    if (mapped[i] == null) {
                        mapped[i] = Lists.newArrayList((Object[])new Issue[]{issue});
                    } else {
                        mapped[i].add(issue);
                    }
                    ++i;
                }
                continue;
            }
            unmapped.add(issue);
        }
        StringBuffer result = new StringBuffer();
        for (Issue issue : unmapped) {
            if (result.length() > 0) {
                result.append(document.getNL());
            }
            result.append(this.issueToString(issue));
        }
        boolean first = true;
        int offset = 0;
        for (String line : document.splitIntoLines()) {
            if (first) {
                first = false;
            } else {
                result.append(document.getNL());
            }
            result.append(line);
            boolean lineHasIssue = false;
            int i = offset;
            while (i < offset + line.length()) {
                if (mapped[i] != null) {
                    lineHasIssue = true;
                }
                ++i;
            }
            if (lineHasIssue) {
                result.append(document.getNL());
                LinkedHashSet lineIssues = Sets.newLinkedHashSet();
                int i2 = offset;
                while (i2 < offset + line.length()) {
                    if (mapped[i2] != null) {
                        int mark = 0;
                        lineIssues.addAll(mapped[i2]);
                        for (Issue issue : mapped[i2]) {
                            mark += 1 << Iterables.indexOf((Iterable)lineIssues, (Predicate)Predicates.equalTo((Object)issue));
                        }
                        result.append(Integer.toHexString(mark));
                    } else {
                        result.append(document.charAt(i2) == '\t' ? "\t" : " ");
                    }
                    ++i2;
                }
                for (Issue issue : lineIssues) {
                    int id = 1 << Iterables.indexOf((Iterable)lineIssues, (Predicate)Predicates.equalTo((Object)issue));
                    result.append(document.getNL());
                    result.append(id);
                    result.append(": ");
                    result.append(this.issueToString(issue));
                }
            }
            offset += line.length() + document.currentLineEndLenght(offset);
        }
        return result.toString();
    }
}

