/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.imports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ide.imports.ImportDescriptor;
import org.eclipse.n4js.ide.imports.ReferenceDescriptor;
import org.eclipse.n4js.ide.imports.ReferenceResolution;
import org.eclipse.n4js.n4JS.ImportCallExpression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.scoping.IContentAssistScopeProvider;
import org.eclipse.n4js.scoping.imports.PlainAccessOfAliasedImportDescription;
import org.eclipse.n4js.scoping.imports.PlainAccessOfNamespacedImportDescription;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.ide.editor.contentassist.IPrefixMatcher;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

@Singleton
public class ReferenceResolutionFinder {
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IPrefixMatcher prefixMatcher;

    public void findResolutions(ReferenceDescriptor reference, boolean requireFullMatch, boolean isUnresolvedReference, Predicate<String> conflictChecker, Predicate<IEObjectDescription> filter, IResolutionAcceptor acceptor) {
        IContentAssistScopeProvider contentAssistScopeProvider = (IContentAssistScopeProvider)this.scopeProvider;
        IScope scope = contentAssistScopeProvider.getScopeForContentAssist(reference.astNode, reference.eReference);
        Iterable candidates = scope.getAllElements();
        HashSet<URI> candidateURIs = new HashSet<URI>();
        for (IEObjectDescription candidate : candidates) {
            Optional scopeForCollisionCheck;
            ReferenceResolution resolution;
            if (!acceptor.canAcceptMoreProposals()) {
                return;
            }
            if (!filter.apply((Object)candidate) || (resolution = this.getResolution(reference.text, reference.parseTreeNode, requireFullMatch, candidate, (Optional<IScope>)(scopeForCollisionCheck = isUnresolvedReference ? Optional.absent() : Optional.of((Object)scope)), conflictChecker)) == null || !candidateURIs.add(candidate.getEObjectURI())) continue;
            acceptor.accept(resolution);
        }
    }

    private ReferenceResolution getResolution(String text, INode parseTreeNode, boolean requireFullMatch, IEObjectDescription candidate, Optional<IScope> scopeForCollisionCheck, Predicate<String> conflictChecker) {
        ReferenceResolutionCandidate rrc = new ReferenceResolutionCandidate(candidate, scopeForCollisionCheck, text, requireFullMatch, parseTreeNode, conflictChecker);
        if (!rrc.isValid) {
            return null;
        }
        try {
            int version = N4JSResourceDescriptionStrategy.getVersion((IEObjectDescription)candidate);
            String proposal = this.getProposal(rrc);
            String label = this.getLabel(rrc, version);
            String description = this.getDescription(rrc);
            ImportDescriptor importToBeAdded = this.getImportToBeAdded(rrc);
            return new ReferenceResolution(candidate, proposal, label, description, importToBeAdded);
        }
        catch (ValueConverterException valueConverterException) {
            return null;
        }
    }

    private String getProposal(ReferenceResolutionCandidate rrc) {
        switch (rrc.accessType) {
            case alias: {
                return rrc.aliasName;
            }
            case namespace: {
                return rrc.namespaceName.toString();
            }
        }
        if (rrc.newImportHasAlias()) {
            return rrc.addedImportNameAndAlias.alias;
        }
        return rrc.shortName;
    }

    private String getLabel(ReferenceResolutionCandidate rrc, int version) {
        String typeVersion;
        String string = typeVersion = version == 0 ? "" : "#" + String.valueOf(version);
        if (rrc.isAlias()) {
            return String.valueOf(rrc.aliasName) + typeVersion;
        }
        if (rrc.isNamespace()) {
            return rrc.namespaceName + typeVersion;
        }
        if (rrc.newImportHasAlias()) {
            return String.valueOf(rrc.shortName) + typeVersion;
        }
        return String.valueOf(rrc.shortName) + typeVersion;
    }

    private String getDescription(ReferenceResolutionCandidate rrc) {
        if (rrc.isAlias()) {
            return "alias for " + this.qualifiedNameConverter.toString(rrc.qualifiedName);
        }
        if (rrc.isNamespace()) {
            return this.qualifiedNameConverter.toString(rrc.qualifiedName);
        }
        if (rrc.newImportHasAlias()) {
            String descr = "via new alias " + rrc.addedImportNameAndAlias.alias;
            descr = String.valueOf(descr) + " for " + this.qualifiedNameConverter.toString(rrc.qualifiedName);
            descr = String.valueOf(descr) + "\n\n";
            descr = String.valueOf(descr) + "Introduces the new alias '" + rrc.addedImportNameAndAlias.alias;
            descr = String.valueOf(descr) + "' for element " + this.qualifiedNameConverter.toString(rrc.qualifiedName);
            return descr;
        }
        QualifiedName rrcQN = rrc.qualifiedName;
        QualifiedName descrQN = rrcQN.getSegmentCount() > 1 ? rrcQN.skipLast(1) : rrcQN;
        return this.qualifiedNameConverter.toString(descrQN);
    }

    private ImportDescriptor getImportToBeAdded(ReferenceResolutionCandidate rrc) {
        ImportDescriptor importDesc;
        NameAndAlias requestedImport = rrc.addedImportNameAndAlias;
        if (requestedImport == null) {
            return null;
        }
        QualifiedName qualifiedName = requestedImport.name;
        String optionalAlias = requestedImport.alias;
        String projectName = rrc.candidateProject.getProjectName().getRawName();
        QualifiedName moduleName = qualifiedName.skipLast(1);
        String moduleSpecifier = this.qualifiedNameConverter.toString(moduleName);
        if (N4JSLanguageUtils.isDefaultExport((QualifiedName)qualifiedName)) {
            String localName = optionalAlias != null ? optionalAlias : N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)qualifiedName);
            importDesc = ImportDescriptor.createDefaultImport(localName, moduleSpecifier, projectName, moduleName, Integer.MAX_VALUE);
        } else {
            importDesc = ImportDescriptor.createNamedImport(qualifiedName.getLastSegment(), optionalAlias, moduleSpecifier, projectName, moduleName, Integer.MAX_VALUE);
        }
        return importDesc;
    }

    private static enum CandidateAccessType {
        direct,
        alias,
        namespace;

    }

    public static interface IResolutionAcceptor {
        public void accept(ReferenceResolution var1);

        public boolean canAcceptMoreProposals();
    }

    private static class NameAndAlias {
        private final QualifiedName name;
        private final String alias;

        public NameAndAlias(QualifiedName qualifiedName, String alias) {
            this.name = qualifiedName;
            this.alias = alias;
        }
    }

    private class ReferenceResolutionCandidate {
        final IEObjectDescription candidate;
        final IEObjectDescription candidateViaScopeShortName;
        final IN4JSProject candidateProject;
        final boolean isScopedCandidateEqual;
        final boolean isScopedCandidateCollisioning;
        final boolean isValid;
        final EObject parentImportElement;
        final String parentImportModuleName;
        final QualifiedName qualifiedName;
        final String shortName;
        final QualifiedName namespaceName;
        final String aliasName;
        final CandidateAccessType accessType;
        final NameAndAlias addedImportNameAndAlias;

        ReferenceResolutionCandidate(IEObjectDescription candidate, Optional<IScope> scopeForCollisionCheck, String text, boolean requireFullMatch, INode parseTreeNode, Predicate<String> conflictChecker) {
            if (!requireFullMatch && !scopeForCollisionCheck.isPresent()) {
                throw new IllegalArgumentException("collision check should only be omitted if a full match is required");
            }
            this.candidate = candidate;
            this.candidateProject = (IN4JSProject)ReferenceResolutionFinder.this.n4jsCore.findProject(candidate.getEObjectURI()).orNull();
            this.shortName = this.getShortName();
            this.qualifiedName = this.getQualifiedName();
            this.parentImportElement = this.getParentImportElement(parseTreeNode);
            this.parentImportModuleName = this.getParentImportModuleName();
            this.candidateViaScopeShortName = this.getCorrectCandidateViaScope(scopeForCollisionCheck);
            this.isScopedCandidateEqual = this.isEqualCandidateName(this.candidateViaScopeShortName, this.qualifiedName);
            this.isScopedCandidateCollisioning = this.isScopedCandidateCollisioning();
            this.accessType = this.getAccessType();
            this.aliasName = this.getAliasName();
            this.namespaceName = this.getNamespaceName();
            this.addedImportNameAndAlias = this.getImportChanges();
            this.isValid = this.isValid(text, requireFullMatch, conflictChecker);
        }

        private String getShortName() {
            QualifiedName qName = this.candidate.getQualifiedName();
            return N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)qName);
        }

        private boolean isValid(String text, boolean requireFullMatch, Predicate<String> conflictChecker) {
            boolean validName = false;
            validName |= this.isMatch(this.shortName, text, requireFullMatch);
            validName |= this.isAlias() && this.isMatch(this.aliasName, text, requireFullMatch);
            boolean valid = validName |= this.isNamespace() && ReferenceResolutionFinder.this.prefixMatcher.isCandidateMatchingPrefix(this.namespaceName.getLastSegment(), text);
            valid &= !Strings.isNullOrEmpty((String)this.shortName);
            valid &= !conflictChecker.apply((Object)this.shortName);
            return valid &= this.parentImportModuleName == null || this.qualifiedName.toString("/").startsWith(this.parentImportModuleName);
        }

        private boolean isMatch(String name, String text, boolean requireFullMatch) {
            if (requireFullMatch) {
                return text.equals(name);
            }
            return ReferenceResolutionFinder.this.prefixMatcher.isCandidateMatchingPrefix(name, text);
        }

        private QualifiedName getQualifiedName() {
            QualifiedName qnOfEObject;
            QualifiedName qName = this.candidate.getQualifiedName();
            if (qName.toString().equals(this.shortName) && (qnOfEObject = this.getCompleteQualifiedName(this.candidate)) != null) {
                return qnOfEObject;
            }
            return qName;
        }

        private IEObjectDescription getCorrectCandidateViaScope(Optional<IScope> scopeForCollisionCheck) {
            if (scopeForCollisionCheck.isPresent()) {
                IScope scope = (IScope)scopeForCollisionCheck.get();
                IEObjectDescription candidateViaScope = this.getCandidateViaScope(scope);
                candidateViaScope = this.specialcaseNamespaceShadowsOwnElement(scope, candidateViaScope);
                return candidateViaScope;
            }
            return null;
        }

        private IEObjectDescription getCandidateViaScope(IScope scope) {
            ArrayList elements = Lists.newArrayList((Iterable)scope.getElements(QualifiedName.create((String)this.shortName)));
            if (elements.isEmpty()) {
                return null;
            }
            if (elements.size() > 1) {
                for (IEObjectDescription element : elements) {
                    if (!this.isEqualCandidateName(element, this.qualifiedName)) continue;
                    return element;
                }
            }
            if (!elements.isEmpty()) {
                return (IEObjectDescription)elements.get(0);
            }
            return null;
        }

        private IEObjectDescription specialcaseNamespaceShadowsOwnElement(IScope scope, IEObjectDescription candidateViaScope) {
            if (candidateViaScope == null) {
                return candidateViaScope;
            }
            if (this.candidate.getEObjectOrProxy() instanceof ModuleNamespaceVirtualType) {
                return candidateViaScope;
            }
            EObject eObject = candidateViaScope.getEObjectOrProxy();
            if (!(candidateViaScope.getEObjectOrProxy() instanceof ModuleNamespaceVirtualType)) {
                return candidateViaScope;
            }
            ModuleNamespaceVirtualType mnvt = (ModuleNamespaceVirtualType)eObject;
            TModule module = mnvt.getModule();
            if (module == null) {
                return candidateViaScope;
            }
            String moduleQN = module.getQualifiedName();
            String candidateNamespaceName = candidateViaScope.getName().toString();
            if (!candidateNamespaceName.equals(this.shortName)) {
                return candidateViaScope;
            }
            QualifiedName qualifiedNameViaModule = QualifiedName.create((String)moduleQN).append(this.shortName);
            IEObjectDescription shadowedCandidateViaScope = scope.getSingleElement(qualifiedNameViaModule);
            if (shadowedCandidateViaScope == null) {
                return candidateViaScope;
            }
            QualifiedName qualifiedNameViaNamespace = QualifiedName.create((String)candidateNamespaceName).append(this.shortName);
            if (!this.qualifiedName.equals((Object)qualifiedNameViaModule)) {
                return candidateViaScope;
            }
            return new PlainAccessOfNamespacedImportDescription(shadowedCandidateViaScope, qualifiedNameViaNamespace);
        }

        private QualifiedName getCompleteQualifiedName(IEObjectDescription objDescr) {
            if (objDescr == null) {
                return null;
            }
            EObject eObjectOrProxy = objDescr.getEObjectOrProxy();
            if (eObjectOrProxy == null) {
                return null;
            }
            QualifiedName qnOfEObject = ReferenceResolutionFinder.this.qualifiedNameProvider.getFullyQualifiedName(eObjectOrProxy);
            return qnOfEObject;
        }

        private boolean isEqualCandidateName(IEObjectDescription objDescr, QualifiedName qName) {
            QualifiedName qnOfEObject = this.getCompleteQualifiedName(objDescr);
            if (qnOfEObject == null) {
                return false;
            }
            return qnOfEObject.equals((Object)qName);
        }

        private boolean isScopedCandidateCollisioning() {
            QualifiedName candidateNamespaceName;
            String candidateAlias;
            if (this.isScopedCandidateEqual) {
                return false;
            }
            if (this.candidateViaScopeShortName instanceof PlainAccessOfAliasedImportDescription && !this.shortName.equals(candidateAlias = ((PlainAccessOfAliasedImportDescription)this.candidateViaScopeShortName).getAlias())) {
                return false;
            }
            return !(this.candidateViaScopeShortName instanceof PlainAccessOfNamespacedImportDescription) || this.shortName.equals((candidateNamespaceName = ((PlainAccessOfNamespacedImportDescription)this.candidateViaScopeShortName).getNamespacedName()).toString());
        }

        private CandidateAccessType getAccessType() {
            if (this.isScopedCandidateEqual) {
                if (this.candidateViaScopeShortName instanceof PlainAccessOfAliasedImportDescription) {
                    return CandidateAccessType.alias;
                }
                if (this.candidateViaScopeShortName instanceof PlainAccessOfNamespacedImportDescription) {
                    return CandidateAccessType.namespace;
                }
            }
            if (this.candidate instanceof AliasedEObjectDescription) {
                return CandidateAccessType.alias;
            }
            return CandidateAccessType.direct;
        }

        private String getAliasName() {
            if (this.accessType == CandidateAccessType.alias) {
                if (this.candidate instanceof AliasedEObjectDescription) {
                    return this.candidate.getName().toString();
                }
                return ((PlainAccessOfAliasedImportDescription)this.candidateViaScopeShortName).getAlias();
            }
            return null;
        }

        private QualifiedName getNamespaceName() {
            if (this.accessType == CandidateAccessType.namespace) {
                return ((PlainAccessOfNamespacedImportDescription)this.candidateViaScopeShortName).getNamespacedName();
            }
            return null;
        }

        private EObject getParentImportElement(INode parseTreeNode) {
            while (parseTreeNode != null) {
                EObject semanticElement = parseTreeNode.getSemanticElement();
                if (semanticElement instanceof ImportCallExpression || semanticElement instanceof ImportDeclaration) {
                    return semanticElement;
                }
                parseTreeNode = parseTreeNode.getParent();
            }
            return null;
        }

        private String getParentImportModuleName() {
            if (this.parentImportElement instanceof ImportCallExpression) {
                return null;
            }
            if (this.parentImportElement instanceof ImportDeclaration) {
                ImportDeclaration impDecl = (ImportDeclaration)this.parentImportElement;
                return impDecl.getModuleSpecifierAsText();
            }
            return null;
        }

        private NameAndAlias getImportChanges() {
            if (this.parentImportElement != null) {
                return null;
            }
            if (this.accessType != CandidateAccessType.direct) {
                return null;
            }
            QualifiedName importName = this.getImportName();
            if (importName == null) {
                return null;
            }
            if (importName.getSegmentCount() == 1) {
                return null;
            }
            if (importName.getSegmentCount() == 2 && N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT.equals(importName.getFirstSegment())) {
                return null;
            }
            String alias = null;
            if (this.candidateViaScopeShortName != null && this.isScopedCandidateCollisioning) {
                boolean cfr_ignored_0 = this.candidateViaScopeShortName.getEObjectOrProxy() instanceof ModuleNamespaceVirtualType;
                alias = "Alias_" + UtilN4.toUpperCaseFirst((String)this.qualifiedName.toString().replace(".", "_"));
            }
            return new NameAndAlias(importName, alias);
        }

        private QualifiedName getImportName() {
            QualifiedName candidateName;
            String tmodule;
            QualifiedName qfn = this.candidate.getQualifiedName();
            int qfnSegmentCount = qfn.getSegmentCount();
            String string = tmodule = qfnSegmentCount >= 2 ? qfn.getSegment(qfnSegmentCount - 2) : null;
            if (this.candidateProject != null && tmodule != null && tmodule.equals(this.candidateProject.getMainModule())) {
                N4JSProjectName projectName = this.candidateProject.getProjectName();
                N4JSProjectName definesPackage = this.candidateProject.getDefinesPackageName();
                if (definesPackage != null) {
                    projectName = definesPackage;
                }
                String lastSegmentOfQFN = this.candidate.getQualifiedName().getLastSegment().toString();
                candidateName = QualifiedName.create((String[])new String[]{projectName.getRawName(), lastSegmentOfQFN});
            } else {
                candidateName = this.candidate.getQualifiedName();
            }
            return candidateName;
        }

        public boolean hasNewImport() {
            return this.addedImportNameAndAlias != null;
        }

        public boolean newImportHasAlias() {
            return this.hasNewImport() && !Strings.isNullOrEmpty((String)this.addedImportNameAndAlias.alias);
        }

        public boolean isAlias() {
            return this.accessType == CandidateAccessType.alias;
        }

        public boolean isNamespace() {
            return this.accessType == CandidateAccessType.namespace;
        }
    }
}

