/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONFactory;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonBuilder;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.projectDescription.ModuleFilterType;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerType;

public class PackageJSONTestUtils
extends JSONModelUtils {
    public static JSONObject getPackageJSONRoot(Resource resource) {
        if (resource.getContents().isEmpty()) {
            return null;
        }
        EObject firstSlot = (EObject)resource.getContents().get(0);
        if (!(firstSlot instanceof JSONDocument) || !(((JSONDocument)firstSlot).getContent() instanceof JSONObject)) {
            return null;
        }
        JSONDocument document = (JSONDocument)firstSlot;
        return (JSONObject)document.getContent();
    }

    public static void setProjectName(JSONObject root, String name) {
        String path = PackageJsonProperties.NAME.getPath();
        PackageJSONTestUtils.setPath((JSONObject)root, (String)path, (String)name);
    }

    public static void setProjectType(JSONObject root, ProjectType type) {
        String path = PackageJsonProperties.N4JS + "." + PackageJsonProperties.PROJECT_TYPE;
        PackageJSONTestUtils.setPath((JSONObject)root, (String)path, (String)type.getLiteral().toLowerCase());
    }

    public static void addProjectDependency(JSONObject root, String projectName, String versionConstraint) {
        PackageJSONTestUtils.setPath((JSONObject)root, Arrays.asList(PackageJsonProperties.DEPENDENCIES.name, projectName), (JSONValue)PackageJSONTestUtils.createStringLiteral((String)versionConstraint));
    }

    public static void setSourceContainerSpecifiers(JSONObject root, SourceContainerType type, List<String> sourceContainerSpecifiers) {
        JSONObject n4jsSection = PackageJSONTestUtils.getOrCreateN4JSSection(root);
        JSONObject sourcesSection = PackageJSONTestUtils.getOrCreateObject(n4jsSection, PackageJsonProperties.SOURCES);
        PackageJSONTestUtils.setProperty((JSONObject)sourcesSection, (String)type.getLiteral().toLowerCase(), (JSONValue)PackageJSONTestUtils.createStringArray(sourceContainerSpecifiers));
    }

    public static void addSourceContainerSpecifier(JSONObject root, SourceContainerType type, String specifier) {
        JSONObject n4jsSection = PackageJSONTestUtils.getOrCreateN4JSSection(root);
        JSONObject sourcesSection = PackageJSONTestUtils.getOrCreateObject(n4jsSection, PackageJsonProperties.SOURCES);
        String typeLabel = type.getLiteral().toLowerCase();
        JSONArray specifierList = (JSONArray)PackageJSONTestUtils.getProperty((JSONObject)sourcesSection, (String)typeLabel).orElseGet(() -> PackageJSONTestUtils.addProperty((JSONObject)sourcesSection, (String)typeLabel, (JSONValue)JSONFactory.eINSTANCE.createJSONArray()));
        specifierList.getElements().add((Object)PackageJSONTestUtils.createStringLiteral((String)specifier));
    }

    public static void setImplementationId(JSONObject root, String implementationId) {
        String path = PackageJsonProperties.IMPLEMENTATION_ID.getPath();
        PackageJSONTestUtils.setPath((JSONObject)root, (String)path, (String)implementationId);
    }

    public static void setImplementedProjects(JSONObject root, List<String> implementedProjects) {
        String path = PackageJsonProperties.IMPLEMENTED_PROJECTS.getPath();
        PackageJSONTestUtils.setPath((JSONObject)root, (String)path, (JSONValue)PackageJSONTestUtils.createStringArray(implementedProjects));
    }

    public static void setModuleFilters(JSONObject root, ModuleFilterType type, List<String> filterSpecifiers) {
        PackageJSONTestUtils.setPath((JSONObject)root, Arrays.asList(PackageJsonProperties.N4JS.name, PackageJsonProperties.MODULE_FILTERS.name, PackageJSONTestUtils.getStringRepresentation(type)), (JSONValue)PackageJSONTestUtils.createStringArray(filterSpecifiers));
    }

    public static void addModuleFilter(JSONObject root, ModuleFilterType type, String filterSpecifier, String sourceContainer) {
        JSONObject n4jsSection = PackageJSONTestUtils.getOrCreateN4JSSection(root);
        JSONObject moduleFilterSection = PackageJSONTestUtils.getOrCreateObject(n4jsSection, PackageJsonProperties.MODULE_FILTERS);
        JSONArray filterTypeSection = PackageJSONTestUtils.getOrCreateArray(moduleFilterSection, PackageJSONTestUtils.getStringRepresentation(type));
        if (sourceContainer == null) {
            filterTypeSection.getElements().add((Object)PackageJSONTestUtils.createStringLiteral((String)filterSpecifier));
        } else {
            JSONObject filterObject = JSONFactory.eINSTANCE.createJSONObject();
            NameValuePair filterPair = JSONFactory.eINSTANCE.createNameValuePair();
            filterPair.setName(PackageJsonProperties.NV_MODULE.name);
            filterPair.setValue((JSONValue)PackageJSONTestUtils.createStringLiteral((String)filterSpecifier));
            NameValuePair sourceContainerPair = JSONFactory.eINSTANCE.createNameValuePair();
            sourceContainerPair.setName(PackageJsonProperties.NV_SOURCE_CONTAINER.name);
            sourceContainerPair.setValue((JSONValue)PackageJSONTestUtils.createStringLiteral((String)sourceContainer));
            filterObject.getNameValuePairs().add((Object)filterPair);
            filterObject.getNameValuePairs().add((Object)sourceContainerPair);
            filterTypeSection.getElements().add((Object)filterObject);
        }
    }

    public static void removePathFromModuleFilter(JSONObject root, ModuleFilterType type, String filterSpecifier) {
        JSONValue sectionValue;
        Optional moduleFilterSection = PackageJSONTestUtils.getPath((JSONObject)root, Arrays.asList(PackageJsonProperties.N4JS.name, PackageJsonProperties.MODULE_FILTERS.name, PackageJSONTestUtils.getStringRepresentation(type)));
        if (moduleFilterSection.isPresent() && (sectionValue = (JSONValue)moduleFilterSection.get()) instanceof JSONArray) {
            ((JSONArray)sectionValue).getElements().removeIf(path -> path instanceof JSONStringLiteral && ((JSONStringLiteral)path).getValue().equals(filterSpecifier));
        }
    }

    public static PackageJsonBuilder defaultPackageJson(String projectName, String sourceFolder, String outputFolder) {
        return PackageJsonBuilder.newBuilder().withName(projectName).withVersion("0.0.1").withVendorId("org.eclipse.n4js").withVendorName("Eclipse N4JS Project").withType(ProjectType.LIBRARY).withOutput(outputFolder).withSourceContainer(SourceContainerType.SOURCE, sourceFolder);
    }

    private static String getStringRepresentation(ModuleFilterType type) {
        switch (type) {
            case NO_VALIDATE: {
                return "noValidate";
            }
        }
        throw new IllegalStateException("Encountered unknown ModuleFilterType " + type.getName());
    }

    private static JSONArray getOrCreateArray(JSONObject root, String property) {
        return (JSONArray)PackageJSONTestUtils.getProperty((JSONObject)root, (String)property).orElseGet(() -> PackageJSONTestUtils.addProperty((JSONObject)root, (String)property, (JSONValue)JSONFactory.eINSTANCE.createJSONArray()));
    }

    private static JSONObject getOrCreateObject(JSONObject root, PackageJsonProperties property) {
        return (JSONObject)PackageJSONTestUtils.getProperty((JSONObject)root, (String)property.name).orElseGet(() -> PackageJSONTestUtils.addProperty((JSONObject)root, (String)packageJsonProperties.name, (JSONValue)JSONFactory.eINSTANCE.createJSONObject()));
    }

    private static JSONObject getOrCreateN4JSSection(JSONObject root) {
        return PackageJSONTestUtils.getOrCreateObject(root, PackageJsonProperties.N4JS);
    }
}

