/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.factories.ComplexNodeMapper;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DoStatement;
import org.eclipse.n4js.n4JS.ExpressionWithTarget;
import org.eclipse.n4js.n4JS.FinallyBlock;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.SwitchStatement;
import org.eclipse.n4js.n4JS.TryStatement;
import org.eclipse.n4js.n4JS.WhileStatement;
import org.eclipse.xtext.xbase.lib.Pair;

public class CatchNodeFinder {
    private static final CatchEvaluator catchBreakEvaluator = new CatchBreakEvaluator();
    private static final CatchEvaluator catchContinueEvluator = new CatchContinueEvaluator();
    private static final CatchEvaluator catchReturnEvaluator = new CatchReturnEvaluator();
    private static final CatchEvaluator catchThrowEvaluator = new CatchThrowEvaluator();
    private static final CatchEvaluator catchShortCircuitThenEvaluator = new CatchShortCircuitThenEvaluator();
    private static final CatchEvaluator catchShortCircuitElseEvaluator = new CatchShortCircuitElseEvaluator();
    private static final CatchEvaluator catchOptionalChainingEvaluator = new CatchOptionalChainingEvaluator();

    static Pair<Node, ControlFlowType> find(JumpToken jumpToken, Node jumpNode, ComplexNodeMapper cnMapper) {
        CatchEvaluator catchEvaluator = CatchNodeFinder.getCatchEvaluator(jumpToken);
        ControlFlowElement cfe = jumpNode.getControlFlowElement();
        cfe = CatchNodeFinder.skipContainers(cfe);
        ControlFlowElement lastCFE = null;
        while (cfe != null) {
            Pair<Node, ControlFlowType> catcher = CatchNodeFinder.findCatchNode(jumpToken, cfe, lastCFE, catchEvaluator, cnMapper);
            if (catcher != null) {
                return catcher;
            }
            lastCFE = cfe;
            cfe = CatchNodeFinder.getContainer(cfe);
        }
        return null;
    }

    private static CatchEvaluator getCatchEvaluator(JumpToken jumpToken) {
        switch (jumpToken.cfType) {
            case Break: {
                return catchBreakEvaluator;
            }
            case Continue: {
                return catchContinueEvluator;
            }
            case Return: {
                return catchReturnEvaluator;
            }
            case Throw: {
                return catchThrowEvaluator;
            }
            case IfTrue: {
                return catchShortCircuitThenEvaluator;
            }
            case IfFalse: {
                return catchShortCircuitElseEvaluator;
            }
            case IfNullishTarget: {
                return catchOptionalChainingEvaluator;
            }
        }
        throw new IllegalArgumentException("not implemented");
    }

    private static ControlFlowElement skipContainers(ControlFlowElement cfe) {
        if (cfe instanceof Block) {
            cfe = CatchNodeFinder.getContainer(cfe);
        }
        while (FGUtils.isControlStatement(cfe) && !(cfe instanceof Block)) {
            cfe = CatchNodeFinder.getContainer(cfe);
        }
        return cfe;
    }

    private static ControlFlowElement getContainer(ControlFlowElement cfe) {
        EObject container = cfe.eContainer();
        if (container instanceof ControlFlowElement) {
            return (ControlFlowElement)container;
        }
        boolean getNextContainer = false;
        getNextContainer |= container instanceof CatchBlock;
        if (getNextContainer |= container instanceof FinallyBlock) {
            return (ControlFlowElement)container.eContainer();
        }
        return null;
    }

    private static Pair<Node, ControlFlowType> findCatchNode(JumpToken jumpToken, ControlFlowElement cfe, ControlFlowElement lastCFE, CatchEvaluator catchEvaluator, ComplexNodeMapper cnMapper) {
        Node catchAllNode;
        if (catchEvaluator.isCatchingType(cfe)) {
            Node catchNode = catchEvaluator.getCatchingNode(cfe, lastCFE, cnMapper);
            for (CatchToken catchToken : catchNode.catchToken) {
                if (!catchEvaluator.isCatchingToken(cfe, jumpToken, catchToken)) continue;
                ControlFlowType newEdgeType = catchEvaluator.getJumpCatchType(catchToken);
                if (newEdgeType == ControlFlowType.CatchesAll) {
                    newEdgeType = jumpToken.cfType;
                }
                return Pair.of((Object)catchNode, (Object)((Object)newEdgeType));
            }
        }
        if ((catchAllNode = CatchNodeFinder.findCatchAllNode(cfe, cnMapper)) != null) {
            return Pair.of((Object)catchAllNode, (Object)((Object)jumpToken.cfType));
        }
        return null;
    }

    private static Node findCatchAllNode(ControlFlowElement cfe, ComplexNodeMapper cnMapper) {
        if (cfe instanceof TryStatement) {
            return null;
        }
        EObject container = cfe.eContainer();
        if (container instanceof TryStatement) {
            return CatchNodeFinder.findCatchAllNodeInOtherStmt((ControlFlowElement)((TryStatement)container), cnMapper);
        }
        if (container instanceof CatchBlock) {
            return CatchNodeFinder.findCatchAllNodeInOtherStmt((ControlFlowElement)((TryStatement)container.eContainer()), cnMapper);
        }
        if (container instanceof FinallyBlock) {
            return null;
        }
        return CatchNodeFinder.findCatchAllNodeInOtherStmt(cfe, cnMapper);
    }

    private static Node findCatchAllNodeInOtherStmt(ControlFlowElement cfe, ComplexNodeMapper cnMapper) {
        ComplexNode cnCFE = cnMapper.get(cfe);
        for (Node node : cnCFE.getNodes()) {
            for (CatchToken cToken : node.catchToken) {
                if (cToken.cfType != ControlFlowType.CatchesAll) continue;
                return node;
            }
        }
        return null;
    }

    private static class CatchBreakEvaluator
    extends CatchEvaluator {
        private CatchBreakEvaluator() {
        }

        @Override
        public boolean isCatchingType(ControlFlowElement cfe) {
            boolean isCatchingBreakStatement = false;
            isCatchingBreakStatement |= cfe instanceof DoStatement;
            isCatchingBreakStatement |= cfe instanceof ForStatement;
            isCatchingBreakStatement |= cfe instanceof WhileStatement;
            isCatchingBreakStatement |= cfe instanceof SwitchStatement;
            return isCatchingBreakStatement |= cfe instanceof Block && cfe.eContainer() instanceof LabelledStatement;
        }

        @Override
        public Node getCatchingNode(ControlFlowElement cfe, ControlFlowElement lastCFE, ComplexNodeMapper cnMapper) {
            ComplexNode cn = cnMapper.get(cfe);
            return cn.getExit();
        }

        @Override
        public boolean isCatchingToken(ControlFlowElement cfe, JumpToken jumpToken, CatchToken catchToken) {
            boolean isCatchingToken = false;
            isCatchingToken |= jumpToken.lblStmt != null && jumpToken.lblStmt == catchToken.lblStmt;
            isCatchingToken |= jumpToken.lblStmt == null;
            return isCatchingToken &= jumpToken.cfType == catchToken.cfType;
        }
    }

    private static class CatchContinueEvaluator
    extends CatchEvaluator {
        private CatchContinueEvaluator() {
        }

        @Override
        public boolean isCatchingType(ControlFlowElement cfe) {
            boolean isCatchingContinueStatement = false;
            isCatchingContinueStatement |= cfe instanceof DoStatement;
            isCatchingContinueStatement |= cfe instanceof ForStatement;
            return isCatchingContinueStatement |= cfe instanceof WhileStatement;
        }

        @Override
        public Node getCatchingNode(ControlFlowElement cfe, ControlFlowElement lastCFE, ComplexNodeMapper cnMapper) {
            if (cfe instanceof DoStatement) {
                ComplexNode cn = cnMapper.get(cfe);
                Node conditionNode = cn.getNode("condition");
                return conditionNode.getEntry();
            }
            if (cfe instanceof ForStatement) {
                ComplexNode cn = cnMapper.get(cfe);
                Node conditionNode = cn.getNode("continueCatch");
                return conditionNode.getEntry();
            }
            if (cfe instanceof WhileStatement) {
                ComplexNode cn = cnMapper.get(cfe);
                Node conditionNode = cn.getNode("continueCatch");
                return conditionNode.getEntry();
            }
            throw new IllegalStateException("Method 'isCatchingType' should be true first");
        }

        @Override
        public boolean isCatchingToken(ControlFlowElement cfe, JumpToken jumpToken, CatchToken catchToken) {
            boolean isCatchingToken = false;
            isCatchingToken |= jumpToken.lblStmt != null && jumpToken.lblStmt == catchToken.lblStmt;
            return isCatchingToken |= jumpToken.lblStmt == null;
        }
    }

    private static abstract class CatchEvaluator {
        private CatchEvaluator() {
        }

        abstract boolean isCatchingType(ControlFlowElement var1);

        abstract Node getCatchingNode(ControlFlowElement var1, ControlFlowElement var2, ComplexNodeMapper var3);

        abstract boolean isCatchingToken(ControlFlowElement var1, JumpToken var2, CatchToken var3);

        public ControlFlowType getJumpCatchType(CatchToken catchToken) {
            return catchToken.newEdgeType;
        }
    }

    private static class CatchOptionalChainingEvaluator
    extends CatchEvaluator {
        private CatchOptionalChainingEvaluator() {
        }

        @Override
        public boolean isCatchingType(ControlFlowElement cfe) {
            return cfe instanceof ExpressionWithTarget;
        }

        @Override
        public Node getCatchingNode(ControlFlowElement cfe, ControlFlowElement lastCFE, ComplexNodeMapper cnMapper) {
            ComplexNode cn = cnMapper.get(cfe);
            return cn.getExit();
        }

        @Override
        public boolean isCatchingToken(ControlFlowElement cfe, JumpToken jumpToken, CatchToken catchToken) {
            return jumpToken.cfType == catchToken.cfType;
        }
    }

    private static class CatchReturnEvaluator
    extends CatchEvaluator {
        private CatchReturnEvaluator() {
        }

        @Override
        public boolean isCatchingType(ControlFlowElement cfe) {
            return FGUtils.isCFContainer((EObject)cfe);
        }

        @Override
        public Node getCatchingNode(ControlFlowElement cfe, ControlFlowElement lastCFE, ComplexNodeMapper cnMapper) {
            ComplexNode cn = cnMapper.get(cfe);
            return cn.getExit();
        }

        @Override
        public boolean isCatchingToken(ControlFlowElement cfe, JumpToken jumpToken, CatchToken catchToken) {
            return jumpToken.cfType == catchToken.cfType;
        }
    }

    private static class CatchShortCircuitElseEvaluator
    extends CatchEvaluator {
        private CatchShortCircuitElseEvaluator() {
        }

        @Override
        public boolean isCatchingType(ControlFlowElement cfe) {
            boolean isCatching = false;
            isCatching |= cfe instanceof BinaryLogicalExpression;
            isCatching |= cfe instanceof ConditionalExpression;
            isCatching |= cfe instanceof IfStatement;
            isCatching |= cfe instanceof DoStatement;
            isCatching |= cfe instanceof ForStatement;
            return isCatching |= cfe instanceof WhileStatement;
        }

        @Override
        public Node getCatchingNode(ControlFlowElement cfe, ControlFlowElement lastCFE, ComplexNodeMapper cnMapper) {
            if (cfe instanceof ConditionalExpression) {
                ComplexNode cn = cnMapper.get(cfe);
                return cn.getNode("else");
            }
            if (cfe instanceof IfStatement) {
                ComplexNode cn = cnMapper.get(cfe);
                Node elseNode = cn.getNode("else");
                if (elseNode != null) {
                    return elseNode;
                }
                return cn.getNode("exit");
            }
            if (cfe instanceof BinaryLogicalExpression) {
                ComplexNode cn = cnMapper.get(cfe);
                BinaryLogicalExpression ble = (BinaryLogicalExpression)cfe;
                if (ble.getLhs() == lastCFE) {
                    Node potentialCatchNode = cn.getNode("rhs");
                    if (potentialCatchNode.catchToken.get((int)0).cfType == ControlFlowType.IfFalse) {
                        return potentialCatchNode;
                    }
                }
                return cn.getNode("exit");
            }
            ComplexNode cn = cnMapper.get(cfe);
            return cn.getNode("exit");
        }

        @Override
        public boolean isCatchingToken(ControlFlowElement cfe, JumpToken jumpToken, CatchToken catchToken) {
            return jumpToken.cfType == catchToken.cfType;
        }
    }

    private static class CatchShortCircuitThenEvaluator
    extends CatchEvaluator {
        private CatchShortCircuitThenEvaluator() {
        }

        @Override
        public boolean isCatchingType(ControlFlowElement cfe) {
            boolean isCatching = false;
            isCatching |= cfe instanceof BinaryLogicalExpression;
            isCatching |= cfe instanceof ConditionalExpression;
            isCatching |= cfe instanceof IfStatement;
            isCatching |= cfe instanceof DoStatement;
            isCatching |= cfe instanceof ForStatement;
            return isCatching |= cfe instanceof WhileStatement;
        }

        @Override
        public Node getCatchingNode(ControlFlowElement cfe, ControlFlowElement lastCFE, ComplexNodeMapper cnMapper) {
            if (cfe instanceof ConditionalExpression) {
                ComplexNode cn = cnMapper.get(cfe);
                return cn.getNode("then");
            }
            if (cfe instanceof IfStatement) {
                ComplexNode cn = cnMapper.get(cfe);
                return cn.getNode("then");
            }
            if (cfe instanceof DoStatement) {
                ComplexNode cn = cnMapper.get(cfe);
                return cn.getNode("body");
            }
            if (cfe instanceof WhileStatement) {
                ComplexNode cn = cnMapper.get(cfe);
                return cn.getNode("body");
            }
            if (cfe instanceof ForStatement) {
                ComplexNode cn = cnMapper.get(cfe);
                return cn.getNode("body");
            }
            if (cfe instanceof BinaryLogicalExpression) {
                ComplexNode cn = cnMapper.get(cfe);
                BinaryLogicalExpression ble = (BinaryLogicalExpression)cfe;
                if (ble.getLhs() == lastCFE) {
                    Node potentialCatchNode = cn.getNode("rhs");
                    if (potentialCatchNode.catchToken.get((int)0).cfType == ControlFlowType.IfTrue) {
                        return potentialCatchNode;
                    }
                }
                return cn.getNode("exit");
            }
            ComplexNode cn = cnMapper.get(cfe);
            return cn.getNode("exit");
        }

        @Override
        public boolean isCatchingToken(ControlFlowElement cfe, JumpToken jumpToken, CatchToken catchToken) {
            return jumpToken.cfType == catchToken.cfType;
        }
    }

    private static class CatchThrowEvaluator
    extends CatchEvaluator {
        private CatchThrowEvaluator() {
        }

        @Override
        public boolean isCatchingType(ControlFlowElement cfe) {
            boolean isCatchingThrowStatement = FGUtils.isCFContainer((EObject)cfe);
            if (!isCatchingThrowStatement) {
                FinallyBlock finalizer;
                EObject container = cfe.eContainer();
                if (container instanceof TryStatement) {
                    TryStatement tryStmt = (TryStatement)container;
                    Block block = tryStmt.getBlock();
                    CatchBlock catchBlock = tryStmt.getCatch();
                    finalizer = tryStmt.getFinally();
                    isCatchingThrowStatement |= block == cfe && (catchBlock != null || finalizer != null);
                }
                if (container instanceof CatchBlock) {
                    CatchBlock catchBlock = (CatchBlock)container;
                    TryStatement tryStmt = (TryStatement)catchBlock.eContainer();
                    Block block = catchBlock.getBlock();
                    finalizer = tryStmt.getFinally();
                    isCatchingThrowStatement |= block == cfe && finalizer != null;
                }
            }
            return isCatchingThrowStatement;
        }

        @Override
        public Node getCatchingNode(ControlFlowElement cfe, ControlFlowElement lastCFE, ComplexNodeMapper cnMapper) {
            EObject container = cfe.eContainer();
            if (FGUtils.isCFContainer((EObject)cfe)) {
                ComplexNode cnContainer = cnMapper.get(cfe);
                return cnContainer.getExit();
            }
            if (container instanceof TryStatement) {
                TryStatement tryStmt = (TryStatement)container;
                ComplexNode cnTryStmt = cnMapper.get((ControlFlowElement)tryStmt);
                Node catchNode = null;
                if (tryStmt.getCatch() != null) {
                    catchNode = cnTryStmt.getNode("catch");
                }
                if (catchNode == null && tryStmt.getFinally() != null) {
                    catchNode = cnTryStmt.getNode("finally");
                }
                Objects.requireNonNull(catchNode);
                return catchNode;
            }
            if (container instanceof CatchBlock) {
                TryStatement tryStmt = (TryStatement)container.eContainer();
                ComplexNode cnTryStmt = cnMapper.get((ControlFlowElement)tryStmt);
                Node catchNode = cnTryStmt.getNode("finally");
                Objects.requireNonNull(catchNode);
                return catchNode;
            }
            throw new IllegalStateException("Method 'isCatchingType' should be true first");
        }

        @Override
        public boolean isCatchingToken(ControlFlowElement cfe, JumpToken jumpToken, CatchToken catchToken) {
            return jumpToken.cfType == catchToken.cfType;
        }
    }
}

