/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.dialogs.AdditionalMappingsDialog;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ModelOperation
extends TeamOperation {
    private boolean previewRequested;
    private ISynchronizationScopeManager manager;

    public static ModelProvider[] sortByExtension(ModelProvider[] providers) {
        ArrayList<ModelProvider> result = new ArrayList<ModelProvider>();
        ModelProvider[] modelProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider providerToInsert = modelProviderArray[n2];
            int index = result.size();
            int j = 0;
            while (j < result.size()) {
                ModelProvider provider = (ModelProvider)result.get(j);
                if (ModelOperation.extendsProvider(providerToInsert, provider)) {
                    index = j;
                    break;
                }
                ++j;
            }
            result.add(index, providerToInsert);
            ++n2;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }

    private static boolean extendsProvider(ModelProvider providerToInsert, ModelProvider provider) {
        String[] extended;
        String[] stringArray = extended = providerToInsert.getDescriptor().getExtendedModels();
        int n = extended.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(provider.getDescriptor().getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected ModelOperation(IWorkbenchPart part, ISynchronizationScopeManager manager) {
        super(part);
        this.manager = manager;
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(null, 100);
            this.beginOperation(Policy.subMonitorFor((IProgressMonitor)monitor, (int)5));
            this.execute(Policy.subMonitorFor((IProgressMonitor)monitor, (int)90));
        }
        finally {
            this.endOperation(Policy.subMonitorFor((IProgressMonitor)monitor, (int)5));
            monitor.done();
        }
    }

    protected void beginOperation(IProgressMonitor monitor) throws InvocationTargetException {
        this.initializeScope(monitor);
    }

    protected void endOperation(IProgressMonitor monitor) throws InvocationTargetException {
    }

    protected final void initializeScope(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            if (!this.manager.isInitialized()) {
                this.manager.initialize(monitor);
                this.promptIfInputChange(monitor);
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void promptIfInputChange(IProgressMonitor monitor) {
        ISynchronizationScope inputScope = this.getScope().asInputScope();
        if (this.getScope().hasAdditionalMappings()) {
            boolean prompt = false;
            ModelProvider[] inputModelProviders = inputScope.getModelProviders();
            if (this.hasAdditionalMappingsFromIndependantModel(inputModelProviders, this.getScope().getModelProviders())) {
                prompt = true;
            } else if (this.getScope().hasAdditonalResources()) {
                prompt = true;
            } else if (inputModelProviders.length == 1) {
                ResourceMapping[] mappings;
                String modelProviderId = inputModelProviders[0].getDescriptor().getId();
                ResourceMapping[] resourceMappingArray = mappings = this.getScope().getMappings();
                int n = mappings.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceMapping mapping = resourceMappingArray[n2];
                    if (inputScope.getTraversals(mapping) == null) {
                        String id = mapping.getModelProviderId();
                        if (id.equals(modelProviderId) && !modelProviderId.equals("org.eclipse.core.resources.modelProvider")) {
                            prompt = true;
                            break;
                        }
                        if (this.isIndependantModel(modelProviderId, id)) {
                            prompt = true;
                            break;
                        }
                    }
                    ++n2;
                }
            } else {
                ModelProvider[] modelProviderArray = inputModelProviders;
                int n = inputModelProviders.length;
                int n3 = 0;
                while (n3 < n) {
                    ResourceMapping[] scopeMappings;
                    ModelProvider provider = modelProviderArray[n3];
                    String id = provider.getDescriptor().getId();
                    ResourceMapping[] inputMappings = inputScope.getMappings(id);
                    if (inputMappings.length != (scopeMappings = this.getScope().getMappings(id)).length) {
                        ResourceMapping[] resourceMappingArray = scopeMappings;
                        int n4 = scopeMappings.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            ResourceTraversal[] inputModelTraversals;
                            ResourceTraversal[] scopeTraversals;
                            ResourceMapping mapping = resourceMappingArray[n5];
                            ResourceTraversal[] inputTraversals = inputScope.getTraversals(mapping);
                            if (inputTraversals == null && this.overlaps(scopeTraversals = this.getScope().getTraversals(mapping), inputModelTraversals = this.getTraversals(inputScope, inputMappings))) {
                                prompt = true;
                                break;
                            }
                            ++n5;
                        }
                    }
                    ++n3;
                }
            }
            if (prompt) {
                String previewMessage = this.getPreviewRequestMessage();
                this.previewRequested = this.promptForInputChange(previewMessage, monitor);
            }
        }
    }

    protected String getPreviewRequestMessage() {
        return null;
    }

    private boolean hasAdditionalMappingsFromIndependantModel(ModelProvider[] inputModelProviders, ModelProvider[] modelProviders) {
        ModelProvider[] additionalProviders;
        ModelProvider[] modelProviderArray = additionalProviders = this.getAdditionalProviders(inputModelProviders, modelProviders);
        int n = additionalProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider additionalProvider = modelProviderArray[n2];
            boolean independant = true;
            ModelProvider[] modelProviderArray2 = inputModelProviders;
            int n3 = inputModelProviders.length;
            int n4 = 0;
            while (n4 < n3) {
                ModelProvider inputProvider = modelProviderArray2[n4];
                if (!this.isIndependantModel(additionalProvider.getDescriptor().getId(), inputProvider.getDescriptor().getId())) {
                    independant = false;
                }
                ++n4;
            }
            if (independant) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ModelProvider[] getAdditionalProviders(ModelProvider[] inputModelProviders, ModelProvider[] modelProviders) {
        HashSet<ModelProvider> input = new HashSet<ModelProvider>();
        ArrayList<ModelProvider> result = new ArrayList<ModelProvider>();
        input.addAll(Arrays.asList(inputModelProviders));
        ModelProvider[] modelProviderArray = modelProviders;
        int n = modelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider provider = modelProviderArray[n2];
            if (!input.contains(provider)) {
                result.add(provider);
            }
            ++n2;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }

    private boolean overlaps(ResourceTraversal[] scopeTraversals, ResourceTraversal[] inputModelTraversals) {
        ResourceTraversal[] resourceTraversalArray = inputModelTraversals;
        int n = inputModelTraversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal inputTraversal = resourceTraversalArray[n2];
            ResourceTraversal[] resourceTraversalArray2 = scopeTraversals;
            int n3 = scopeTraversals.length;
            int n4 = 0;
            while (n4 < n3) {
                ResourceTraversal scopeTraversal = resourceTraversalArray2[n4];
                if (this.overlaps(inputTraversal, scopeTraversal)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private boolean overlaps(ResourceTraversal inputTraversal, ResourceTraversal scopeTraversal) {
        IResource[] scopeRoots;
        IResource[] inputRoots = inputTraversal.getResources();
        IResource[] iResourceArray = scopeRoots = scopeTraversal.getResources();
        int n = scopeRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource scopeResource = iResourceArray[n2];
            IResource[] iResourceArray2 = inputRoots;
            int n3 = inputRoots.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource inputResource = iResourceArray2[n4];
                if (this.overlaps(scopeResource, scopeTraversal.getDepth(), inputResource, inputTraversal.getDepth())) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private boolean overlaps(IResource scopeResource, int scopeDepth, IResource inputResource, int inputDepth) {
        if (scopeResource.equals((Object)inputResource)) {
            return true;
        }
        if (scopeDepth == 2 && scopeResource.getFullPath().isPrefixOf(inputResource.getFullPath())) {
            return true;
        }
        if (scopeDepth == 1 && scopeResource.equals((Object)inputResource.getParent())) {
            return true;
        }
        if (inputDepth == 2 && inputResource.getFullPath().isPrefixOf(scopeResource.getFullPath())) {
            return true;
        }
        return inputDepth == 1 && inputResource.equals((Object)scopeResource.getParent());
    }

    private ResourceTraversal[] getTraversals(ISynchronizationScope inputScope, ResourceMapping[] inputMappings) {
        CompoundResourceTraversal result = new CompoundResourceTraversal();
        ResourceMapping[] resourceMappingArray = inputMappings;
        int n = inputMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            result.addTraversals(inputScope.getTraversals(mapping));
            ++n2;
        }
        return result.asTraversals();
    }

    private boolean isIndependantModel(String modelProviderId, String id) {
        IModelProviderDescriptor desc2;
        if (id.equals(modelProviderId)) {
            return false;
        }
        IModelProviderDescriptor desc1 = ModelProvider.getModelProviderDescriptor((String)modelProviderId);
        return !this.isExtension(desc1, desc2 = ModelProvider.getModelProviderDescriptor((String)id)) && !this.isExtension(desc2, desc1);
    }

    private boolean isExtension(IModelProviderDescriptor desc1, IModelProviderDescriptor desc2) {
        String id;
        String[] ids;
        String[] stringArray = ids = desc1.getExtendedModels();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            if (id.equals(desc2.getId())) {
                return true;
            }
            ++n2;
        }
        stringArray = ids;
        n = ids.length;
        n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            IModelProviderDescriptor desc3 = ModelProvider.getModelProviderDescriptor((String)id);
            if (this.isExtension(desc3, desc2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean promptForInputChange(String requestPreviewMessage, IProgressMonitor monitor) {
        return this.showAllMappings(requestPreviewMessage);
    }

    private boolean showAllMappings(String requestPreviewMessage) {
        boolean[] canceled = new boolean[1];
        boolean[] forcePreview = new boolean[1];
        Display.getDefault().syncExec(() -> {
            AdditionalMappingsDialog dialog = new AdditionalMappingsDialog(this.getShell(), TeamUIMessages.ResourceMappingOperation_0, this.getScope(), this.getContext());
            dialog.setPreviewMessage(requestPreviewMessage);
            int result = dialog.open();
            boolean bl = blArray[0] = result != 0;
            if (requestPreviewMessage != null) {
                blArray2[0] = dialog.isForcePreview();
            }
        });
        if (canceled[0]) {
            throw new OperationCanceledException();
        }
        return forcePreview[0];
    }

    protected ISynchronizationContext getContext() {
        return null;
    }

    protected abstract void execute(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    public ISynchronizationScope getScope() {
        return this.manager.getScope();
    }

    public boolean isPreviewRequested() {
        return this.previewRequested;
    }

    protected ISynchronizationScopeManager getScopeManager() {
        return this.manager;
    }
}

