/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.organize.imports;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.organize.imports.InjectedTypesResolverUtility;
import org.eclipse.n4js.organize.imports.RefNameUtil;
import org.eclipse.n4js.organize.imports.ScriptDependency;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ScriptDependencyResolver {
    public static List<ScriptDependency> usedDependencies(Script script) {
        List<ScriptDependency> _xblockexpression = null;
        if (script == null) {
            return CollectionLiterals.emptyList();
        }
        _xblockexpression = ScriptDependencyResolver.allRequiredExternalDeclaration(script, Collections.EMPTY_SET, Collections.EMPTY_SET);
        return _xblockexpression;
    }

    public static List<ScriptDependency> usedDependenciesWithInejctedTypes(Script script) {
        List<ScriptDependency> _xblockexpression = null;
        if (script == null) {
            return CollectionLiterals.emptyList();
        }
        _xblockexpression = ScriptDependencyResolver.allRequiredExternalDeclaration(script, InjectedTypesResolverUtility.findAllInjected(script), Collections.EMPTY_SET);
        return _xblockexpression;
    }

    public static List<ScriptDependency> usedDependenciesTypeRefs(Script script) {
        List<ScriptDependency> _xblockexpression = null;
        if (script == null) {
            return CollectionLiterals.emptyList();
        }
        _xblockexpression = ScriptDependencyResolver.allRequiredExternalDeclaration(script, Collections.EMPTY_SET, IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)script.eAllContents(), TypeRef.class)));
        return _xblockexpression;
    }

    private static List<ScriptDependency> allRequiredExternalDeclaration(Script script, Collection<Type> typesToBeIncluded, Collection<TypeRef> typeRefsToBeIncluded) {
        List indirectlyImported = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)script.eAllContents(), N4TypeDeclaration.class));
        List identifierRefs = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)script.eAllContents(), IdentifierRef.class));
        ArrayList potentialDependencies = CollectionLiterals.newArrayList();
        Iterables.addAll((Collection)potentialDependencies, (Iterable)indirectlyImported);
        Iterables.addAll((Collection)potentialDependencies, (Iterable)identifierRefs);
        Iterables.addAll((Collection)potentialDependencies, typesToBeIncluded);
        Iterables.addAll((Collection)potentialDependencies, typeRefsToBeIncluded);
        Functions.Function1 _function = it -> {
            TExportableElement _importedElement = it.getImportedElement();
            return _importedElement != null;
        };
        List namedImportSpecifiers = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)script.eAllContents(), NamedImportSpecifier.class), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> false;
        Map usedNamespaceSpecifiers = IteratorExtensions.toInvertedMap((Iterator)Iterators.filter((Iterator)script.eAllContents(), NamespaceImportSpecifier.class), (Functions.Function1)_function_1);
        TModule baseModule = script.getModule();
        Functions.Function1 _function_2 = it -> {
            Functions.Function1 _function_3 = it_1 -> it_1.getImportedElement().getName();
            Functions.Function1 _function_4 = eo -> ScriptDependencyResolver.shouldBeImported(baseModule, eo);
            return ScriptDependencyResolver.handle(it, IterableExtensions.toMap((Iterable)namedImportSpecifiers, (Functions.Function1)_function_3), usedNamespaceSpecifiers, (Functions.Function1<? super EObject, ? extends Boolean>)_function_4);
        };
        Functions.Function1 _function_3 = it -> it.localName;
        List depsImportedWithName = IterableExtensions.sortBy((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)potentialDependencies, (Functions.Function1)_function_2))))), (Functions.Function1)_function_3);
        return depsImportedWithName;
    }

    public static boolean shouldBeImported(TModule baseModule, EObject eo) {
        boolean _equals;
        boolean _not;
        boolean _tripleNotEquals;
        if (eo instanceof ModuleNamespaceVirtualType) {
            return true;
        }
        if (eo instanceof AnnotableElement) {
            boolean _hasAnnotation = AnnotationDefinition.PROVIDED_BY_RUNTIME.hasAnnotation((AnnotableElement)eo);
            if (_hasAnnotation) {
                return false;
            }
        } else if (eo instanceof TAnnotableElement) {
            boolean _isProvidedByRuntime_1;
            boolean _isProvidedByRuntime;
            boolean _hasAnnotation_1 = AnnotationDefinition.PROVIDED_BY_RUNTIME.hasAnnotation((TAnnotableElement)eo);
            if (_hasAnnotation_1) {
                return false;
            }
            if (eo instanceof Type ? (_isProvidedByRuntime = ((Type)eo).isProvidedByRuntime()) : eo instanceof TVariable && (_isProvidedByRuntime_1 = ((TVariable)eo).isProvidedByRuntime())) {
                return false;
            }
        }
        boolean _and = false;
        boolean _and_1 = false;
        Resource _eResource = eo.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        boolean bl = _tripleNotEquals = _uRI != null;
        if (!_tripleNotEquals) {
            _and_1 = false;
        } else {
            boolean bl2 = _and_1 = eo.eResource().getURI().isFile() || eo.eResource().getURI().isPlatformResource();
        }
        _and = !_and_1 ? false : (_not = !(_equals = eo.eResource().getURI().toString().equals(baseModule.eResource().getURI().toString())));
        return _and;
    }

    private static boolean isNamespaceDependencyHandlingNeeded(Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, TModule targMod) {
        Functions.Function1 _function = is -> {
            EObject _eContainer = is.eContainer();
            TModule _module = ((ImportDeclaration)_eContainer).getModule();
            return _module == targMod;
        };
        return IterableExtensions.exists(usedNamespaceSpecifiers.keySet(), (Functions.Function1)_function);
    }

    private static ScriptDependency createScriptDependency(Type type, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers) {
        ScriptDependency _xifexpression = null;
        boolean _containsKey = nameToNamedImportSpecifiers.containsKey(type.getName());
        if (_containsKey) {
            String _name;
            ScriptDependency _xblockexpression = null;
            NamedImportSpecifier nis = nameToNamedImportSpecifiers.get(type.getName());
            TExportableElement identifiableElement = nis.getImportedElement();
            String _elvis = null;
            String _alias = nis.getAlias();
            _elvis = _alias != null ? _alias : (_name = identifiableElement.getName());
            String _name_1 = identifiableElement.getName();
            EObject _eContainer = identifiableElement.eContainer();
            _xifexpression = _xblockexpression = new ScriptDependency(_elvis, _name_1, (EObject)identifiableElement, (TModule)_eContainer);
        } else {
            ScriptDependency _xifexpression_1 = null;
            boolean _isNamespaceDependencyHandlingNeeded = ScriptDependencyResolver.isNamespaceDependencyHandlingNeeded(usedNamespaceSpecifiers, type.getContainingModule());
            if (_isNamespaceDependencyHandlingNeeded) {
                _xifexpression_1 = ScriptDependencyResolver.createDependencyOnNamespace(usedNamespaceSpecifiers, type.getContainingModule());
            } else {
                String _name = type.getName();
                String _name_1 = type.getName();
                TModule _containingModule = type.getContainingModule();
                _xifexpression_1 = new ScriptDependency(_name, _name_1, (EObject)type, _containingModule);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private static ScriptDependency createDependencyOnNamespace(Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, TModule targMod) {
        ScriptDependency _xblockexpression = null;
        Functions.Function1 _function = is -> {
            EObject _eContainer = is.eContainer();
            TModule _module = ((ImportDeclaration)_eContainer).getModule();
            return _module == targMod;
        };
        NamespaceImportSpecifier is2 = (NamespaceImportSpecifier)IterableExtensions.findFirst(usedNamespaceSpecifiers.keySet(), (Functions.Function1)_function);
        Boolean used = usedNamespaceSpecifiers.get(is2);
        ScriptDependency _xifexpression = null;
        if (!used.booleanValue()) {
            ScriptDependency _xblockexpression_1 = null;
            usedNamespaceSpecifiers.put(is2, true);
            String _alias = is2.getAlias();
            _xifexpression = _xblockexpression_1 = new ScriptDependency(_alias, null, null, targMod);
        } else {
            _xifexpression = null;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static Iterable<ScriptDependency> _handle(EObject eo, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        return CollectionLiterals.newArrayList();
    }

    private static Iterable<ScriptDependency> _handle(TypeRef eo, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        return CollectionLiterals.newArrayList();
    }

    private static Iterable<ScriptDependency> _handle(Void eo, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        return CollectionLiterals.newArrayList();
    }

    private static Iterable<ScriptDependency> _handle(TFunction tFunction, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        return CollectionLiterals.newArrayList();
    }

    private static Iterable<ScriptDependency> _handle(N4ClassDeclaration eo, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        Iterable<ScriptDependency> _xblockexpression = null;
        Type _definedType = eo.getDefinedType();
        TClass tClass = (TClass)_definedType;
        _xblockexpression = ScriptDependencyResolver.handle((EObject)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        return _xblockexpression;
    }

    private static Iterable<ScriptDependency> _handle(N4InterfaceDeclaration eo, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        Iterable<ScriptDependency> _xblockexpression = null;
        Type _definedType = eo.getDefinedType();
        TInterface tInterface = (TInterface)_definedType;
        _xblockexpression = ScriptDependencyResolver.handle((EObject)tInterface, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        return _xblockexpression;
    }

    private static Iterable<ScriptDependency> _handle(ParameterizedTypeRef eo, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        String typeName;
        if (eo.getDeclaredType() != null && eo.getDeclaredType().eContainer() instanceof TModule && ((Boolean)compare.apply((Object)eo.getDeclaredType())).booleanValue() && (typeName = RefNameUtil.findTypeName(eo)) != null) {
            String _name = eo.getDeclaredType().getName();
            Type _declaredType = eo.getDeclaredType();
            EObject _eContainer = eo.getDeclaredType().eContainer();
            ScriptDependency _scriptDependency = new ScriptDependency(typeName, _name, (EObject)_declaredType, (TModule)_eContainer);
            return CollectionLiterals.newArrayList((Object[])new ScriptDependency[]{_scriptDependency});
        }
        return CollectionLiterals.newArrayList();
    }

    private static Iterable<ScriptDependency> _handle(IdentifierRef eo, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        IdentifiableElement _id_3;
        ModuleNamespaceVirtualType namespace;
        TModule targMod;
        boolean _isNamespaceDependencyHandlingNeeded;
        boolean _tripleEquals;
        IdentifiableElement _id = eo.getId();
        boolean bl = _tripleEquals = _id == null;
        if (_tripleEquals) {
            return CollectionLiterals.newArrayList();
        }
        Boolean _apply = (Boolean)compare.apply((Object)eo.getId());
        if (_apply.booleanValue()) {
            String _findIdentifierName = RefNameUtil.findIdentifierName(eo);
            String _name = eo.getId().getName();
            IdentifiableElement _id_1 = eo.getId();
            EObject _eContainer = eo.getId().eContainer();
            ScriptDependency _scriptDependency = new ScriptDependency(_findIdentifierName, _name, (EObject)_id_1, (TModule)_eContainer);
            return CollectionLiterals.newArrayList((Object[])new ScriptDependency[]{_scriptDependency});
        }
        IdentifiableElement _id_2 = eo.getId();
        if (_id_2 instanceof ModuleNamespaceVirtualType && (_isNamespaceDependencyHandlingNeeded = ScriptDependencyResolver.isNamespaceDependencyHandlingNeeded(usedNamespaceSpecifiers, targMod = (namespace = (ModuleNamespaceVirtualType)(_id_3 = eo.getId())).getModule()))) {
            return CollectionLiterals.newArrayList((Object[])new ScriptDependency[]{ScriptDependencyResolver.createDependencyOnNamespace(usedNamespaceSpecifiers, targMod)});
        }
        return CollectionLiterals.newArrayList();
    }

    private static Iterable<ScriptDependency> _handle(TClass tClass, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        ParameterizedTypeRef superClass;
        boolean _not;
        Iterable _xblockexpression = null;
        ArrayList<Object> deps = new ArrayList<Object>();
        deps.add(tClass);
        EList interfaces = tClass.getImplementedInterfaceRefs();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)interfaces);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            Functions.Function1 _function = it -> it.getDeclaredType();
            Iterables.addAll(deps, (Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)interfaces, (Functions.Function1)_function)));
        }
        if ((superClass = tClass.getSuperClassRef()) != null) {
            deps.add(superClass.getDeclaredType());
        }
        Functions.Function1 _function_1 = it -> (Boolean)compare.apply(it);
        Functions.Function1 _function_2 = it -> ScriptDependencyResolver.createScriptDependency(it, nameToNamedImportSpecifiers, usedNamespaceSpecifiers);
        _xblockexpression = IterableExtensions.map((Iterable)IterableExtensions.filter(deps, (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    private static Iterable<ScriptDependency> _handle(TInterface tInterface, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        boolean _not;
        Iterable _xblockexpression = null;
        ArrayList<TInterface> deps = new ArrayList<TInterface>();
        deps.add(tInterface);
        EList rs = tInterface.getSuperInterfaceRefs();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)rs);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            Functions.Function1 _function = it -> it.getDeclaredType();
            Iterables.addAll(deps, (Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)rs, (Functions.Function1)_function)));
        }
        Functions.Function1 _function_1 = it -> (Boolean)compare.apply(it);
        Functions.Function1 _function_2 = it -> ScriptDependencyResolver.createScriptDependency(it, nameToNamedImportSpecifiers, usedNamespaceSpecifiers);
        _xblockexpression = IterableExtensions.map((Iterable)IterableExtensions.filter(deps, (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    private static Iterable<ScriptDependency> handle(EObject tClass, Map<String, NamedImportSpecifier> nameToNamedImportSpecifiers, Map<NamespaceImportSpecifier, Boolean> usedNamespaceSpecifiers, Functions.Function1<? super EObject, ? extends Boolean> compare) {
        if (tClass instanceof TClass && compare != null) {
            return ScriptDependencyResolver._handle((TClass)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass instanceof TInterface && compare != null) {
            return ScriptDependencyResolver._handle((TInterface)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass instanceof N4ClassDeclaration && compare != null) {
            return ScriptDependencyResolver._handle((N4ClassDeclaration)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass instanceof N4InterfaceDeclaration && compare != null) {
            return ScriptDependencyResolver._handle((N4InterfaceDeclaration)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass instanceof TFunction && compare != null) {
            return ScriptDependencyResolver._handle((TFunction)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass instanceof ParameterizedTypeRef && compare != null) {
            return ScriptDependencyResolver._handle((ParameterizedTypeRef)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass instanceof IdentifierRef && compare != null) {
            return ScriptDependencyResolver._handle((IdentifierRef)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass instanceof TypeRef && compare != null) {
            return ScriptDependencyResolver._handle((TypeRef)tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass != null && compare != null) {
            return ScriptDependencyResolver._handle(tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        if (tClass == null && compare != null) {
            return ScriptDependencyResolver._handle(null, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tClass, nameToNamedImportSpecifiers, usedNamespaceSpecifiers, compare).toString());
    }
}

