/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.ui.external.ExternalProjectMappings;
import org.eclipse.n4js.ui.internal.EclipseBasedN4JSWorkspace;
import org.eclipse.n4js.ui.internal.ExternalProjectLoader;
import org.eclipse.xtext.util.Pair;

@Singleton
public class ExternalProjectProvider
implements ExternalLibraryPreferenceStore.StoreUpdatedListener {
    @Inject
    private ExternalProjectLoader cacheLoader;
    @Inject
    private ExternalLibraryPreferenceStore externalLibraryPreferenceStore;
    @Inject
    private EclipseBasedN4JSWorkspace userWorkspace;
    private final Semaphore semaphore = new Semaphore(1);
    private ExternalProjectMappings mappings = new UninitializedMappings();

    @Inject
    ExternalProjectProvider(ExternalLibraryPreferenceStore preferenceStore) {
        preferenceStore.addListener((ExternalLibraryPreferenceStore.StoreUpdatedListener)this);
    }

    Collection<FileURI> getAllProjectLocations() {
        return this.mappings.reducedProjectUriMapping.keySet();
    }

    public void storeUpdated(ExternalLibraryPreferenceStore store, IProgressMonitor monitor) {
        HashSet<FileURI> oldLocations = new HashSet<FileURI>(this.getRootLocationsInReversedShadowingOrder());
        HashSet newLocations = new HashSet(store.getLocations());
        HashSet<FileURI> removedLocations = new HashSet<FileURI>(oldLocations);
        removedLocations.removeAll(newLocations);
        HashSet addedLocations = new HashSet(newLocations);
        addedLocations.removeAll(oldLocations);
    }

    void updateCache() {
        this.updateCacheInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (!this.mappings.initialized) {
            ExternalProjectProvider externalProjectProvider = this;
            synchronized (externalProjectProvider) {
                if (!this.mappings.initialized) {
                    this.updateCacheInternal();
                }
            }
        }
    }

    private synchronized void updateCacheInternal() {
        if (this.semaphore.tryAcquire()) {
            try {
                Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> completeCache = this.computeProjectsUncached();
                this.mappings = new ExternalProjectMappings(this.userWorkspace, this.externalLibraryPreferenceStore, completeCache);
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    Set<N4JSExternalProject> getNecessaryDependencies() {
        this.ensureInitialized();
        return this.mappings.reducedSet;
    }

    Set<FileURI> getAllRootLocations() {
        HashSet<FileURI> allRootLocs = new HashSet<FileURI>();
        allRootLocs.addAll(this.externalLibraryPreferenceStore.getLocations());
        allRootLocs.addAll(this.mappings.reducedProjectsLocationMapping.keySet());
        return allRootLocs;
    }

    Collection<N4JSExternalProject> getProjects() {
        this.ensureInitialized();
        return this.mappings.reducedSet;
    }

    List<Pair<FileURI, ProjectDescription>> computeProjectsIncludingUnnecessary() {
        Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> completeCache = this.computeProjectsUncached();
        ExternalProjectMappings mappingsTmp = new ExternalProjectMappings(this.userWorkspace, this.externalLibraryPreferenceStore, completeCache);
        return mappingsTmp.completeList;
    }

    List<Pair<FileURI, ProjectDescription>> getProjectsIncludingUnnecessary() {
        return this.mappings.completeList;
    }

    private Map<FileURI, Pair<N4JSExternalProject, ProjectDescription>> computeProjectsUncached() {
        LinkedHashMap<FileURI, Pair<N4JSExternalProject, ProjectDescription>> projects = new LinkedHashMap<FileURI, Pair<N4JSExternalProject, ProjectDescription>>();
        Iterable projectRoots = this.externalLibraryPreferenceStore.convertToProjectRootLocations(this.getRootLocationsInReversedShadowingOrder());
        for (FileURI projectLocation : projectRoots) {
            try {
                Pair<N4JSExternalProject, ProjectDescription> pair = this.cacheLoader.load(projectLocation);
                if (pair == null) continue;
                projects.put(projectLocation, pair);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return projects;
    }

    N4JSExternalProject getProject(N4JSProjectName projectName) {
        this.ensureInitialized();
        List<N4JSExternalProject> prjsOfName = this.mappings.completeProjectNameMapping.get(projectName);
        N4JSExternalProject activePrj = prjsOfName == null || prjsOfName.isEmpty() ? null : prjsOfName.get(0);
        return activePrj;
    }

    List<N4JSExternalProject> getProjectsForName(N4JSProjectName projectName) {
        this.ensureInitialized();
        List prjList = this.mappings.completeProjectNameMapping.getOrDefault(projectName, Collections.emptyList());
        return Collections.unmodifiableList(prjList);
    }

    N4JSExternalProject getProject(SafeURI<?> projectLocation) {
        this.ensureInitialized();
        Pair<N4JSExternalProject, ProjectDescription> pair = this.mappings.completeCache.get(projectLocation);
        if (pair != null) {
            return (N4JSExternalProject)pair.getFirst();
        }
        return null;
    }

    Pair<N4JSExternalProject, ProjectDescription> getProjectWithDescription(SafeURI<?> location) {
        this.ensureInitialized();
        return this.mappings.completeCache.get(location);
    }

    Collection<N4JSExternalProject> getProjectsIn(FileURI rootLocation) {
        return this.mappings.reducedProjectsLocationMapping.getOrDefault(rootLocation, Collections.emptyList());
    }

    Collection<FileURI> getRootLocationsInReversedShadowingOrder() {
        Collection locations = this.externalLibraryPreferenceStore.getLocations();
        List locationsInShadowOrder = ExternalLibraryHelper.sortByShadowing((Collection)locations);
        Collections.reverse(locationsInShadowOrder);
        return locationsInShadowOrder;
    }

    private static class UninitializedMappings
    extends ExternalProjectMappings {
        public UninitializedMappings() {
            super(null, null, null, false);
        }
    }
}

