/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.n4js.conversion.N4JSValueConverterException;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class BinaryIntValueConverter
extends AbstractLexerBasedConverter<BigDecimal> {
    protected String toEscapedString(BigDecimal value) {
        return "0b" + value.toBigInteger().toString(2);
    }

    protected void assertValidValue(BigDecimal value) {
        super.assertValidValue((Object)value);
        if (value.signum() == -1) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_BINARYINT_NEGATIVE(this.getRuleName(), value), "VCO_BINARYINT_NEGATIVE", null, null);
        }
    }

    public BigDecimal toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_BINARYINT_CONVERT_EMPTY_STR(), "VCO_BINARYINT_CONVERT_EMPTY_STR", node, null);
        }
        if (string.length() <= 2) {
            throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_BINARYINT_CONVERT_TOO_SHORT(string), "VCO_BINARYINT_CONVERT_TOO_SHORT", node, BigDecimal.ZERO, null);
        }
        try {
            return new BigDecimal(new BigInteger(string.substring(2), 2));
        }
        catch (NumberFormatException e) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_HEXINT_CONVERT_STR(string), "VCO_HEXINT_CONVERT_STR", node, null);
        }
    }
}

