/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.formatting2;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.formatting2.FixedMultilineCommentReplacer;
import org.eclipse.n4js.formatting2.IndentHandlingTextReplaceMerger;
import org.eclipse.n4js.formatting2.N4JSFormatterPreferenceKeys;
import org.eclipse.n4js.formatting2.N4JSGenericFormatter;
import org.eclipse.n4js.formatting2.N4MultilineCommentReplacer;
import org.eclipse.n4js.formatting2.OffMultilineCommentReplacer;
import org.eclipse.n4js.n4JS.AbstractAnnotationList;
import org.eclipse.n4js.n4JS.AbstractCaseClause;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AnnotableExpression;
import org.eclipse.n4js.n4JS.AnnotableN4MemberDeclaration;
import org.eclipse.n4js.n4JS.AnnotablePropertyAssignment;
import org.eclipse.n4js.n4JS.AnnotableScriptElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationList;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FinallyBlock;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.RegularExpressionLiteral;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.n4JS.ShiftExpression;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.SwitchStatement;
import org.eclipse.n4js.n4JS.TaggedTemplateString;
import org.eclipse.n4js.n4JS.TemplateLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.formatting2.TypeExpressionsFormatter;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.StaticBaseTypeRef;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.IMerger;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.SinglelineCodeCommentReplacer;
import org.eclipse.xtext.formatting2.internal.SinglelineDocCommentReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.simpleExpressions.NumberLiteral;

public class N4JSFormatter
extends TypeExpressionsFormatter {
    private static boolean debug = false;
    @Inject
    @Extension
    private N4JSGrammarAccess _n4JSGrammarAccess;
    private static final int PRIO_4 = -7;
    private static final int PRIO_13 = 2;

    private Integer maxConsecutiveNewLines() {
        return (Integer)this.getPreference((TypedPreferenceKey)N4JSFormatterPreferenceKeys.FORMAT_MAX_CONSECUTIVE_NEWLINES);
    }

    protected void _format(Script script, @Extension IFormattableDocument document) {
        N4JSGenericFormatter generic = new N4JSGenericFormatter(this._n4JSGrammarAccess, this.textRegionExtensions);
        Boolean _preference = (Boolean)this.getPreference((TypedPreferenceKey)N4JSFormatterPreferenceKeys.FORMAT_PARENTHESIS);
        _preference.booleanValue();
        generic.formatSemicolons((EObject)script, document);
        generic.formatColon((EObject)script, document);
        this.formatScriptAnnotations(script, document);
        EList _scriptElements = script.getScriptElements();
        for (ScriptElement element : _scriptElements) {
            Procedures.Procedure1 _function = it -> {
                it.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
                it.autowrap();
            };
            document.append((EObject)element, _function);
            document.format((Object)element);
        }
        ImportDeclaration _last = (ImportDeclaration)IterableExtensions.last((Iterable)Iterables.filter((Iterable)script.getScriptElements(), ImportDeclaration.class));
        if (_last != null) {
            Procedures.Procedure1 _function = it -> {
                it.setNewLines(2, 2, 3);
                it.highPriority();
            };
            document.append((EObject)_last, _function);
        }
    }

    public void configureModifiers(EObject semObject, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
            document.append(it, _function_1);
        };
        this.textRegionExtensions.regionFor(semObject).ruleCallsTo(new AbstractRule[]{this._n4JSGrammarAccess.getN4ModifierRule()}).forEach(_function);
    }

    public void configureTypingStrategy(EObject semObject, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
            document.append(it, _function_1);
        };
        this.textRegionExtensions.regionFor(semObject).ruleCallsTo(new AbstractRule[]{this._n4JSGrammarAccess.getTypingStrategyDefSiteOperatorRule(), this._n4JSGrammarAccess.getTypingStrategyUseSiteOperatorRule()}).forEach(_function);
    }

    public void formatTypeVariables(GenericDeclaration semObject, @Extension IFormattableDocument document) {
        boolean _isEmpty = semObject.getTypeVars().isEmpty();
        if (_isEmpty) {
            return;
        }
        Procedures.Procedure1 _function = it -> {
            it.oneSpace();
            it.setNewLines(0);
        };
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)semObject).keyword("<"), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        document.prepend(this.textRegionExtensions.regionFor((EObject)semObject).keyword(">"), _function_2);
        EList _typeVars = semObject.getTypeVars();
        for (TypeVariable typeVar : _typeVars) {
            Procedures.Procedure1 _function_3 = it -> it.noSpace();
            Procedures.Procedure1 _function_4 = it -> it.oneSpace();
            document.append(this.textRegionExtensions.immediatelyFollowing(document.append((EObject)typeVar, _function_3)).keyword(","), _function_4);
            this.format(typeVar, document);
        }
    }

    protected void _format(N4ClassDeclaration clazz, @Extension IFormattableDocument document) {
        boolean _not;
        IAutowrapFormatter _function_1;
        Functions.Function1 _function;
        this.configureAnnotations(clazz, document);
        this.insertSpaceInFrontOfCurlyBlockOpener((EObject)clazz, document);
        this.indentExcludingAnnotations((EObject)clazz, document);
        this.configureTypingStrategy((EObject)clazz, document);
        this.configureModifiers((EObject)clazz, document);
        this.formatTypeVariables((GenericDeclaration)clazz, document);
        final Functions.Function1 twolinesBeforeFirstMember = _function = prio -> {
            Procedures.Procedure1 _function_1 = it -> {
                it.setNewLines(2);
                it.setPriority(prio.intValue());
            };
            return (N4MemberDeclaration)document.prepend((EObject)((N4MemberDeclaration)IterableExtensions.head((Iterable)clazz.getOwnedMembersRaw())), _function_1);
        };
        abstract class __N4JSFormatter_1
        implements IAutowrapFormatter {
            boolean didReconfigure;

            __N4JSFormatter_1() {
            }
        }
        __N4JSFormatter_1 callBackOnAutoWrap = new __N4JSFormatter_1(this){
            {
                this.didReconfigure = false;
            }

            public void format(ITextSegment region, IHiddenRegionFormatting wrapped, IFormattableDocument document) {
                if (!this.didReconfigure) {
                    twolinesBeforeFirstMember.apply((Object)1);
                    this.didReconfigure = true;
                }
            }
        };
        StateTrack state2 = new StateTrack();
        IAutowrapFormatter callBackOnAutoWrap2 = _function_1 = (region, hrFormatting, document2) -> {
            boolean _shouldDoThenDone = state2.shouldDoThenDone();
            if (_shouldDoThenDone) {
                twolinesBeforeFirstMember.apply((Object)1);
            }
        };
        this.suppressUnusedWarnings(callBackOnAutoWrap2);
        Procedures.Procedure1 _function_2 = it -> {
            it.setNewLines(0, 0, 1);
            it.autowrap();
        };
        Procedures.Procedure1 _function_3 = it -> {
            it.oneSpace();
            it.autowrap();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)clazz).keyword("extends"), _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it -> {
            it.setNewLines(0, 0, 1);
            it.autowrap();
            it.setPriority(-1);
            it.setOnAutowrap((IAutowrapFormatter)callBackOnAutoWrap);
        };
        Procedures.Procedure1 _function_5 = it -> {
            it.oneSpace();
            it.autowrap();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)clazz).keyword("implements"), _function_4), _function_5);
        Consumer<ParameterizedTypeRef> _function_6 = it -> {
            Procedures.Procedure1 _function_7 = it_1 -> {
                it_1.autowrap();
                it_1.setPriority(-1);
                it_1.setOnAutowrap((IAutowrapFormatter)callBackOnAutoWrap);
            };
            document.prepend((EObject)it, _function_7);
        };
        IterableExtensions.tail((Iterable)clazz.getImplementedInterfaceRefs()).forEach(_function_6);
        ISemanticRegion kwClass = this.textRegionExtensions.regionFor((EObject)clazz).keyword("class");
        ISemanticRegion kwBrace = this.textRegionExtensions.regionFor((EObject)clazz).keyword("{");
        boolean _contains = ((ILineRegion)IterableExtensions.head((Iterable)kwClass.getLineRegions())).contains((ITextRegion)kwBrace);
        boolean bl = _not = !_contains;
        if (_not) {
            twolinesBeforeFirstMember.apply((Object)0);
        } else {
            Procedures.Procedure1 _function_7 = it -> {
                it.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
                it.autowrap();
            };
            document.prepend((EObject)((N4MemberDeclaration)IterableExtensions.head((Iterable)clazz.getOwnedMembersRaw())), _function_7);
        }
        Procedures.Procedure1 _function_8 = it -> it.oneSpace();
        document.append(kwClass, _function_8);
        EList _ownedMembersRaw = clazz.getOwnedMembersRaw();
        for (N4MemberDeclaration member : _ownedMembersRaw) {
            Procedures.Procedure1 _function_9 = it -> it.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
            document.append((EObject)member, _function_9);
            document.format((Object)member);
        }
        boolean _isEmpty = clazz.getOwnedMembersRaw().isEmpty();
        if (_isEmpty) {
            Procedures.Procedure1 _function_9 = it -> {
                it.noSpace();
                it.setNewLines(0);
            };
            document.append(kwBrace, _function_9);
        }
    }

    protected void _format(N4InterfaceDeclaration interf, @Extension IFormattableDocument document) {
        this.configureAnnotations(interf, document);
        this.configureModifiers((EObject)interf, document);
        this.insertSpaceInFrontOfCurlyBlockOpener((EObject)interf, document);
        this.indentExcludingAnnotations((EObject)interf, document);
        Procedures.Procedure1 _function = it -> it.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
        document.prepend((EObject)((N4MemberDeclaration)IterableExtensions.head((Iterable)interf.getOwnedMembersRaw())), _function);
        EList _ownedMembersRaw = interf.getOwnedMembersRaw();
        for (N4MemberDeclaration member : _ownedMembersRaw) {
            Procedures.Procedure1 _function_1 = it -> it.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
            document.append((EObject)member, _function_1);
            document.format((Object)member);
        }
    }

    protected void _format(N4FieldDeclaration field, @Extension IFormattableDocument document) {
        this.configureAnnotations(field, document);
        this.configureModifiers((EObject)field, document);
        this.indentExcludingAnnotations((EObject)field, document);
        this.configureOptionality(field, document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)field).keyword("="), _function), _function_1);
        document.format((Object)field.getExpression());
        document.format((Object)field.getDeclaredTypeRef());
        document.format((Object)field.getBogusTypeRef());
    }

    protected void _format(FunctionExpression funE, @Extension IFormattableDocument document) {
        this.configureAnnotations(funE, document);
        this.configureModifiers((EObject)funE, document);
        boolean _isArrowFunction = funE.isArrowFunction();
        if (_isArrowFunction) {
            throw new IllegalStateException("Arrow functions should be formated differently.");
        }
        Procedures.Procedure3 _function = ($0, $1, $2) -> {};
        this.configureFormalParameters((EList<FormalParameter>)funE.getFpars(), document, (Procedures.Procedure3<? super ITextSegment, ? super IHiddenRegionFormatting, ? super IFormattableDocument>)_function);
        Pair parenPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)funE).keywordPairs("(", ")"));
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.append((ISemanticRegion)parenPair.getKey(), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.prepend((ISemanticRegion)parenPair.getValue(), _function_2);
        document.format((Object)funE.getBody());
    }

    protected void _format(FunctionOrFieldAccessor fDecl, @Extension IFormattableDocument document) {
        Procedures.Procedure3 _function;
        this.configureAnnotations(fDecl, document);
        this.configureModifiers((EObject)fDecl, document);
        StateTrack state = new StateTrack();
        Procedures.Procedure3 cbInsertEmptyLineInBody = _function = ($0, $1, $2) -> {
            boolean _shouldDoThenDone = state.shouldDoThenDone();
            if (_shouldDoThenDone) {
                Block _body = fDecl.getBody();
                EList _statements = null;
                if (_body != null) {
                    _statements = _body.getStatements();
                }
                Statement _head = null;
                if (_statements != null) {
                    _head = (Statement)IterableExtensions.head((Iterable)_statements);
                }
                Procedures.Procedure1 _function_1 = it -> {
                    it.setNewLines(2, 2, this.maxConsecutiveNewLines().intValue());
                    it.highPriority();
                };
                document.prepend((EObject)_head, _function_1);
            }
        };
        boolean _matched = false;
        if (fDecl instanceof FunctionDefinition) {
            _matched = true;
            this.configureFormalParameters((EList<FormalParameter>)((FunctionDefinition)fDecl).getFpars(), document, (Procedures.Procedure3<? super ITextSegment, ? super IHiddenRegionFormatting, ? super IFormattableDocument>)cbInsertEmptyLineInBody);
        }
        if (!_matched && fDecl instanceof N4SetterDeclaration) {
            _matched = true;
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            Procedures.Procedure1 _function_2 = it -> it.noSpace();
            document.append((EObject)((FormalParameter)document.prepend((EObject)((N4SetterDeclaration)fDecl).getFpar(), _function_1)), _function_2);
        }
        boolean _matched_1 = false;
        if (fDecl instanceof FunctionDeclaration) {
            _matched_1 = true;
            this.formatTypeVariables((GenericDeclaration)fDecl, document);
        }
        if (fDecl instanceof org.eclipse.n4js.n4JS.FieldAccessor) {
            this.configureGetSetKeyword((org.eclipse.n4js.n4JS.FieldAccessor)fDecl, document);
            this.configureOptionality((org.eclipse.n4js.n4JS.FieldAccessor)fDecl, document);
        }
        Pair parenPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)fDecl).keywordPairs("(", ")"));
        Procedures.Procedure1 _function_1 = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.append(document.prepend((ISemanticRegion)parenPair.getKey(), _function_1), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(parenPair, _function_3);
        if (N4JSFormatter.isMultiLine((Pair<ISemanticRegion, ISemanticRegion>)parenPair)) {
            boolean cfr_ignored_0 = fDecl instanceof org.eclipse.n4js.n4JS.FieldAccessor;
        }
        Procedures.Procedure1 _function_4 = it -> it.noSpace();
        document.prepend((ISemanticRegion)parenPair.getValue(), _function_4);
        EList _eContents = fDecl.eContents();
        for (EObject child : _eContents) {
            document.format((Object)child);
        }
    }

    public void configureFormalParameters(EList<FormalParameter> list, @Extension IFormattableDocument document, final Procedures.Procedure3<? super ITextSegment, ? super IHiddenRegionFormatting, ? super IFormattableDocument> x) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Procedures.Procedure2 _function = (it, idx) -> {
            boolean _isHasInitializerAssignment;
            if (idx != 0) {
                Procedures.Procedure1 _function_1 = it_1 -> {
                    it_1.oneSpace();
                    it_1.setNewLines(0, 0, 1);
                    it_1.setOnAutowrap(new IAutowrapFormatter(){

                        public void format(ITextSegment arg0, IHiddenRegionFormatting arg1, IFormattableDocument arg2) {
                            x.apply((Object)arg0, (Object)arg1, (Object)arg2);
                        }
                    });
                };
                document.prepend((EObject)it, _function_1);
            }
            Procedures.Procedure1 _function_2 = it_1 -> it_1.noSpace();
            document.append((EObject)it, _function_2);
            this.configureAnnotationsInLine((FormalParameter)it, document);
            this.format(it.getDeclaredTypeRef(), document);
            boolean _isVariadic = it.isVariadic();
            if (_isVariadic) {
                Procedures.Procedure1 _function_3 = it_1 -> it_1.setNewLines(0);
                Procedures.Procedure1 _function_4 = it_1 -> {
                    it_1.setNewLines(0);
                    it_1.noSpace();
                };
                document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword("..."), _function_3), _function_4);
            }
            if (_isHasInitializerAssignment = it.isHasInitializerAssignment()) {
                boolean _tripleNotEquals;
                Procedures.Procedure1 _function_5 = it_1 -> {
                    it_1.setNewLines(0);
                    it_1.noSpace();
                };
                Procedures.Procedure1 _function_6 = it_1 -> {
                    it_1.setNewLines(0);
                    it_1.noSpace();
                };
                document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword("="), _function_5), _function_6);
                Expression _initializer = it.getInitializer();
                boolean bl = _tripleNotEquals = _initializer != null;
                if (_tripleNotEquals) {
                    this.format(it.getInitializer(), document);
                }
            }
        };
        IterableExtensions.forEach(list, (Procedures.Procedure2)_function);
    }

    public static boolean isMultiLine(Pair<ISemanticRegion, ISemanticRegion> pair) {
        boolean _contains = ((ILineRegion)IterableExtensions.last((Iterable)((ISemanticRegion)pair.getKey()).getLineRegions())).contains((ITextRegion)pair.getValue());
        return !_contains;
    }

    protected void _format(N4EnumDeclaration enumDecl, @Extension IFormattableDocument document) {
        this.configureAnnotations(enumDecl, document);
        this.configureModifiers((EObject)enumDecl, document);
        this.insertSpaceInFrontOfCurlyBlockOpener((EObject)enumDecl, document);
        this.indentExcludingAnnotations((EObject)enumDecl, document);
        this.configureCommas((EObject)enumDecl, document);
        Pair braces = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)enumDecl).keywordPairs("{", "}"));
        boolean multiLine = this.textRegionExtensions.isMultiline((EObject)enumDecl);
        Consumer<N4EnumLiteral> _function = it -> {
            document.format(it);
            if (multiLine) {
                boolean _containsComment = this.textRegionExtensions.regionForEObject((EObject)it).getPreviousHiddenRegion().containsComment();
                if (_containsComment) {
                    Procedures.Procedure1 _function_1 = it_1 -> it_1.setNewLines(2);
                    document.prepend((EObject)it, _function_1);
                } else {
                    Procedures.Procedure1 _function_2 = it_1 -> it_1.newLine();
                    document.prepend((EObject)it, _function_2);
                }
            }
        };
        enumDecl.getLiterals().forEach(_function);
        if (multiLine) {
            Procedures.Procedure1 _function_1 = it -> it.newLine();
            document.prepend((ISemanticRegion)braces.getValue(), _function_1);
        }
    }

    protected void _format(ParameterizedPropertyAccessExpression exp, @Extension IFormattableDocument document) {
        ISemanticRegion dotKW = this.textRegionExtensions.regionFor((EObject)exp).keyword(".");
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.autowrap();
            it.setNewLines(0, 0, 1);
        };
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.append(document.prepend(dotKW, _function), _function_1);
        EObject _eContainer = exp.eContainer();
        if (_eContainer instanceof ExpressionStatement) {
            Procedures.Procedure1 _function_2 = it -> it.indent();
            this.interiorBUGFIX((EObject)exp, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2, document);
        }
        document.format((Object)exp.getTarget());
    }

    protected void _format(ParameterizedCallExpression exp, @Extension IFormattableDocument document) {
        ISemanticRegion dotKW = this.textRegionExtensions.regionFor((EObject)exp).keyword(".");
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.autowrap();
        };
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.append(document.prepend(dotKW, _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)exp).keyword("("), _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)exp).keyword(")"), _function_4);
        this.configureCommas((EObject)exp, document);
        Consumer<Argument> _function_5 = it -> {
            Procedures.Procedure1 _function_6 = it_1 -> {
                it_1.oneSpace();
                it_1.autowrap();
            };
            document.prepend((EObject)it, _function_6);
        };
        IterableExtensions.tail((Iterable)exp.getArguments()).forEach(_function_5);
        Consumer<Argument> _function_6 = it -> document.format(it);
        exp.getArguments().forEach(_function_6);
        EObject _eContainer = exp.eContainer();
        if (_eContainer instanceof ExpressionStatement) {
            Procedures.Procedure1 _function_7 = it -> it.indent();
            this.interiorBUGFIX((EObject)exp, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_7, document);
        }
        document.format((Object)exp.getTarget());
    }

    protected void _format(ImportDeclaration decl, @Extension IFormattableDocument document) {
        Boolean extraSpace = (Boolean)this.getPreference((TypedPreferenceKey)N4JSFormatterPreferenceKeys.FORMAT_SURROUND_IMPORT_LIST_WITH_SPACE);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> {
            if (extraSpace.booleanValue()) {
                it.oneSpace();
            } else {
                it.noSpace();
            }
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)decl).keyword("{"), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> {
            if (extraSpace.booleanValue()) {
                it.oneSpace();
            } else {
                it.noSpace();
            }
        };
        Procedures.Procedure1 _function_3 = it -> {
            it.oneSpace();
            it.setNewLines(0);
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)decl).keyword("}"), _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)decl).keyword("from"), _function_4);
        this.configureCommas((EObject)decl, document);
        Consumer<EObject> _function_5 = it -> document.format(it);
        decl.eContents().forEach(_function_5);
    }

    protected void _format(NamedImportSpecifier namedImp, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)namedImp).keyword("as"), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)namedImp).feature((EStructuralFeature)N4JSPackage.Literals.NAMESPACE_IMPORT_SPECIFIER__DECLARED_DYNAMIC), _function_2), _function_3);
    }

    protected void _format(NamespaceImportSpecifier nsImp, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)nsImp).keyword("*"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)nsImp).keyword("as"), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)nsImp).feature((EStructuralFeature)N4JSPackage.Literals.NAMESPACE_IMPORT_SPECIFIER__DECLARED_DYNAMIC), _function_2), _function_3);
    }

    protected void _format(ExportDeclaration export, @Extension IFormattableDocument document) {
        AnnotationList annoList;
        Procedures.Procedure1 _function = it -> {
            it.oneSpace();
            it.setNewLines(0);
            it.setPriority(2);
        };
        document.append(this.textRegionExtensions.regionFor((EObject)export).keyword("export"), _function);
        Consumer<EObject> _function_1 = it -> document.format(it);
        export.eContents().forEach(_function_1);
        ExportableElement exported = export.getExportedElement();
        if (exported instanceof AnnotableScriptElement && (annoList = ((AnnotableScriptElement)exported).getAnnotationList()) != null && !annoList.getAnnotations().isEmpty()) {
            Procedures.Procedure1 _function_2 = it -> {
                it.setNewLines(0);
                it.oneSpace();
                it.setPriority(2);
            };
            document.append((EObject)((Annotation)IterableExtensions.last((Iterable)annoList.getAnnotations())), _function_2);
        }
    }

    protected void _format(IfStatement stmt, @Extension IFormattableDocument document) {
        Pair parenPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)stmt).keywordPairs("(", ")"));
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.indent();
        };
        document.interior(parenPair, _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.prepend((ISemanticRegion)parenPair.getKey(), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.append((ISemanticRegion)parenPair.getValue(), _function_2);
        Procedures.Procedure1 _function_3 = it -> {
            it.autowrap();
            it.oneSpace();
        };
        Procedures.Procedure1 _function_4 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)stmt).keyword("else"), _function_3), _function_4);
        Procedures.Procedure1 _function_5 = it -> {
            it.oneSpace();
            it.setNewLines(0);
        };
        document.prepend((EObject)stmt.getElseStmt(), _function_5);
        document.format((Object)stmt.getExpression());
        document.format((Object)stmt.getIfStmt());
        document.format((Object)stmt.getElseStmt());
    }

    protected void _format(SwitchStatement swStmt, @Extension IFormattableDocument document) {
        this.insertSpaceInFrontOfCurlyBlockOpener((EObject)swStmt, document);
        Procedures.Procedure1 _function = it -> it.indent();
        this.interiorBUGFIX((EObject)swStmt, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function, document);
        document.format((Object)swStmt.getExpression());
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.prepend((EObject)((AbstractCaseClause)IterableExtensions.head((Iterable)swStmt.getCases())), _function_1);
        Consumer<AbstractCaseClause> _function_2 = it -> document.format(it);
        swStmt.getCases().forEach(_function_2);
    }

    protected void _format(AbstractCaseClause caseClause, @Extension IFormattableDocument document) {
        boolean _equals;
        Procedures.Procedure1 _function = it -> it.indent();
        this.interiorBUGFIX((EObject)caseClause, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function, document);
        int _size = caseClause.getStatements().size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            Statement _head = (Statement)IterableExtensions.head((Iterable)caseClause.getStatements());
            if (_head instanceof Block) {
                Procedures.Procedure1 _function_1 = it -> it.setNewLines(0, 0, 0);
                document.prepend((EObject)((Statement)IterableExtensions.head((Iterable)caseClause.getStatements())), _function_1);
            } else {
                Procedures.Procedure1 _function_2 = it -> it.setNewLines(0, 1, 1);
                document.prepend((EObject)((Statement)IterableExtensions.head((Iterable)caseClause.getStatements())), _function_2);
            }
        } else {
            Procedures.Procedure1 _function_3 = it -> it.setNewLines(1, 1, 1);
            document.prepend((EObject)((Statement)IterableExtensions.head((Iterable)caseClause.getStatements())), _function_3);
        }
        Consumer<Statement> _function_4 = it -> document.format(it);
        caseClause.getStatements().forEach(_function_4);
        Consumer<Statement> _function_5 = it -> {
            Procedures.Procedure1 _function_6 = it_1 -> it_1.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
            document.append((EObject)it, _function_6);
        };
        caseClause.getStatements().forEach(_function_5);
        Procedures.Procedure1 _function_6 = it -> it.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
        document.append((EObject)caseClause, _function_6);
    }

    protected void _format(CastExpression expr, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(0);
            it.oneSpace();
        };
        Procedures.Procedure1 _function_1 = it -> {
            it.setNewLines(0);
            it.oneSpace();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword("as"), _function), _function_1);
        document.format((Object)expr.getExpression());
        document.format((Object)expr.getTargetTypeRef());
    }

    protected void _format(Block block, @Extension IFormattableDocument document) {
        boolean _not;
        if (debug) {
            String _containmentStructure = N4JSFormatter.containmentStructure((EObject)block);
            String _plus = "Formatting block " + _containmentStructure;
            InputOutput.println((Object)_plus);
        }
        boolean bl = _not = !(block.eContainer() instanceof Block) && !(block.eContainer() instanceof Script);
        if (_not) {
            Procedures.Procedure1 _function = it -> it.oneSpace();
            document.prepend(this.textRegionExtensions.regionFor((EObject)block).keyword("{"), _function);
        }
        Procedures.Procedure1 _function_1 = it -> it.indent();
        this.interiorBUGFIX((EObject)block, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1, document);
        Procedures.Procedure1 _function_2 = it -> it.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
        document.prepend((EObject)((Statement)IterableExtensions.head((Iterable)block.getStatements())), _function_2);
        Consumer<Statement> _function_3 = it -> {
            Procedures.Procedure1 _function_4 = it_1 -> it_1.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
            document.append((EObject)it, _function_4);
        };
        block.getStatements().forEach(_function_3);
        Consumer<Statement> _function_4 = it -> document.format(it);
        block.getStatements().forEach(_function_4);
        Pair braces = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)block).keywordPairs("{", "}"));
        if (braces != null && Objects.equal((Object)((ISemanticRegion)braces.getKey()).getNextSemanticRegion(), (Object)braces.getValue())) {
            boolean _containsComment = ((ISemanticRegion)braces.getKey()).getNextHiddenRegion().containsComment();
            if (_containsComment) {
                Procedures.Procedure1 _function_5 = it -> it.setNewLines(1, 1, this.maxConsecutiveNewLines().intValue());
                document.append((ISemanticRegion)braces.getKey(), _function_5);
            } else {
                Procedures.Procedure1 _function_6 = it -> {
                    it.setNewLines(0);
                    it.noSpace();
                };
                document.append((ISemanticRegion)braces.getKey(), _function_6);
            }
        }
    }

    protected void _format(ReturnStatement ret, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.indent();
        this.interiorBUGFIX((EObject)ret, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function, document);
        Procedures.Procedure1 _function_1 = it -> {
            it.oneSpace();
            it.setNewLines(0);
        };
        document.prepend((EObject)ret.getExpression(), _function_1);
        document.format((Object)ret.getExpression());
    }

    protected void _format(AdditiveExpression add, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.autowrap();
        document.append(document.surround(this.textRegionExtensions.regionFor((EObject)add).feature((EStructuralFeature)N4JSPackage.Literals.ADDITIVE_EXPRESSION__OP), _function), _function_1);
        document.format((Object)add.getLhs());
        document.format((Object)add.getRhs());
    }

    protected void _format(MultiplicativeExpression mul, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.autowrap();
        document.append(document.surround(this.textRegionExtensions.regionFor((EObject)mul).feature((EStructuralFeature)N4JSPackage.Literals.MULTIPLICATIVE_EXPRESSION__OP), _function), _function_1);
        document.format((Object)mul.getLhs());
        document.format((Object)mul.getRhs());
    }

    protected void _format(BinaryBitwiseExpression binbit, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)binbit).feature((EStructuralFeature)N4JSPackage.Literals.BINARY_BITWISE_EXPRESSION__OP), _function);
        document.format((Object)binbit.getLhs());
        document.format((Object)binbit.getRhs());
    }

    protected void _format(BinaryLogicalExpression binLog, @Extension IFormattableDocument document) {
        ISemanticRegion opReg = this.textRegionExtensions.regionFor((EObject)binLog).feature((EStructuralFeature)N4JSPackage.Literals.BINARY_LOGICAL_EXPRESSION__OP);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(opReg, _function);
        document.format((Object)binLog.getLhs());
        document.format((Object)binLog.getRhs());
        Boolean autoWrapInFront = (Boolean)this.getPreference((TypedPreferenceKey)N4JSFormatterPreferenceKeys.FORMAT_AUTO_WRAP_IN_FRONT_OF_LOGICAL_OPERATOR);
        if (autoWrapInFront.booleanValue()) {
            Procedures.Procedure1 _function_1 = it -> {
                it.autowrap();
                it.lowPriority();
                it.setNewLines(0, 0, 1);
            };
            document.prepend(opReg, _function_1);
        } else {
            Procedures.Procedure1 _function_2 = it -> {
                it.autowrap();
                it.lowPriority();
                it.setNewLines(0, 0, 1);
            };
            document.append(opReg, _function_2);
        }
    }

    protected void _format(EqualityExpression eqExpr, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.autowrap();
        document.append(document.surround(this.textRegionExtensions.regionFor((EObject)eqExpr).feature((EStructuralFeature)N4JSPackage.Literals.EQUALITY_EXPRESSION__OP), _function), _function_1);
        document.format((Object)eqExpr.getLhs());
        document.format((Object)eqExpr.getRhs());
    }

    protected void _format(RelationalExpression relExpr, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.autowrap();
        document.append(document.surround(this.textRegionExtensions.regionFor((EObject)relExpr).feature((EStructuralFeature)N4JSPackage.Literals.RELATIONAL_EXPRESSION__OP), _function), _function_1);
        document.format((Object)relExpr.getLhs());
        document.format((Object)relExpr.getRhs());
    }

    protected void _format(ShiftExpression shiftExpr, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.autowrap();
        document.append(document.surround(this.textRegionExtensions.regionFor((EObject)shiftExpr).feature((EStructuralFeature)N4JSPackage.Literals.SHIFT_EXPRESSION__OP), _function), _function_1);
        document.format((Object)shiftExpr.getLhs());
        document.format((Object)shiftExpr.getRhs());
    }

    protected void _format(CommaExpression comma, @Extension IFormattableDocument document) {
        this.configureCommas((EObject)comma, document);
        Consumer<EObject> _function = it -> document.format(it);
        comma.eContents().forEach(_function);
    }

    protected void _format(ConditionalExpression cond, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> {
            it.autowrap();
            it.lowPriority();
            it.setNewLines(0, 0, 1);
        };
        document.append(document.surround(this.textRegionExtensions.regionFor((EObject)cond).keyword("?"), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        Procedures.Procedure1 _function_3 = it -> {
            it.autowrap();
            it.lowPriority();
            it.setNewLines(0, 0, 1);
        };
        document.append(document.surround(this.textRegionExtensions.regionFor((EObject)cond).keyword(":"), _function_2), _function_3);
        document.format((Object)cond.getExpression());
        document.format((Object)cond.getTrueExpression());
        document.format((Object)cond.getFalseExpression());
    }

    protected void _format(AwaitExpression await, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> {
            it.oneSpace();
            it.setNewLines(0);
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)await).keyword("await"), _function), _function_1);
        document.format((Object)await.getExpression());
    }

    protected void _format(PromisifyExpression promify, @Extension IFormattableDocument document) {
        this.noSpaceAfterAT((EObject)promify, document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)promify).keyword("Promisify"), _function);
        document.format((Object)promify.getExpression());
    }

    protected void _format(IndexedAccessExpression idxAcc, @Extension IFormattableDocument document) {
        IEObjectRegion indexRegion = this.textRegionExtensions.regionForEObject((EObject)idxAcc.getIndex());
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        Procedures.Procedure1 _function_1 = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        document.append(document.prepend(indexRegion.getPreviousSemanticRegion(), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.prepend(indexRegion.getNextSemanticRegion(), _function_2);
        document.format((Object)idxAcc.getIndex());
        document.format((Object)idxAcc.getTarget());
    }

    protected void _format(NewExpression newExp, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> {
            it.oneSpace();
            it.setNewLines(0);
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)newExp).keyword("new"), _function), _function_1);
        document.format((Object)newExp.getCallee());
        ISemanticRegion commas = this.textRegionExtensions.regionFor((EObject)newExp).keyword(",");
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.append(document.prepend(commas, _function_2), _function_3);
        Pair typeArgsAngle = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)newExp).keywordPairs("<", ">"));
        if (typeArgsAngle != null) {
            Procedures.Procedure1 _function_4 = it -> {
                it.noSpace();
                it.setNewLines(0);
            };
            Procedures.Procedure1 _function_5 = it -> {
                it.noSpace();
                it.setNewLines(0);
            };
            document.prepend(document.append((ISemanticRegion)typeArgsAngle.getKey(), _function_4), _function_5);
            Procedures.Procedure1 _function_6 = it -> {
                it.noSpace();
                it.setNewLines(0);
            };
            document.prepend((ISemanticRegion)typeArgsAngle.getValue(), _function_6);
        }
        Consumer<TypeRef> _function_7 = it -> document.format(it);
        newExp.getTypeArgs().forEach(_function_7);
        boolean _isWithArgs = newExp.isWithArgs();
        if (_isWithArgs) {
            Pair argParen = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)newExp).keywordPairs("(", ")"));
            Procedures.Procedure1 _function_8 = it -> {
                it.setNewLines(0);
                it.noSpace();
            };
            Procedures.Procedure1 _function_9 = it -> it.noSpace();
            document.append(document.prepend((ISemanticRegion)argParen.getKey(), _function_8), _function_9);
            Procedures.Procedure1 _function_10 = it -> it.noSpace();
            document.prepend((ISemanticRegion)argParen.getValue(), _function_10);
            Consumer<Argument> _function_11 = it -> document.format(it);
            newExp.getArguments().forEach(_function_11);
        }
    }

    protected void _format(PostfixExpression postFix, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(0);
            it.noSpace();
        };
        Procedures.Procedure1 _function_1 = it -> {
            it.oneSpace();
            it.lowPriority();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)postFix).feature((EStructuralFeature)N4JSPackage.Literals.POSTFIX_EXPRESSION__OP), _function), _function_1);
        document.format((Object)postFix.getExpression());
    }

    protected void _format(TaggedTemplateString taggedTemplate, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(0);
            it.oneSpace();
        };
        document.append(this.textRegionExtensions.regionFor((EObject)taggedTemplate).feature((EStructuralFeature)N4JSPackage.Literals.EXPRESSION_WITH_TARGET__TARGET), _function);
        document.format((Object)taggedTemplate.getTarget());
        document.format((Object)taggedTemplate.getTemplate());
    }

    protected void _format(UnaryExpression unaryExpr, @Extension IFormattableDocument document) {
        int _ordinal = unaryExpr.getOp().ordinal();
        boolean requireSpace = _ordinal <= 2;
        Procedures.Procedure1 _function = it -> {
            if (requireSpace) {
                it.oneSpace();
            } else {
                it.noSpace();
            }
            it.setNewLines(0);
        };
        document.append(this.textRegionExtensions.regionFor((EObject)unaryExpr).feature((EStructuralFeature)N4JSPackage.Literals.UNARY_EXPRESSION__OP), _function);
        document.format((Object)unaryExpr.getExpression());
    }

    protected void _format(YieldExpression yieldExpr, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> {
            boolean _isMany = yieldExpr.isMany();
            if (_isMany) {
                it.noSpace();
            } else {
                it.oneSpace();
            }
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)yieldExpr).keyword("yield"), _function), _function_1);
        boolean _isMany = yieldExpr.isMany();
        if (_isMany) {
            Procedures.Procedure1 _function_2 = it -> {
                it.noSpace();
                it.setNewLines(0);
            };
            Procedures.Procedure1 _function_3 = it -> it.oneSpace();
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)yieldExpr).keyword("*"), _function_2), _function_3);
        }
        document.format((Object)yieldExpr.getExpression());
    }

    protected void _format(ParenExpression parenE, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.append((ISemanticRegion)IterableExtensions.head((Iterable)this.textRegionExtensions.semanticRegions((EObject)parenE)), _function);
        Procedures.Procedure1 _function_1 = it -> {
            it.noSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.prepend((ISemanticRegion)IterableExtensions.last((Iterable)this.textRegionExtensions.semanticRegions((EObject)parenE)), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.indent();
        this.interiorBUGFIX((EObject)parenE, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2, document);
        document.format((Object)parenE.getExpression());
    }

    protected void _format(ArrowFunction arrowF, @Extension IFormattableDocument document) {
        boolean _isHasBracesAroundBody;
        this.configureCommas((EObject)arrowF, document);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)arrowF).keyword("=>"), _function);
        Pair _head = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)arrowF).keywordPairs("(", ")"));
        if (_head != null) {
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            document.interior(_head, _function_1);
        }
        if (_isHasBracesAroundBody = arrowF.isHasBracesAroundBody()) {
            Pair bracesPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)arrowF).keywordPairs("{", "}"));
            Procedures.Procedure1 _function_2 = it -> it.indent();
            document.interior(bracesPair, _function_2);
            if (((ILineRegion)IterableExtensions.last((Iterable)((ISemanticRegion)bracesPair.getKey()).getLineRegions())).contains((ITextRegion)bracesPair.getValue()) || ((ILineRegion)IterableExtensions.last((Iterable)((ISemanticRegion)bracesPair.getKey()).getLineRegions())).contains((ITextRegion)((ISemanticRegion)bracesPair.getKey()).getNextSemanticRegion())) {
                Block _body = arrowF.getBody();
                EList _statements = null;
                if (_body != null) {
                    _statements = _body.getStatements();
                }
                Procedures.Procedure2 _function_3 = (it, idx) -> {
                    document.format(it);
                    if (idx != 0) {
                        Procedures.Procedure1 _function_4 = it_1 -> {
                            it_1.oneSpace();
                            it_1.autowrap();
                            it_1.setNewLines(0);
                        };
                        document.prepend((EObject)it, _function_4);
                    }
                };
                IterableExtensions.forEach((Iterable)_statements, (Procedures.Procedure2)_function_3);
                Procedures.Procedure1 _function_4 = it -> it.oneSpace();
                document.append((ISemanticRegion)bracesPair.getKey(), _function_4);
                Procedures.Procedure1 _function_5 = it -> it.oneSpace();
                document.prepend((ISemanticRegion)bracesPair.getValue(), _function_5);
            } else if (arrowF.getBody() != null && !arrowF.getBody().getStatements().isEmpty()) {
                Block _body_1 = arrowF.getBody();
                EList _statements_1 = null;
                if (_body_1 != null) {
                    _statements_1 = _body_1.getStatements();
                }
                Procedures.Procedure1 _function_6 = it -> it.setNewLines(1);
                document.prepend((EObject)((Statement)IterableExtensions.head((Iterable)_statements_1)), _function_6);
                Block _body_2 = arrowF.getBody();
                EList _statements_2 = null;
                if (_body_2 != null) {
                    _statements_2 = _body_2.getStatements();
                }
                Consumer<Statement> _function_7 = it -> {
                    document.format(it);
                    Procedures.Procedure1 _function_8 = it_1 -> it_1.setNewLines(1);
                    document.append((EObject)it, _function_8);
                };
                _statements_2.forEach(_function_7);
            } else {
                Procedures.Procedure1 _function_8 = it -> {
                    it.noSpace();
                    it.setNewLines(1);
                };
                document.append((ISemanticRegion)bracesPair.getKey(), _function_8);
                Procedures.Procedure1 _function_9 = it -> {
                    it.noSpace();
                    it.setNewLines(1);
                };
                document.prepend((ISemanticRegion)bracesPair.getValue(), _function_9);
            }
        } else {
            Block _body_3 = arrowF.getBody();
            EList _statements_3 = null;
            if (_body_3 != null) {
                _statements_3 = _body_3.getStatements();
            }
            document.format((Object)((Statement)IterableExtensions.head((Iterable)_statements_3)));
        }
    }

    protected void _format(ArrayLiteral al, @Extension IFormattableDocument document) {
        Pair bracketPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)al).keywordPairs("[", "]"));
        Procedures.Procedure1 _function = it -> it.indent();
        document.interior(bracketPair, _function);
        boolean sameLine = ((ILineRegion)IterableExtensions.head((Iterable)((ISemanticRegion)bracketPair.getKey()).getLineRegions())).contains((ITextRegion)bracketPair.getValue());
        if (!sameLine) {
            boolean _not;
            Procedures.Procedure1 _function_1 = it -> it.autowrap();
            document.append((EObject)((ArrayElement)IterableExtensions.last((Iterable)al.getElements())), _function_1);
            Procedures.Procedure2 _function_2 = (it, num) -> {
                Procedures.Procedure1 _function_3 = it_1 -> {
                    it_1.autowrap();
                    it_1.setNewLines(0, 0, 1);
                    if (num != 0) {
                        it_1.oneSpace();
                    }
                };
                Procedures.Procedure1 _function_4 = it_1 -> it_1.noSpace();
                document.append((EObject)((ArrayElement)document.prepend((EObject)it, _function_3)), _function_4);
            };
            IterableExtensions.forEach((Iterable)al.getElements(), (Procedures.Procedure2)_function_2);
            boolean _contains = ((ILineRegion)IterableExtensions.last((Iterable)((ISemanticRegion)bracketPair.getValue()).getPreviousSemanticRegion().getLineRegions())).contains((ITextRegion)bracketPair.getValue());
            boolean bl = _not = !_contains;
            if (_not) {
                Procedures.Procedure1 _function_3 = it -> it.newLine();
                document.prepend((ISemanticRegion)bracketPair.getValue(), _function_3);
            }
        } else {
            Procedures.Procedure2 _function_4 = (it, num) -> {
                Procedures.Procedure1 _function_5 = it_1 -> {
                    it_1.autowrap();
                    if (num != 0) {
                        it_1.oneSpace();
                    }
                };
                document.prepend((EObject)it, _function_5);
            };
            IterableExtensions.forEach((Iterable)al.getElements(), (Procedures.Procedure2)_function_4);
        }
    }

    protected void _format(ObjectLiteral ol, @Extension IFormattableDocument document) {
        this.configureCommas((EObject)ol, document);
        Pair bracePair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)ol).keywordPairs("{", "}"));
        Procedures.Procedure1 _function = it -> it.indent();
        document.interior(bracePair, _function);
        boolean sameLine = ((ILineRegion)IterableExtensions.head((Iterable)((ISemanticRegion)bracePair.getKey()).getLineRegions())).contains((ITextRegion)IterableExtensions.head((Iterable)((ISemanticRegion)bracePair.getKey()).getNextSemanticRegion().getLineRegions()));
        if (!sameLine) {
            Procedures.Procedure1 _function_1 = it -> it.newLine();
            document.prepend((ISemanticRegion)bracePair.getValue(), _function_1);
            Procedures.Procedure2 _function_2 = (it, num) -> {
                Procedures.Procedure1 _function_3 = it_1 -> it_1.newLine();
                document.prepend((EObject)it, _function_3);
            };
            IterableExtensions.forEach((Iterable)ol.getPropertyAssignments(), (Procedures.Procedure2)_function_2);
            ISemanticRegion _nextSemanticRegion = ((ISemanticRegion)bracePair.getKey()).getNextSemanticRegion();
            ISemanticRegion _value = (ISemanticRegion)bracePair.getValue();
            boolean _equals = Objects.equal((Object)_nextSemanticRegion, (Object)_value);
            if (_equals) {
                Procedures.Procedure1 _function_3 = it -> it.newLine();
                document.append((ISemanticRegion)bracePair.getKey(), _function_3);
            }
        } else {
            Procedures.Procedure1 _function_4 = it -> it.setNewLines(0);
            document.append((ISemanticRegion)bracePair.getKey(), _function_4);
            Procedures.Procedure2 _function_5 = (it, num) -> {
                Procedures.Procedure1 _function_6 = it_1 -> {
                    it_1.setNewLines(0);
                    if (num != 0) {
                        it_1.autowrap();
                        it_1.oneSpace();
                    } else {
                        it_1.noSpace();
                    }
                };
                document.prepend((EObject)it, _function_6);
            };
            IterableExtensions.forEach((Iterable)ol.getPropertyAssignments(), (Procedures.Procedure2)_function_5);
            Procedures.Procedure1 _function_6 = it -> {
                it.setNewLines(0);
                it.noSpace();
                it.lowPriority();
            };
            document.prepend((ISemanticRegion)bracePair.getValue(), _function_6);
        }
        Consumer<EObject> _function_7 = it -> document.format(it);
        ol.eContents().forEach(_function_7);
    }

    protected void _format(ForStatement fst, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.oneSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.append(this.textRegionExtensions.regionFor((EObject)fst).keyword("for"), _function);
        Pair parenPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)fst).keywordPairs("(", ")"));
        Procedures.Procedure1 _function_1 = it -> {
            it.noSpace();
            it.autowrap();
            it.setNewLines(0);
        };
        document.append((ISemanticRegion)parenPair.getKey(), _function_1);
        Procedures.Procedure1 _function_2 = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        Procedures.Procedure1 _function_3 = it -> {
            it.oneSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.append(document.prepend((ISemanticRegion)parenPair.getValue(), _function_2), _function_3);
        Consumer<ISemanticRegion> _function_4 = it -> {
            Procedures.Procedure1 _function_5 = it_1 -> {
                it_1.oneSpace();
                it_1.setNewLines(0);
                it_1.autowrap();
            };
            document.surround(it, _function_5);
        };
        this.textRegionExtensions.regionFor((EObject)fst).keywords(new String[]{"in", "of"}).forEach(_function_4);
        Consumer<ISemanticRegion> _function_5 = it -> {
            Procedures.Procedure1 _function_6 = it_1 -> {
                it_1.noSpace();
                it_1.setNewLines(0);
            };
            Procedures.Procedure1 _function_7 = it_1 -> {
                it_1.oneSpace();
                it_1.setNewLines(0);
                it_1.autowrap();
            };
            document.append(document.prepend(it, _function_6), _function_7);
        };
        this.textRegionExtensions.regionFor((EObject)fst).keywords(new String[]{";"}).forEach(_function_5);
        Consumer<EObject> _function_6 = it -> document.format(it);
        fst.eContents().forEach(_function_6);
    }

    protected void _format(TemplateLiteral tl, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.indent();
        this.interiorBUGFIX((EObject)tl, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function, document);
        Consumer<Expression> _function_1 = it -> {
            boolean _matched = false;
            if (it instanceof TemplateSegment) {
                _matched = true;
                this.noOp();
            }
            if (!_matched) {
                Procedures.Procedure1 _function_2 = it_1 -> {
                    it_1.oneSpace();
                    it_1.autowrap();
                };
                document.surround((EObject)it, _function_2);
            }
            document.format(it);
        };
        tl.getSegments().forEach(_function_1);
    }

    private Object noOp() {
        return null;
    }

    protected void _format(TemplateSegment tl, @Extension IFormattableDocument document) {
    }

    protected void _format(TypeVariable tv, @Extension IFormattableDocument document) {
        TypeRef _declaredUpperBound;
        boolean _tripleNotEquals;
        boolean _isDeclaredContravariant;
        boolean _isDeclaredCovariant = tv.isDeclaredCovariant();
        if (_isDeclaredCovariant) {
            Procedures.Procedure1 _function = it -> it.oneSpace();
            document.append(this.textRegionExtensions.regionFor((EObject)tv).feature((EStructuralFeature)TypesPackage.Literals.TYPE_VARIABLE__DECLARED_COVARIANT), _function);
        }
        if (_isDeclaredContravariant = tv.isDeclaredContravariant()) {
            Procedures.Procedure1 _function_1 = it -> it.oneSpace();
            document.append(this.textRegionExtensions.regionFor((EObject)tv).feature((EStructuralFeature)TypesPackage.Literals.TYPE_VARIABLE__DECLARED_CONTRAVARIANT), _function_1);
        }
        boolean bl = _tripleNotEquals = (_declaredUpperBound = tv.getDeclaredUpperBound()) != null;
        if (_tripleNotEquals) {
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            document.surround(this.textRegionExtensions.regionFor((EObject)tv).keyword("extends"), _function_2);
            TypeRef upperBound = tv.getDeclaredUpperBound();
            Procedures.Procedure1 _function_3 = it -> it.oneSpace();
            document.surround(this.textRegionExtensions.immediatelyFollowing((EObject)upperBound).keyword("&"), _function_3);
            this.format(upperBound, document);
        }
    }

    protected void _format(Expression exp, @Extension IFormattableDocument document) {
        boolean _matched = false;
        if (exp instanceof BooleanLiteral) {
            _matched = true;
        }
        if (!_matched && exp instanceof IdentifierRef) {
            _matched = true;
        }
        if (!_matched && exp instanceof IntLiteral) {
            _matched = true;
        }
        if (!_matched && exp instanceof NullLiteral) {
            _matched = true;
        }
        if (!_matched && exp instanceof NumberLiteral) {
            _matched = true;
        }
        if (!_matched && exp instanceof RegularExpressionLiteral) {
            _matched = true;
        }
        if (!_matched && exp instanceof StringLiteral) {
            _matched = true;
        }
        if (!_matched && exp instanceof ThisLiteral) {
            _matched = true;
        }
        if (!_matched && exp instanceof SuperLiteral) {
            _matched = true;
        }
        if (!_matched && exp instanceof JSXElement) {
            _matched = true;
        }
        if (_matched) {
            return;
        }
        String _simpleName = exp.getClass().getSimpleName();
        String _plus = "expression " + _simpleName;
        String _plus_1 = String.valueOf(_plus) + " not yet implemented.";
        throw new UnsupportedOperationException(_plus_1);
    }

    public void genericFormat(Expression exp, @Extension IFormattableDocument document) {
        Consumer<EObject> _function = it -> document.format(it);
        exp.eContents().forEach(_function);
    }

    protected void _format(AssignmentExpression ass, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.append((EObject)ass.getLhs(), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.prepend((EObject)ass.getRhs(), _function_1);
        document.format((Object)ass.getLhs());
        document.format((Object)ass.getRhs());
    }

    protected void _format(ExpressionStatement eStmt, @Extension IFormattableDocument docuemt) {
        docuemt.format((Object)eStmt.getExpression());
    }

    protected void _format(VariableStatement vStmt, @Extension IFormattableDocument document) {
        if (vStmt instanceof ModifiableElement) {
            this.configureModifiers((EObject)vStmt, document);
        }
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)vStmt).feature((EStructuralFeature)N4JSPackage.Literals.VARIABLE_DECLARATION_CONTAINER__VAR_STMT_KEYWORD), _function);
        this.configureCommas((EObject)vStmt, document);
        Procedures.Procedure1 _function_1 = it -> it.indent();
        this.interiorBUGFIX((EObject)vStmt, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1, document);
        int _size = vStmt.getVarDeclsOrBindings().size();
        int lastIdx = _size - 1;
        Procedures.Procedure2 _function_2 = (e, i) -> {
            document.format(e);
            if (i > 0) {
                if (e instanceof VariableDeclaration) {
                    boolean _tripleNotEquals;
                    Expression _expression = ((VariableDeclaration)e).getExpression();
                    boolean bl = _tripleNotEquals = _expression != null;
                    if (_tripleNotEquals) {
                        Procedures.Procedure1 _function_3 = it -> it.newLine();
                        document.prepend((EObject)((VariableDeclaration)e), _function_3);
                    } else {
                        Procedures.Procedure1 _function_4 = it -> {
                            it.setNewLines(0, 1, 1);
                            it.lowPriority();
                        };
                        document.prepend((EObject)((VariableDeclaration)e), _function_4);
                    }
                } else if (e instanceof VariableBinding) {
                    boolean _tripleNotEquals_1;
                    Expression _expression_1 = ((VariableBinding)e).getExpression();
                    boolean bl = _tripleNotEquals_1 = _expression_1 != null;
                    if (_tripleNotEquals_1) {
                        Procedures.Procedure1 _function_5 = it -> it.newLine();
                        document.prepend((EObject)((VariableBinding)e), _function_5);
                    } else {
                        Procedures.Procedure1 _function_6 = it -> {
                            it.setNewLines(0, 1, 1);
                            it.lowPriority();
                        };
                        document.prepend((EObject)((VariableBinding)e), _function_6);
                    }
                }
            }
            if (i < lastIdx) {
                if (e instanceof VariableDeclaration) {
                    boolean _tripleNotEquals_2;
                    Expression _expression_2 = ((VariableDeclaration)e).getExpression();
                    boolean bl = _tripleNotEquals_2 = _expression_2 != null;
                    if (_tripleNotEquals_2) {
                        Procedures.Procedure1 _function_7 = it -> it.newLine();
                        document.append(this.textRegionExtensions.immediatelyFollowing((EObject)e).keyword(","), _function_7);
                    } else {
                        Procedures.Procedure1 _function_8 = it -> {
                            it.setNewLines(0, 1, 1);
                            it.lowPriority();
                        };
                        document.prepend((EObject)((VariableDeclaration)e), _function_8);
                    }
                } else if (e instanceof VariableBinding) {
                    boolean _tripleNotEquals_3;
                    Expression _expression_3 = ((VariableBinding)e).getExpression();
                    boolean bl = _tripleNotEquals_3 = _expression_3 != null;
                    if (_tripleNotEquals_3) {
                        Procedures.Procedure1 _function_9 = it -> it.newLine();
                        document.append(this.textRegionExtensions.immediatelyFollowing((EObject)e).keyword(","), _function_9);
                    } else {
                        Procedures.Procedure1 _function_10 = it -> {
                            it.setNewLines(0, 1, 1);
                            it.lowPriority();
                        };
                        document.prepend((EObject)((VariableBinding)e), _function_10);
                    }
                }
            }
        };
        IterableExtensions.forEach((Iterable)vStmt.getVarDeclsOrBindings(), (Procedures.Procedure2)_function_2);
    }

    protected void _format(VariableDeclaration vDecl, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.set(this.textRegionExtensions.previousHiddenRegion((EObject)vDecl), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)vDecl).keyword("="), _function_1);
        document.format((Object)vDecl.getExpression());
        document.format((Object)vDecl.getDeclaredTypeRef());
    }

    protected void _format(VariableBinding vBind, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.set(this.textRegionExtensions.previousHiddenRegion((EObject)vBind), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)vBind).keyword("="), _function_1);
        document.format((Object)vBind.getPattern());
        document.format((Object)vBind.getExpression());
        document.format((Object)vBind.getPattern());
    }

    protected void _format(BindingPattern bp, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.append((ISemanticRegion)IterableExtensions.head((Iterable)this.textRegionExtensions.semanticRegions((EObject)bp)), _function);
        Procedures.Procedure1 _function_1 = it -> {
            it.noSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.prepend((ISemanticRegion)IterableExtensions.last((Iterable)this.textRegionExtensions.semanticRegions((EObject)bp)), _function_1);
        this.configureCommas((EObject)bp, document);
        Consumer<EObject> _function_2 = it -> document.format(it);
        bp.eContents().forEach(_function_2);
    }

    protected void _format(ThrowStatement thrStmt, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(0, 0, 0);
            it.oneSpace();
        };
        document.prepend((EObject)thrStmt.getExpression(), _function);
        document.format((Object)thrStmt.getExpression());
    }

    protected void _format(CatchBlock ctch, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(0, 0, 0);
            it.oneSpace();
        };
        document.prepend((EObject)ctch, _function);
        document.format((Object)ctch.getCatchVariable());
        document.format((Object)ctch.getBlock());
    }

    protected void _format(FinallyBlock finlly, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(0);
            it.oneSpace();
        };
        document.set(this.textRegionExtensions.previousHiddenRegion((EObject)finlly), _function);
        document.format((Object)finlly.getBlock());
    }

    private void insertSpaceInFrontOfCurlyBlockOpener(EObject semEObject, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.prepend(this.textRegionExtensions.regionFor(semEObject).keyword("{"), _function);
    }

    private void noSpaceAfterAT(EObject semEObject, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.prepend(document.append(this.textRegionExtensions.regionFor(semEObject).keyword("@"), _function), _function_1);
    }

    private void configureCommas(EObject semEObject, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
            document.prepend(it, _function_1);
            Procedures.Procedure1 _function_2 = it_1 -> {
                it_1.oneSpace();
                it_1.autowrap();
            };
            document.append(it, _function_2);
        };
        this.textRegionExtensions.regionFor(semEObject).keywords(new String[]{","}).forEach(_function);
    }

    public void indentExcludingAnnotations(EObject semObject, @Extension IFormattableDocument document) {
        ISemanticRegion end;
        Functions.Function1 _function = it -> {
            EObject _semanticElement = it.getSemanticElement();
            return !(_semanticElement instanceof Annotation);
        };
        ISemanticRegion begin = (ISemanticRegion)IterableExtensions.findFirst((Iterable)this.textRegionExtensions.semanticRegions(semObject), (Functions.Function1)_function);
        if (begin != (end = (ISemanticRegion)IterableExtensions.last((Iterable)this.textRegionExtensions.semanticRegions(semObject)))) {
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.interior(begin, end, _function_1);
        }
    }

    private void _configureAnnotations(AnnotableN4MemberDeclaration semEObject, @Extension IFormattableDocument document) {
        this.configureAnnotations(semEObject.getAnnotationList(), document);
    }

    private void _configureAnnotations(AnnotablePropertyAssignment semEObject, @Extension IFormattableDocument document) {
        this.configureAnnotations(semEObject.getAnnotationList(), document);
    }

    private void _configureAnnotations(AnnotableScriptElement semEObject, @Extension IFormattableDocument document) {
        this.configureAnnotations(semEObject.getAnnotationList(), document);
    }

    private void _configureAnnotations(AnnotableExpression semEObject, @Extension IFormattableDocument document) {
        this.configureAnnotations(semEObject.getAnnotationList(), document);
    }

    private void _configureAnnotations(AbstractAnnotationList aList, @Extension IFormattableDocument document) {
        if (aList == null || aList.getAnnotations().isEmpty()) {
            return;
        }
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(2, 2, 2);
            it.highPriority();
        };
        document.prepend((EObject)aList, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append((EObject)aList, _function_1);
        Procedures.Procedure2 _function_2 = (it, idx) -> this.configureAnnotation((Annotation)it, document, true, idx == 0);
        IterableExtensions.forEach((Iterable)aList.getAnnotations(), (Procedures.Procedure2)_function_2);
    }

    private ISemanticRegion configureAnnotation(Annotation it, @Extension IFormattableDocument document, boolean withLineWraps, boolean isFirstAnnotation) {
        ISemanticRegion _xblockexpression = null;
        Pair parens = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)it).keywordPairs("(", ")"));
        if (parens != null) {
            Procedures.Procedure1 _function = it_1 -> {
                Procedures.Procedure1 _function_1 = it_2 -> it_2.noSpace();
                Procedures.Procedure1 _function_2 = it_2 -> it_2.noSpace();
                document.append(document.prepend((ISemanticRegion)it_1.getKey(), _function_1), _function_2);
                Procedures.Procedure1 _function_3 = it_2 -> it_2.noSpace();
                Procedures.Procedure1 _function_4 = it_2 -> {
                    if (withLineWraps) {
                        it_2.noSpace();
                        it_2.setNewLines(1);
                    } else {
                        it_2.oneSpace();
                        it_2.setNewLines(0);
                    }
                };
                document.append(document.prepend((ISemanticRegion)it_1.getValue(), _function_3), _function_4);
                Procedures.Procedure1 _function_5 = it_2 -> it_2.indent();
                document.interior(it_1, _function_5);
                if (withLineWraps && !isFirstAnnotation) {
                    Procedures.Procedure1 _function_6 = it_2 -> it_2.setNewLines(1);
                    document.prepend(((ISemanticRegion)it_1.getKey()).getPreviousSemanticRegion().getPreviousSemanticRegion(), _function_6);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)parens, (Procedures.Procedure1)_function);
            this.configureCommas((EObject)it, document);
        }
        ISemanticRegion _head = (ISemanticRegion)IterableExtensions.head((Iterable)this.textRegionExtensions.semanticRegions((EObject)it));
        Procedures.Procedure1 _function_1 = it_1 -> {
            EObject _grammarElement = it_1.getGrammarElement();
            if (_grammarElement instanceof Keyword) {
                Procedures.Procedure1 _function_2 = it_2 -> {
                    it_2.noSpace();
                    it_2.setNewLines(0);
                };
                document.append(it_1, _function_2);
            } else {
                Procedures.Procedure1 _function_3 = it_2 -> {
                    it_2.noSpace();
                    it_2.setNewLines(0);
                };
                document.prepend(it_1, _function_3);
            }
        };
        _xblockexpression = (ISemanticRegion)ObjectExtensions.operator_doubleArrow((Object)_head, (Procedures.Procedure1)_function_1);
        return _xblockexpression;
    }

    private void _configureAnnotations(Object semEObject, @Extension IFormattableDocument document) {
    }

    private void _configureAnnotations(Void x, @Extension IFormattableDocument document) {
    }

    private void configureAnnotationsInLine(FormalParameter fpar, @Extension IFormattableDocument document) {
        boolean _isEmpty = fpar.getAnnotations().isEmpty();
        if (_isEmpty) {
            return;
        }
        Annotation _head = (Annotation)IterableExtensions.head((Iterable)fpar.getAnnotations());
        Procedures.Procedure1 _function = it -> {
            this.configureAnnotation((Annotation)it, document, false, true);
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.noSpace();
                it_1.setNewLines(0);
                it_1.autowrap();
            };
            document.prepend((EObject)it, _function_1);
        };
        ObjectExtensions.operator_doubleArrow((Object)_head, (Procedures.Procedure1)_function);
        Consumer<Annotation> _function_1 = it -> {
            this.configureAnnotation((Annotation)it, document, false, false);
            Procedures.Procedure1 _function_2 = it_1 -> {
                it_1.oneSpace();
                it_1.setNewLines(0);
                it_1.autowrap();
            };
            document.prepend((EObject)it, _function_2);
        };
        IterableExtensions.tail((Iterable)fpar.getAnnotations()).forEach(_function_1);
        Procedures.Procedure1 _function_2 = it -> {
            it.oneSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.append((EObject)((Annotation)IterableExtensions.last((Iterable)fpar.getAnnotations())), _function_2);
    }

    private void formatScriptAnnotations(Script script, @Extension IFormattableDocument document) {
        boolean _isEmpty = script.getAnnotations().isEmpty();
        if (_isEmpty) {
            return;
        }
        boolean _containsComment = this.textRegionExtensions.previousHiddenRegion((EObject)IterableExtensions.head((Iterable)script.getAnnotations())).containsComment();
        if (_containsComment) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            document.prepend((EObject)((Annotation)IterableExtensions.head((Iterable)script.getAnnotations())), _function);
        } else {
            Procedures.Procedure1 _function_1 = it -> {
                it.noSpace();
                it.setNewLines(0);
            };
            document.prepend((EObject)((Annotation)IterableExtensions.head((Iterable)script.getAnnotations())), _function_1);
        }
        Procedures.Procedure1 _function_2 = it -> it.setNewLines(2, 2, 2);
        document.append((EObject)((Annotation)IterableExtensions.last((Iterable)script.getAnnotations())), _function_2);
        Procedures.Procedure2 _function_3 = (it, idx) -> {
            if (idx != 0) {
                Procedures.Procedure1 _function_4 = it_1 -> {
                    it_1.setNewLines(1);
                    it_1.noSpace();
                };
                document.prepend((EObject)it, _function_4);
            }
            ISemanticRegion _head = (ISemanticRegion)IterableExtensions.head((Iterable)this.textRegionExtensions.semanticRegions((EObject)it));
            Procedures.Procedure1 _function_5 = it_1 -> {
                Procedures.Procedure1 _function_6 = it_2 -> {
                    it_2.noSpace();
                    it_2.setNewLines(0);
                };
                document.append(it_1, _function_6);
            };
            ObjectExtensions.operator_doubleArrow((Object)_head, (Procedures.Procedure1)_function_5);
        };
        IterableExtensions.forEach((Iterable)script.getAnnotations(), (Procedures.Procedure2)_function_3);
    }

    public ITextReplacer createCommentReplacer(IComment comment) {
        ITextReplacer _xblockexpression = null;
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule) {
            String ruleName = ((AbstractRule)grammarElement).getName();
            boolean _startsWith = ruleName.startsWith("ML");
            if (_startsWith) {
                String cText = comment.getText();
                if (cText.startsWith("/**") && !cText.startsWith("/***")) {
                    return new N4MultilineCommentReplacer(comment, '*');
                }
                boolean _startsWith_1 = cText.startsWith("/*-");
                if (_startsWith_1) {
                    boolean _isNotFirstInLine = N4JSFormatter.isNotFirstInLine(comment);
                    boolean _not = !_isNotFirstInLine;
                    return new OffMultilineCommentReplacer(comment, _not);
                }
                return new FixedMultilineCommentReplacer(comment);
            }
            boolean _startsWith_2 = ruleName.startsWith("SL");
            if (_startsWith_2) {
                boolean _isNotFirstInLine_1 = N4JSFormatter.isNotFirstInLine(comment);
                if (_isNotFirstInLine_1) {
                    return new SinglelineDocCommentReplacer(comment, "//");
                }
                return new SinglelineCodeCommentReplacer(comment, "//");
            }
        }
        _xblockexpression = super.createCommentReplacer(comment);
        return _xblockexpression;
    }

    private static boolean isNotFirstInLine(IComment comment) {
        ILineRegion lineRegion = (ILineRegion)comment.getLineRegions().get(0);
        boolean _contains = comment.contains(lineRegion.getOffset());
        return !_contains;
    }

    public IMerger<ITextReplacer> createTextReplacerMerger() {
        return new IndentHandlingTextReplaceMerger((AbstractFormatter2)this);
    }

    private static String containmentStructure(EObject eo) {
        boolean _tripleNotEquals;
        String name = eo.getClass().getSimpleName();
        EObject _eContainer = eo.eContainer();
        boolean bl = _tripleNotEquals = _eContainer != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            String _containmentStructure = N4JSFormatter.containmentStructure(eo.eContainer());
            _builder.append(_containmentStructure);
            _builder.append(".");
            String _name = eo.eContainingFeature().getName();
            _builder.append(_name);
            _builder.append("-> ");
            _builder.append(name);
            return _builder.toString();
        }
        return name;
    }

    public int suppressUnusedWarnings(Object ... e) {
        return -7;
    }

    protected void _format(UnionTypeExpression ute, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.oneSpace();
                it_1.setNewLines(0);
            };
            Procedures.Procedure1 _function_2 = it_1 -> {
                it_1.autowrap();
                it_1.highPriority();
            };
            document.prepend(document.surround(it, _function_1), _function_2);
        };
        this.textRegionExtensions.regionFor((EObject)ute).keywords(new String[]{"|"}).forEach(_function);
        Consumer<TypeRef> _function_1 = it -> document.format(it);
        ute.getTypeRefs().forEach(_function_1);
        ISemanticRegion kwUnion = this.textRegionExtensions.regionFor((EObject)ute).keyword("union");
        if (kwUnion != null) {
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            Procedures.Procedure1 _function_3 = it -> {
                it.oneSpace();
                it.setNewLines(0);
            };
            Procedures.Procedure1 _function_4 = it -> {
                it.oneSpace();
                it.setNewLines(0);
            };
            document.append(document.append(document.prepend(kwUnion, _function_2), _function_3).getNextSemanticRegion(), _function_4);
            Procedures.Procedure1 _function_5 = it -> {
                it.oneSpace();
                it.setNewLines(0);
            };
            document.prepend((ISemanticRegion)IterableExtensions.last((Iterable)this.textRegionExtensions.semanticRegions((EObject)ute)), _function_5);
        }
    }

    protected void _format(IntersectionTypeExpression ite, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.oneSpace();
                it_1.setNewLines(0);
            };
            Procedures.Procedure1 _function_2 = it_1 -> {
                it_1.autowrap();
                it_1.highPriority();
            };
            document.prepend(document.surround(it, _function_1), _function_2);
        };
        this.textRegionExtensions.regionFor((EObject)ite).keywords(new String[]{"&"}).forEach(_function);
        Consumer<TypeRef> _function_1 = it -> document.format(it);
        ite.getTypeRefs().forEach(_function_1);
        ISemanticRegion kwInersection = this.textRegionExtensions.regionFor((EObject)ite).keyword("intersection");
        if (kwInersection != null) {
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            Procedures.Procedure1 _function_3 = it -> {
                it.oneSpace();
                it.setNewLines(0);
            };
            Procedures.Procedure1 _function_4 = it -> {
                it.oneSpace();
                it.setNewLines(0);
            };
            document.append(document.append(document.prepend(kwInersection, _function_2), _function_3).getNextSemanticRegion(), _function_4);
            Procedures.Procedure1 _function_5 = it -> {
                it.oneSpace();
                it.setNewLines(0);
            };
            document.prepend((ISemanticRegion)IterableExtensions.last((Iterable)this.textRegionExtensions.semanticRegions((EObject)ite)), _function_5);
        }
    }

    protected void _format(TStructMember tsm, @Extension IFormattableDocument document) {
        if (tsm instanceof TField) {
            this.configureOptionality((TField)tsm, document);
        } else if (tsm instanceof FieldAccessor) {
            this.configureGetSetKeyword((FieldAccessor)tsm, document);
            this.configureOptionality((FieldAccessor)tsm, document);
            Pair parenPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)tsm).keywordPairs("(", ")"));
            Procedures.Procedure1 _function = it -> {
                it.noSpace();
                it.setNewLines(0);
            };
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            document.append(document.prepend((ISemanticRegion)parenPair.getKey(), _function), _function_1);
        }
        Consumer<EObject> _function_2 = it -> document.format(it);
        tsm.eContents().forEach(_function_2);
    }

    private void configureUndefModifier(StaticBaseTypeRef sbtr, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        document.prepend(this.textRegionExtensions.regionFor((EObject)sbtr).feature((EStructuralFeature)TypeRefsPackage.Literals.TYPE_REF__FOLLOWED_BY_QUESTION_MARK), _function);
    }

    protected void _format(ThisTypeRef ttr, @Extension IFormattableDocument document) {
        this.configureUndefModifier((StaticBaseTypeRef)ttr, document);
        if (ttr instanceof ThisTypeRefStructural) {
            Procedures.Procedure1 _function = it -> it.indent();
            this.interiorBUGFIX((EObject)ttr, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function, document);
            this.configureStructuralAdditions((TypeRef)ttr, document);
            Consumer<EObject> _function_1 = it -> document.format(it);
            ((ThisTypeRefStructural)ttr).eContents().forEach(_function_1);
        }
    }

    protected void _format(ParameterizedTypeRef ptr, @Extension IFormattableDocument document) {
        boolean _isIterableTypeExpression;
        Procedures.Procedure1 _function = it -> it.indent();
        this.interiorBUGFIX((EObject)ptr, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function, document);
        this.configureUndefModifier((StaticBaseTypeRef)ptr, document);
        Consumer<ISemanticRegion> _function_1 = it -> {
            Procedures.Procedure1 _function_2 = it_1 -> {
                it_1.oneSpace();
                it_1.setNewLines(0);
            };
            Procedures.Procedure1 _function_3 = it_1 -> {
                it_1.autowrap();
                it_1.highPriority();
            };
            document.append(document.surround(it, _function_2), _function_3);
        };
        this.textRegionExtensions.regionFor((EObject)ptr).keywords(new String[]{"&", "|"}).forEach(_function_1);
        boolean _isArrayTypeExpression = ptr.isArrayTypeExpression();
        if (_isArrayTypeExpression) {
            Procedures.Procedure1 _function_2 = it -> it.noSpace();
            document.append(this.textRegionExtensions.regionFor((EObject)ptr).keyword("["), _function_2);
            Procedures.Procedure1 _function_3 = it -> it.noSpace();
            document.append(this.textRegionExtensions.regionFor((EObject)ptr).keyword("]"), _function_3);
        }
        if (_isIterableTypeExpression = ptr.isIterableTypeExpression()) {
            Procedures.Procedure1 _function_4 = it -> it.noSpace();
            document.append(this.textRegionExtensions.regionFor((EObject)ptr).keyword("["), _function_4);
            Procedures.Procedure1 _function_5 = it -> it.noSpace();
            document.append(this.textRegionExtensions.regionFor((EObject)ptr).keyword("]"), _function_5);
        }
        this.formatTypeArguments(ptr, document);
        this.configureStructuralAdditions((TypeRef)ptr, document);
        Consumer<EObject> _function_6 = it -> document.format(it);
        ptr.eContents().forEach(_function_6);
    }

    public void configureStructuralAdditions(TypeRef ptr, @Extension IFormattableDocument document) {
        ISemanticRegion semRegTypingStrategy = this.textRegionExtensions.regionFor((EObject)ptr).ruleCallTo((AbstractRule)this._n4JSGrammarAccess.getTypingStrategyUseSiteOperatorRule());
        if (semRegTypingStrategy != null) {
            Procedures.Procedure1 _function = it -> it.oneSpace();
            Procedures.Procedure1 _function_1 = it -> {
                it.noSpace();
                it.setNewLines(0);
            };
            document.append(document.prepend(semRegTypingStrategy, _function), _function_1);
            Procedures.Procedure1 _function_2 = it -> {};
            document.append(semRegTypingStrategy.getNextSemanticRegion(), _function_2);
            ISemanticRegion kwWith = this.textRegionExtensions.regionFor((EObject)ptr).keyword("with");
            if (kwWith != null) {
                Procedures.Procedure1 _function_3 = it -> {
                    it.oneSpace();
                    it.setNewLines(0);
                    it.autowrap();
                };
                document.surround(kwWith, _function_3);
                Pair bracesPair = (Pair)IterableExtensions.head((Iterable)this.textRegionExtensions.regionFor((EObject)ptr).keywordPairs("{", "}"));
                Procedures.Procedure1 _function_4 = it -> {
                    it.noSpace();
                    it.setNewLines(0);
                    it.autowrap();
                };
                document.append((ISemanticRegion)bracesPair.getKey(), _function_4);
                Procedures.Procedure1 _function_5 = it -> {
                    it.noSpace();
                    it.setNewLines(0);
                    it.autowrap();
                };
                document.prepend((ISemanticRegion)bracesPair.getValue(), _function_5);
                Consumer<ISemanticRegion> _function_6 = it -> {
                    Procedures.Procedure1 _function_7 = it_1 -> {
                        it_1.noSpace();
                        it_1.setNewLines(0);
                    };
                    Procedures.Procedure1 _function_8 = it_1 -> {
                        it_1.oneSpace();
                        it_1.setNewLines(0);
                        it_1.autowrap();
                        it_1.lowPriority();
                    };
                    document.append(document.prepend(it, _function_7), _function_8);
                };
                this.textRegionExtensions.regionFor((EObject)ptr).keywords(new String[]{";"}).forEach(_function_6);
                Consumer<TStructMember> _function_7 = it -> {
                    Procedures.Procedure1 _function_8 = it_1 -> {
                        it_1.oneSpace();
                        it_1.setNewLines(0);
                        it_1.autowrap();
                    };
                    document.set(this.textRegionExtensions.regionForEObject((EObject)it).getPreviousHiddenRegion(), _function_8);
                };
                IterableExtensions.tail((Iterable)((StructuralTypeRef)ptr).getAstStructuralMembers()).forEach(_function_7);
            }
        }
    }

    public void formatTypeArguments(ParameterizedTypeRef semObject, @Extension IFormattableDocument document) {
        boolean _isEmpty = semObject.getTypeArgs().isEmpty();
        if (_isEmpty) {
            return;
        }
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> {
            it.noSpace();
            it.setNewLines(0);
            it.lowPriority();
        };
        document.prepend(document.append(this.textRegionExtensions.regionFor((EObject)semObject).keyword("<"), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        Procedures.Procedure1 _function_3 = it -> {
            it.noSpace();
            it.setNewLines(0);
            it.lowPriority();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)semObject).keyword(">"), _function_2), _function_3);
        EList _typeArgs = semObject.getTypeArgs();
        for (TypeArgument typeArg : _typeArgs) {
            Procedures.Procedure1 _function_4 = it -> it.noSpace();
            Procedures.Procedure1 _function_5 = it -> it.oneSpace();
            document.append(this.textRegionExtensions.immediatelyFollowing(document.append((EObject)typeArg, _function_4)).keyword(","), _function_5);
            this.format(typeArg, document);
        }
    }

    private void configureGetSetKeyword(org.eclipse.n4js.n4JS.FieldAccessor fieldAccessor, @Extension IFormattableDocument document) {
        String _xifexpression = null;
        _xifexpression = fieldAccessor instanceof GetterDeclaration ? "get" : "set";
        String kw = _xifexpression;
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> {
            it.oneSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)fieldAccessor).keyword(kw), _function), _function_1);
    }

    private void configureGetSetKeyword(FieldAccessor tFieldAccessor, @Extension IFormattableDocument document) {
        String _xifexpression = null;
        _xifexpression = tFieldAccessor instanceof TGetter ? "get" : "set";
        String kw = _xifexpression;
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> {
            it.oneSpace();
            it.setNewLines(0);
            it.autowrap();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)tFieldAccessor).keyword(kw), _function), _function_1);
    }

    private void configureOptionality(N4FieldDeclaration fieldDecl, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        document.prepend(this.textRegionExtensions.regionFor((EObject)fieldDecl).feature((EStructuralFeature)N4JSPackage.Literals.N4_FIELD_DECLARATION__DECLARED_OPTIONAL), _function);
    }

    private void configureOptionality(org.eclipse.n4js.n4JS.FieldAccessor fieldAccessor, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        document.prepend(this.textRegionExtensions.regionFor((EObject)fieldAccessor).feature((EStructuralFeature)N4JSPackage.Literals.FIELD_ACCESSOR__DECLARED_OPTIONAL), _function);
    }

    private void configureOptionality(TField tField, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        document.prepend(this.textRegionExtensions.regionFor((EObject)tField).feature((EStructuralFeature)TypesPackage.Literals.TFIELD__OPTIONAL), _function);
    }

    private void configureOptionality(FieldAccessor tFieldAccessor, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> {
            it.noSpace();
            it.setNewLines(0);
        };
        document.prepend(this.textRegionExtensions.regionFor((EObject)tFieldAccessor).feature((EStructuralFeature)TypesPackage.Literals.FIELD_ACCESSOR__OPTIONAL), _function);
    }

    public void interiorBUGFIX(EObject object, Procedures.Procedure1<? super IHiddenRegionFormatter> init, IFormattableDocument document) {
        IEObjectRegion objRegion = this.getTextRegionAccess().regionForEObject(object);
        if (objRegion != null) {
            IHiddenRegion previous = objRegion.getPreviousHiddenRegion();
            IHiddenRegion next = objRegion.getNextHiddenRegion();
            if (previous != null && next != null && !Objects.equal((Object)previous, (Object)next)) {
                ISemanticRegion psr;
                boolean _notEquals;
                ISemanticRegion nsr = previous.getNextSemanticRegion();
                boolean bl = _notEquals = !Objects.equal((Object)nsr, (Object)(psr = next.getPreviousSemanticRegion()));
                if (_notEquals) {
                    document.interior(nsr, psr, init);
                }
            }
        }
    }

    public Procedures.Procedure1<? super IFormattableDocument> interior(EObject eo, Procedures.Procedure1<? super IHiddenRegionFormatter> init) {
        throw new IllegalStateException("Method should not be called.");
    }

    public void format(Object clazz, IFormattableDocument document) {
        if (clazz instanceof N4ClassDeclaration) {
            this._format((N4ClassDeclaration)clazz, document);
            return;
        }
        if (clazz instanceof N4InterfaceDeclaration) {
            this._format((N4InterfaceDeclaration)clazz, document);
            return;
        }
        if (clazz instanceof ArrowFunction) {
            this._format((ArrowFunction)clazz, document);
            return;
        }
        if (clazz instanceof N4EnumDeclaration) {
            this._format((N4EnumDeclaration)clazz, document);
            return;
        }
        if (clazz instanceof TemplateSegment) {
            this._format((TemplateSegment)clazz, document);
            return;
        }
        if (clazz instanceof IntersectionTypeExpression) {
            this._format((IntersectionTypeExpression)clazz, document);
            return;
        }
        if (clazz instanceof ParameterizedTypeRef) {
            this._format((ParameterizedTypeRef)clazz, document);
            return;
        }
        if (clazz instanceof ThisTypeRef) {
            this._format((ThisTypeRef)clazz, document);
            return;
        }
        if (clazz instanceof UnionTypeExpression) {
            this._format((UnionTypeExpression)clazz, document);
            return;
        }
        if (clazz instanceof TypeVariable) {
            this._format((TypeVariable)clazz, document);
            return;
        }
        if (clazz instanceof ArrayLiteral) {
            this._format((ArrayLiteral)clazz, document);
            return;
        }
        if (clazz instanceof ForStatement) {
            this._format((ForStatement)clazz, document);
            return;
        }
        if (clazz instanceof FunctionExpression) {
            this._format((FunctionExpression)clazz, document);
            return;
        }
        if (clazz instanceof IndexedAccessExpression) {
            this._format((IndexedAccessExpression)clazz, document);
            return;
        }
        if (clazz instanceof N4FieldDeclaration) {
            this._format((N4FieldDeclaration)clazz, document);
            return;
        }
        if (clazz instanceof ObjectLiteral) {
            this._format((ObjectLiteral)clazz, document);
            return;
        }
        if (clazz instanceof ParameterizedCallExpression) {
            this._format((ParameterizedCallExpression)clazz, document);
            return;
        }
        if (clazz instanceof ParameterizedPropertyAccessExpression) {
            this._format((ParameterizedPropertyAccessExpression)clazz, document);
            return;
        }
        if (clazz instanceof ParenExpression) {
            this._format((ParenExpression)clazz, document);
            return;
        }
        if (clazz instanceof TaggedTemplateString) {
            this._format((TaggedTemplateString)clazz, document);
            return;
        }
        if (clazz instanceof TemplateLiteral) {
            this._format((TemplateLiteral)clazz, document);
            return;
        }
        if (clazz instanceof VariableDeclaration) {
            this._format((VariableDeclaration)clazz, document);
            return;
        }
        if (clazz instanceof TStructMember) {
            this._format((TStructMember)clazz, document);
            return;
        }
        if (clazz instanceof AdditiveExpression) {
            this._format((AdditiveExpression)clazz, document);
            return;
        }
        if (clazz instanceof AssignmentExpression) {
            this._format((AssignmentExpression)clazz, document);
            return;
        }
        if (clazz instanceof AwaitExpression) {
            this._format((AwaitExpression)clazz, document);
            return;
        }
        if (clazz instanceof BinaryBitwiseExpression) {
            this._format((BinaryBitwiseExpression)clazz, document);
            return;
        }
        if (clazz instanceof BinaryLogicalExpression) {
            this._format((BinaryLogicalExpression)clazz, document);
            return;
        }
        if (clazz instanceof Block) {
            this._format((Block)clazz, document);
            return;
        }
        if (clazz instanceof CastExpression) {
            this._format((CastExpression)clazz, document);
            return;
        }
        if (clazz instanceof CommaExpression) {
            this._format((CommaExpression)clazz, document);
            return;
        }
        if (clazz instanceof ConditionalExpression) {
            this._format((ConditionalExpression)clazz, document);
            return;
        }
        if (clazz instanceof EqualityExpression) {
            this._format((EqualityExpression)clazz, document);
            return;
        }
        if (clazz instanceof ExportDeclaration) {
            this._format((ExportDeclaration)clazz, document);
            return;
        }
        if (clazz instanceof ExpressionStatement) {
            this._format((ExpressionStatement)clazz, document);
            return;
        }
        if (clazz instanceof IfStatement) {
            this._format((IfStatement)clazz, document);
            return;
        }
        if (clazz instanceof ImportDeclaration) {
            this._format((ImportDeclaration)clazz, document);
            return;
        }
        if (clazz instanceof MultiplicativeExpression) {
            this._format((MultiplicativeExpression)clazz, document);
            return;
        }
        if (clazz instanceof NamespaceImportSpecifier) {
            this._format((NamespaceImportSpecifier)clazz, document);
            return;
        }
        if (clazz instanceof NewExpression) {
            this._format((NewExpression)clazz, document);
            return;
        }
        if (clazz instanceof PostfixExpression) {
            this._format((PostfixExpression)clazz, document);
            return;
        }
        if (clazz instanceof PromisifyExpression) {
            this._format((PromisifyExpression)clazz, document);
            return;
        }
        if (clazz instanceof RelationalExpression) {
            this._format((RelationalExpression)clazz, document);
            return;
        }
        if (clazz instanceof ReturnStatement) {
            this._format((ReturnStatement)clazz, document);
            return;
        }
        if (clazz instanceof ShiftExpression) {
            this._format((ShiftExpression)clazz, document);
            return;
        }
        if (clazz instanceof SwitchStatement) {
            this._format((SwitchStatement)clazz, document);
            return;
        }
        if (clazz instanceof ThrowStatement) {
            this._format((ThrowStatement)clazz, document);
            return;
        }
        if (clazz instanceof UnaryExpression) {
            this._format((UnaryExpression)clazz, document);
            return;
        }
        if (clazz instanceof VariableBinding) {
            this._format((VariableBinding)clazz, document);
            return;
        }
        if (clazz instanceof VariableStatement) {
            this._format((VariableStatement)clazz, document);
            return;
        }
        if (clazz instanceof YieldExpression) {
            this._format((YieldExpression)clazz, document);
            return;
        }
        if (clazz instanceof XtextResource) {
            this._format((XtextResource)clazz, document);
            return;
        }
        if (clazz instanceof AbstractCaseClause) {
            this._format((AbstractCaseClause)clazz, document);
            return;
        }
        if (clazz instanceof BindingPattern) {
            this._format((BindingPattern)clazz, document);
            return;
        }
        if (clazz instanceof CatchBlock) {
            this._format((CatchBlock)clazz, document);
            return;
        }
        if (clazz instanceof Expression) {
            this._format((Expression)clazz, document);
            return;
        }
        if (clazz instanceof FinallyBlock) {
            this._format((FinallyBlock)clazz, document);
            return;
        }
        if (clazz instanceof FunctionOrFieldAccessor) {
            this._format((FunctionOrFieldAccessor)clazz, document);
            return;
        }
        if (clazz instanceof NamedImportSpecifier) {
            this._format((NamedImportSpecifier)clazz, document);
            return;
        }
        if (clazz instanceof Script) {
            this._format((Script)clazz, document);
            return;
        }
        if (clazz instanceof EObject) {
            this._format((EObject)clazz, document);
            return;
        }
        if (clazz == null) {
            this._format(null, document);
            return;
        }
        if (clazz != null) {
            this._format(clazz, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(clazz, document).toString());
    }

    private void configureAnnotations(Object semEObject, IFormattableDocument document) {
        if (semEObject instanceof AnnotablePropertyAssignment) {
            this._configureAnnotations((AnnotablePropertyAssignment)semEObject, document);
            return;
        }
        if (semEObject instanceof AnnotableExpression) {
            this._configureAnnotations((AnnotableExpression)semEObject, document);
            return;
        }
        if (semEObject instanceof AnnotableN4MemberDeclaration) {
            this._configureAnnotations((AnnotableN4MemberDeclaration)semEObject, document);
            return;
        }
        if (semEObject instanceof AnnotableScriptElement) {
            this._configureAnnotations((AnnotableScriptElement)semEObject, document);
            return;
        }
        if (semEObject instanceof AbstractAnnotationList) {
            this._configureAnnotations((AbstractAnnotationList)semEObject, document);
            return;
        }
        if (semEObject == null) {
            this._configureAnnotations((Void)null, document);
            return;
        }
        if (semEObject != null) {
            this._configureAnnotations(semEObject, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(semEObject, document).toString());
    }

    private static final class StateTrack {
        private boolean done = false;

        private StateTrack() {
        }

        public boolean shouldDoThenDone() {
            boolean ret = !this.done;
            this.done = true;
            return ret;
        }
    }
}

