/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.n4idl.assistants;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.n4idl.migrations.MigrationSwitchComputer;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.n4js.n4idl.migrations.TypeSwitchCondition;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.es.n4idl.assistants.TypeSwitchTranspiler;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TMigratable;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MigrationTransformationAssistant
extends TransformationAssistant {
    @Inject
    private TypeSwitchTranspiler typeSwitchTranspiler;
    @Inject
    private MigrationSwitchComputer migrationSwitchComputer;
    private static final String SWITCH_ARGUMENT = "migrationArguments";
    private static final String MIGRATION_CANDIDATE_LIST = "migrationCandidates";

    public Statement createMigrationSupportInitializer(SymbolTableEntry steClass, N4TypeDeclaration typeDecl) {
        IdentifiableElement typeModelElement;
        SymbolTableEntryOriginal _xifexpression = null;
        _xifexpression = steClass instanceof SymbolTableEntryOriginal ? (SymbolTableEntryOriginal)steClass : (SymbolTableEntryOriginal)this.getState().steCache.mapOriginal.get(typeDecl);
        SymbolTableEntryOriginal originalSTE = _xifexpression;
        IdentifiableElement _originalTarget = null;
        if (originalSTE != null) {
            _originalTarget = originalSTE.getOriginalTarget();
        }
        if ((typeModelElement = _originalTarget) == null) {
            String _name = typeDecl.getName();
            String _plus = "Failed to generate migration meta-information for type " + _name;
            String _plus_1 = String.valueOf(_plus) + ".";
            throw new IllegalStateException(_plus_1);
        }
        if (!(typeModelElement instanceof TMigratable)) {
            String _name_1 = typeDecl.getName();
            String _plus_2 = "Failed to generate migration meta-information for non-migratable type " + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + ".";
            throw new IllegalStateException(_plus_3);
        }
        Expression migrationsFieldValue = this.makeMigrationSwitch((TMigratable)typeModelElement);
        ParameterizedPropertyAccessExpression_IM staticFieldAccess = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)steClass), (SymbolTableEntry[])new SymbolTableEntry[]{this.getSymbolTableEntryInternal("$migrations__n4", true)});
        return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)staticFieldAccess, (Expression)migrationsFieldValue));
    }

    private Expression makeMigrationSwitch(TMigratable migratable) {
        Functions.Function1 _function = it -> it.getTargetVersion();
        Map migrationsByTargetVersion = IterableExtensions.groupBy((Iterable)migratable.getMigrations(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = entry -> {
            FunctionExpression _makeMigrationSwitchFunction = this.makeMigrationSwitchFunction((List)entry.getValue());
            return Pair.of((Object)Integer.toString((Integer)entry.getKey()), (Object)_makeMigrationSwitchFunction);
        };
        return TranspilerBuilderBlocks._ObjLit((Pair[])((Pair[])Conversions.unwrapArray((Object)IterableExtensions.toList((Iterable)IterableExtensions.map(migrationsByTargetVersion.entrySet(), (Functions.Function1)_function_1)), Pair.class)));
    }

    private FunctionExpression makeMigrationSwitchFunction(List<TMigration> migrations) {
        ArrayList bodyStatements = CollectionLiterals.newArrayList();
        SymbolTableEntryInternal switchParameter = this.getSymbolTableEntryInternal(SWITCH_ARGUMENT, true);
        SymbolTableEntryInternal migrationCandidatesSTE = this.getSymbolTableEntryInternal(MIGRATION_CANDIDATE_LIST, true);
        VariableStatement __VariableStatement = TranspilerBuilderBlocks._VariableStatement((VariableStatementKeyword)VariableStatementKeyword.LET, (VariableDeclaration[])new VariableDeclaration[]{TranspilerBuilderBlocks._VariableDeclaration((String)MIGRATION_CANDIDATE_LIST, (Expression)TranspilerBuilderBlocks._ArrLit())});
        bodyStatements.add(__VariableStatement);
        Functions.Function1 _function = it -> this.makeIfStatement((TMigration)it, switchParameter, migrationCandidatesSTE);
        Iterables.addAll((Collection)bodyStatements, (Iterable)Iterables.concat((Iterable)ListExtensions.map(migrations, (Functions.Function1)_function)));
        ReturnStatement __ReturnStmnt = TranspilerBuilderBlocks._ReturnStmnt((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)migrationCandidatesSTE));
        bodyStatements.add(__ReturnStmnt);
        FormalParameter __FormalParameter = TranspilerBuilderBlocks._FormalParameter((String)SWITCH_ARGUMENT);
        return TranspilerBuilderBlocks._FunExpr((boolean)false, null, (FormalParameter[])new FormalParameter[]{__FormalParameter}, (Block)TranspilerBuilderBlocks._Block((Statement[])((Statement[])Conversions.unwrapArray((Object)bodyStatements, Statement.class))));
    }

    private List<Statement> makeIfStatement(TMigration migration, SymbolTableEntryInternal migrationParameters, SymbolTableEntryInternal migrationCandidatesSTE) {
        ArrayList conditions = CollectionLiterals.newArrayList();
        EqualityExpression parameterCountCondition = TranspilerBuilderBlocks._EqualityExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)migrationParameters), (SymbolTableEntry[])new SymbolTableEntry[]{this.getSymbolTableEntryInternal("length", true)}), (EqualityOperator)EqualityOperator.EQ, (Expression)TranspilerBuilderBlocks._NumericLiteral((int)migration.getSourceTypeRefs().size()));
        conditions.add(parameterCountCondition);
        Functions.Function1 _function = it -> {
            SwitchCondition _xtrycatchfinallyexpression = null;
            try {
                _xtrycatchfinallyexpression = this.migrationSwitchComputer.compute(it);
            }
            catch (Throwable _t) {
                if (_t instanceof MigrationSwitchComputer.UnhandledTypeRefException) {
                    MigrationSwitchComputer.UnhandledTypeRefException e = (MigrationSwitchComputer.UnhandledTypeRefException)_t;
                    String _name = migration.getName();
                    String _plus = "Failed to compute migration source type switch for migration " + _name;
                    throw new IllegalStateException(_plus, (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return _xtrycatchfinallyexpression;
        };
        List parameterTypeConditions = ListExtensions.map((List)migration.getSourceTypeRefs(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = c -> Iterables.filter((Iterable)c.subConditions(), TypeSwitchCondition.class);
        Functions.Function1 _function_2 = typeConditions -> typeConditions.type;
        Iterable typeConditionTypes = IterableExtensions.map((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)parameterTypeConditions, (Functions.Function1)_function_1)), (Functions.Function1)_function_2);
        Consumer<Type> _function_3 = i -> this.addNamedImport((IdentifiableElement)i, null);
        typeConditionTypes.forEach(_function_3);
        Procedures.Procedure2 _function_4 = (condition, index) -> {
            IndexedAccessExpression lhs = TranspilerBuilderBlocks._IndexAccessExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)migrationParameters), (Expression)TranspilerBuilderBlocks._NumericLiteral((int)index));
            List<Expression> _transform = this.typeSwitchTranspiler.transform((SwitchCondition)condition, (Expression)lhs);
            Iterables.addAll((Collection)conditions, _transform);
        };
        IterableExtensions.forEach((Iterable)parameterTypeConditions, (Procedures.Procedure2)_function_4);
        Functions.Function1 _function_5 = it -> it.getTypeRefAsString();
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)migration.getSourceTypeRefs(), (Functions.Function1)_function_5), (CharSequence)", ");
        String _plus = "// (" + _join;
        String _plus_1 = String.valueOf(_plus) + ")";
        ExpressionStatement __SnippetAsStmnt = TranspilerBuilderBlocks._SnippetAsStmnt((String)_plus_1);
        IfStatement __IfStmnt = TranspilerBuilderBlocks._IfStmnt((Expression)TranspilerBuilderBlocks._AND((Expression[])((Expression[])Conversions.unwrapArray((Object)conditions, Expression.class))), (Statement)this._PushArrayElement((SymbolTableEntry)migrationCandidatesSTE, this._MigrationCandidateElement(migration)));
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Statement[]{__SnippetAsStmnt, __IfStmnt}));
    }

    private Expression _MigrationCandidateElement(TMigration migration) {
        SymbolTableEntryOriginal migrationSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)migration, true);
        Functions.Function1 _function = typeRef -> this._ParameterTypeArrayElement((TypeRef)typeRef);
        List sourceTypeArrayElements = ListExtensions.map((List)migration.getSourceTypeRefs(), (Functions.Function1)_function);
        IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)migrationSTE);
        Pair _mappedTo = Pair.of((Object)"migration", (Object)__IdentRef);
        ArrayLiteral __ArrLit = TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)sourceTypeArrayElements, ArrayElement.class)));
        Pair _mappedTo_1 = Pair.of((Object)"parameterTypes", (Object)__ArrLit);
        return TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo, _mappedTo_1});
    }

    private ArrayElement _ParameterTypeArrayElement(TypeRef typeRef) {
        boolean _tripleNotEquals;
        ArrayElement _switchResult = null;
        boolean _matched = false;
        Type _declaredType = typeRef.getDeclaredType();
        boolean bl = _tripleNotEquals = _declaredType != null;
        if (_tripleNotEquals) {
            _matched = true;
            ArrayElement _switchResult_1 = null;
            Type _declaredType_1 = typeRef.getDeclaredType();
            boolean _matched_1 = false;
            if (_declaredType_1 instanceof TN4Classifier) {
                _matched_1 = true;
                _switchResult_1 = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.getSymbolTableEntryOriginal((IdentifiableElement)typeRef.getDeclaredType(), true)));
            }
            if (!_matched_1 && _declaredType_1 instanceof PrimitiveType) {
                _matched_1 = true;
                _switchResult_1 = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._StringLiteral((String)"primitive"));
            }
            if (!_matched_1 && _declaredType_1 instanceof TObjectPrototype) {
                _matched_1 = true;
                _switchResult_1 = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.getSymbolTableEntryOriginal((IdentifiableElement)typeRef.getDeclaredType(), true)));
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched && typeRef instanceof TypeTypeRef) {
            _matched = true;
            IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.getSymbolTableEntryOriginal((IdentifiableElement)this.getType((TypeTypeRef)typeRef), true));
            Pair _mappedTo = Pair.of((Object)"type", (Object)__IdentRef);
            _switchResult = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo}));
        }
        if (!_matched) {
            throw new IllegalStateException("Unhandled migration source type reference " + typeRef);
        }
        return _switchResult;
    }

    private Type getType(TypeTypeRef ref) {
        TypeArgument typeArg = ref.getTypeArg();
        if (typeArg instanceof TypeRef) {
            return ((TypeRef)typeArg).getDeclaredType();
        }
        return null;
    }

    private Statement _PushArrayElement(SymbolTableEntry arraySTE, Expression element) {
        return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)arraySTE), (SymbolTableEntry[])new SymbolTableEntry[]{this.getSymbolTableEntryInternal("push", true)}), (Expression[])new Expression[]{element}));
    }
}

