/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Comparator;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.workingsets.MementoAware;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetConfigurationDialog;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.util.Strings;
import org.osgi.service.prefs.Preferences;

public interface WorkingSetManager
extends Comparator<WorkingSet>,
MementoAware {
    public static final String EXTENSION_POINT_ID = String.valueOf(N4JSActivator.getInstance().getBundle().getSymbolicName()) + "." + Strings.toFirstLower((String)WorkingSetManager.class.getSimpleName());
    public static final WorkingSet[] EMPTY_ARRAY = new WorkingSet[0];

    public String getId();

    public String getLabel();

    default public Optional<Image> getImage() {
        return Optional.absent();
    }

    public WorkingSet[] getWorkingSets();

    public WorkingSet[] getAllWorkingSets();

    public void discardWorkingSetCaches();

    public void updateState(Diff<WorkingSet> var1);

    public void select(Iterable<WorkingSet> var1);

    default public void select(WorkingSet first, WorkingSet ... others) {
        this.select(Lists.asList((Object)first, (Object[])others));
    }

    public void unselect(Iterable<WorkingSet> var1);

    default public void unselect(WorkingSet first, WorkingSet ... others) {
        this.unselect(Lists.asList((Object)first, (Object[])others));
    }

    default public void configure() {
        new WorkingSetConfigurationDialog(this).open();
    }

    @Override
    default public int compare(WorkingSet left, WorkingSet right) {
        return 0;
    }

    @Override
    default public Preferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(this.getId());
    }

    public WorkingSetManagerBroker getWorkingSetManagerBroker();
}

