/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.antlr;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.eclipse.n4js.antlr.N4AntlrGeneratorFragment2;
import org.eclipse.n4js.antlr.replacements.Replacements;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xtext.generator.parser.antlr.GrammarNaming;

@Log
public class N4JSAntlrGeneratorFragment2
extends N4AntlrGeneratorFragment2 {
    @Inject
    private GrammarNaming productionNaming;
    private static final Logger LOG = Logger.getLogger(N4JSAntlrGeneratorFragment2.class);

    protected void generateProductionGrammar() {
        super.generateProductionGrammar();
        GrammarNaming naming = this.productionNaming;
        String _path = this.getProjectConfig().getRuntime().getSrcGen().getPath();
        String _plus = String.valueOf(_path) + "/";
        String _grammarFileName = naming.getParserGrammar(this.getGrammar()).getGrammarFileName();
        String absoluteParserFileName = String.valueOf(_plus) + _grammarFileName;
        this.massageGrammar(absoluteParserFileName, this.getCodeConfig().getEncoding());
    }

    private void massageGrammar(String absoluteParserFileName, String encoding) {
        try {
            boolean _equals_1;
            boolean _not;
            String javaFile = absoluteParserFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
            File _file = new File(javaFile);
            String content = Files.asCharSource((File)_file, (Charset)Charset.forName(encoding)).read();
            String normalizedContent = content.replace("\r\n", "\n");
            String newContent = this.fixIdentifierAsKeywordWithEOLAwareness(normalizedContent);
            boolean _equals = normalizedContent.equals(newContent);
            if (_equals) {
                LOG.warn((Object)("Replacement not found in " + javaFile));
            }
            boolean bl = _not = !(_equals_1 = content.equals(newContent));
            if (_not) {
                File _file_1 = new File(javaFile);
                Files.asCharSink((File)_file_1, (Charset)Charset.forName(encoding), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)newContent);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                throw new RuntimeException(e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected String getParserFileNameSuffix() {
        return ".java";
    }

    protected String getLexerFileNameSuffix() {
        return ".java";
    }

    private String fixIdentifierAsKeywordWithEOLAwareness(String normalizedContent) {
        String c1 = Replacements.applyReplacement(normalizedContent, "ruleNoLineTerminator.java.replacement");
        String c2 = Replacements.applyReplacement(c1, "rulePrimaryExpression.java.replacement");
        return c2;
    }
}

