/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.organize.imports.ImportProvidedElement;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.n4js.ui.organize.imports.ImportableObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;

public class ImportProvidedElementLabelprovider
implements ILabelProvider {
    @Inject
    private N4JSLabelProvider n4Labelprovider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public void addListener(ILabelProviderListener listener) {
        this.n4Labelprovider.addListener(listener);
    }

    public void dispose() {
        this.n4Labelprovider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.n4Labelprovider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.n4Labelprovider.removeListener(listener);
    }

    public Image getImage(Object element) {
        if (element instanceof ImportableObject) {
            return this.n4Labelprovider.getImage(((ImportableObject)element).getTe());
        }
        return this.n4Labelprovider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ImportableObject) {
            ImportableObject io = (ImportableObject)element;
            return this.getText(io.getTe());
        }
        if (element instanceof ImportProvidedElement) {
            ImportProvidedElement ele = (ImportProvidedElement)element;
            TModule tm = ((ImportDeclaration)ele.getImportSpecifier().eContainer()).getModule();
            return String.valueOf(ele.getLocalName()) + " from " + this.findLocation(tm);
        }
        if (element instanceof IEObjectDescription) {
            IEObjectDescription ieod = (IEObjectDescription)element;
            EObject eo = ieod.getEObjectOrProxy();
            if (eo instanceof TExportableElement && !eo.eIsProxy()) {
                return this.getText(eo);
            }
            return String.valueOf(ieod.getName().getLastSegment()) + " from " + this.qualifiedNameConverter.toString(ieod.getName().skipLast(1));
        }
        if (element instanceof TExportableElement) {
            TExportableElement te = (TExportableElement)element;
            return String.valueOf(te.getName()) + " (exported as " + te.getExportedName() + ") from " + this.findLocation(te.getContainingModule());
        }
        return this.n4Labelprovider.getText(element);
    }

    private String findLocation(TModule module) {
        return String.valueOf(module.getQualifiedName()) + " in " + module.getProjectName();
    }
}

