/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkLabelProvider;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;

public class N4JSHyperlinkHelper
extends HyperlinkHelper {
    @Inject
    @HyperlinkLabelProvider
    private ILabelProvider labelProvider;
    @Inject
    private Provider<XtextHyperlink> hyperlinkProvider;

    public void createHyperlinksTo(XtextResource from, Region region, EObject target, IHyperlinkAcceptor acceptor) {
        boolean linksProvided = this.provideHyperlinksForComposedTypes(from, region, target, acceptor);
        if (!linksProvided) {
            this.internalCreateHyperlinksTo(from, region, target, acceptor);
        }
    }

    private boolean provideHyperlinksForComposedTypes(XtextResource from, Region region, EObject target, IHyperlinkAcceptor acceptor) {
        TMember member;
        if (target instanceof TMember && (member = (TMember)target).isComposed()) {
            EList constituentMembers = member.getConstituentMembers();
            for (TMember constituentMember : constituentMembers) {
                this.internalCreateHyperlinksTo(from, region, (EObject)constituentMember, acceptor);
            }
            return true;
        }
        return false;
    }

    private void internalCreateHyperlinksTo(XtextResource from, Region region, EObject target, IHyperlinkAcceptor acceptor) {
        boolean linksProvided = this.provideHyperlinksForExternalFiles((IRegion)region, target, acceptor);
        if (!linksProvided) {
            super.createHyperlinksTo(from, region, target, acceptor);
        }
    }

    private boolean provideHyperlinksForExternalFiles(IRegion region, EObject target, IHyperlinkAcceptor acceptor) {
        URI targetUriWithFragment = EcoreUtil.getURI((EObject)target);
        if (targetUriWithFragment.isFile()) {
            URI uri = URIUtils.tryToPlatformUri((URI)targetUriWithFragment);
            this.superCreateHyperlinksTo(region, target, acceptor, uri);
            return true;
        }
        return false;
    }

    private void superCreateHyperlinksTo(IRegion region, EObject target, IHyperlinkAcceptor acceptor, URI normalized) {
        String hyperlinkText = this.labelProvider.getText((Object)target);
        XtextHyperlink result = (XtextHyperlink)this.hyperlinkProvider.get();
        result.setHyperlinkRegion(region);
        result.setURI(normalized);
        result.setHyperlinkText(hyperlinkText);
        acceptor.accept((IHyperlink)result);
    }
}

