/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.imports;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.resource.IEObjectDescription;

public class AmbiguousImportDescription
extends AbstractDescriptionWithError {
    private final List<IdentifiableElement> elements;
    private final String issueCode;
    private final EObject context;
    private final List<ImportSpecifier> originatingImports;

    public AmbiguousImportDescription(IEObjectDescription delegate, String issueCode, EObject context) {
        super(delegate);
        this.issueCode = issueCode;
        this.context = context;
        this.elements = Lists.newLinkedList();
        this.originatingImports = Lists.newLinkedList();
    }

    public String getMessage() {
        StringBuilder typeListStr = new StringBuilder();
        IdentifiableElement first = (IdentifiableElement)EcoreUtil.resolve((EObject)this.getEObjectOrProxy(), (EObject)this.context);
        String typeIdent = first instanceof Type ? "type" : "variable";
        TModule module = (TModule)first.eContainer();
        typeListStr.append(module.getQualifiedName());
        LinkedHashSet uniqueTypes = Sets.newLinkedHashSet(this.elements);
        uniqueTypes.remove(first);
        Iterator iter = uniqueTypes.iterator();
        while (iter.hasNext()) {
            IdentifiableElement type = (IdentifiableElement)iter.next();
            if (iter.hasNext()) {
                typeListStr.append(", ");
            } else {
                typeListStr.append(" and ");
            }
            typeListStr.append(((TModule)type.eContainer()).getQualifiedName());
        }
        if (this.issueCode == "IMP_AMBIGUOUS_WILDCARD") {
            return IssueCodes.getMessageForIMP_AMBIGUOUS_WILDCARD(typeIdent, this.getName(), typeListStr.toString());
        }
        if (this.issueCode == "IMP_AMBIGUOUS") {
            return IssueCodes.getMessageForIMP_AMBIGUOUS(typeIdent, this.getName(), typeListStr.toString());
        }
        if (this.issueCode == "IMP_DUPLICATE_NAMESPACE") {
            return IssueCodes.getMessageForIMP_DUPLICATE_NAMESPACE(this.getName(), "stub");
        }
        return "Unknown ambiguous import issue: " + this.issueCode + " for " + this.context + ".";
    }

    public List<IdentifiableElement> getElements() {
        return this.elements;
    }

    public List<ImportSpecifier> getOriginatingImports() {
        return this.originatingImports;
    }

    public String getIssueCode() {
        return this.issueCode;
    }
}

