/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.SiteBuildOperation;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class BuildSiteAction
implements IObjectActionDelegate {
    private ISiteModel fModel;
    private IFile fSiteXML;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fModel == null) {
            return;
        }
        ISiteFeature[] sbFeatures = this.fModel.getSite().getFeatures();
        IFeatureModel[] models = this.getFeatureModels(sbFeatures);
        if (models.length > 0) {
            try {
                this.ensureContentSaved();
                this.fModel.load();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
            SiteBuildOperation job = new SiteBuildOperation(models, this.fModel, PDEUIMessages.BuildSiteJob_name);
            job.setUser(true);
            job.schedule();
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_SITE_OBJ);
        }
    }

    private IFeatureModel[] getFeatureModels(ISiteFeature[] sFeatures) {
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        ISiteFeature[] iSiteFeatureArray = sFeatures;
        int n = sFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature siteFeature = iSiteFeatureArray[n2];
            IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(siteFeature.getId(), siteFeature.getVersion());
            if (model != null) {
                list.add(model);
            }
            ++n2;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IFile) {
            this.fSiteXML = (IFile)obj;
            this.fModel = new WorkspaceSiteModel(this.fSiteXML);
            try {
                this.fModel.load();
                ISiteFeature[] features = this.fModel.getSite().getFeatures();
                if (features.length <= 0) {
                    action.setEnabled(false);
                }
            }
            catch (CoreException coreException) {
                action.setEnabled(false);
            }
        }
    }

    private void ensureContentSaved() {
        IProject project;
        SiteEditor editor;
        if (this.fModel != null && this.fModel.getUnderlyingResource() != null && (editor = PDEModelUtility.getOpenUpdateSiteEditor(project = this.fModel.getUnderlyingResource().getProject())) != null && editor.isDirty()) {
            try {
                IRunnableWithProgress op = monitor -> editor.doSave(monitor);
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

