/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.VersionedElement;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.AccessibleTypeElement;
import org.eclipse.n4js.ts.types.DeclaredTypeWithAccessModifier;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVersionable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.AbstractFunctionDefinitionTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4IDLMigrationTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSFormalParameterTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.n4js.typesbuilder.VersionedTypesBuilderUtil;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class N4JSFunctionDefinitionTypesBuilder
extends AbstractFunctionDefinitionTypesBuilder {
    @Inject
    @Extension
    private N4JSFormalParameterTypesBuilder _n4JSFormalParameterTypesBuilder;
    @Inject
    @Extension
    private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
    @Inject
    @Extension
    private N4IDLMigrationTypesBuilder _n4IDLMigrationTypesBuilder;

    boolean relinkTFunction(FunctionDeclaration functionDecl, TModule target, boolean preLinkingPhase, int idx) {
        boolean _tripleEquals;
        Object _eGet = functionDecl.eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getTypeDefiningElement_DefinedType(), false);
        EObject functionDefinedType = (EObject)_eGet;
        if (functionDefinedType != null && !functionDefinedType.eIsProxy()) {
            throw new IllegalStateException("TFunction already created for FunctionDeclaration");
        }
        String _name = functionDecl.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return false;
        }
        Type _get = (Type)target.getTopLevelTypes().get(idx);
        TFunction functionType = (TFunction)_get;
        this._n4JSTypesBuilderHelper.ensureEqualName((NamedElement)functionDecl, (IdentifiableElement)functionType);
        this.relinkFormalParameters(functionType, (FunctionDefinition)functionDecl, preLinkingPhase);
        functionType.setAstElement((EObject)functionDecl);
        functionDecl.setDefinedType((Type)functionType);
        return true;
    }

    void createTFunction(FunctionDeclaration functionDecl, TModule target, boolean preLinkingPhase) {
        boolean _tripleEquals;
        Object _eGet = functionDecl.eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getTypeDefiningElement_DefinedType(), false);
        EObject functionDefinedType = (EObject)_eGet;
        if (functionDefinedType != null && !functionDefinedType.eIsProxy()) {
            throw new IllegalStateException("TFunction already created for FunctionDeclaration");
        }
        String _name = functionDecl.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)functionDecl.eResource().getResourceSet());
        TFunction functionType = this.createAndLinkTFunction((FunctionDefinition)functionDecl, preLinkingPhase);
        this.addFormalParameters(functionType, (FunctionDefinition)functionDecl, builtInTypeScope, preLinkingPhase);
        this._n4JSTypesBuilderHelper.setTypeAccessModifier((AccessibleTypeElement)functionType, functionDecl);
        this._n4JSTypesBuilderHelper.setProvidedByRuntime((DeclaredTypeWithAccessModifier)functionType, (AnnotableElement)functionDecl, preLinkingPhase);
        this.setReturnType(functionType, (FunctionDefinition)functionDecl, builtInTypeScope, preLinkingPhase);
        this.addTypeVariables(functionType, (GenericDeclaration)functionDecl, preLinkingPhase);
        this._n4JSTypesBuilderHelper.setDeclaredThisTypeFromAnnotation(functionType, (FunctionDefinition)functionDecl, preLinkingPhase);
        this._n4JSTypesBuilderHelper.copyAnnotations((TAnnotableElement)functionType, (AnnotableElement)functionDecl, preLinkingPhase);
        functionType.setDeclaredAsync(functionDecl.isAsync());
        functionType.setDeclaredGenerator(functionDecl.isGenerator());
        VersionedTypesBuilderUtil.setTypeVersion((TVersionable)functionType, (VersionedElement)functionDecl);
        EList _topLevelTypes = target.getTopLevelTypes();
        _topLevelTypes.add((Object)functionType);
        boolean _isMigrationDefinition = MigrationUtils.isMigrationDefinition((FunctionDefinition)functionDecl);
        if (_isMigrationDefinition) {
            this._n4IDLMigrationTypesBuilder.initialiseTMigration(functionDecl, (TMigration)functionType, preLinkingPhase);
        }
    }

    void createTFunction(FunctionExpression functionExpr, TModule target, boolean preLinkingPhase) {
        Object _eGet = functionExpr.eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getTypeDefiningElement_DefinedType(), false);
        EObject functionDefinedType = (EObject)_eGet;
        if (functionDefinedType != null && !functionDefinedType.eIsProxy()) {
            throw new IllegalStateException("TFunction already created for FunctionExpression");
        }
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)functionExpr.eResource().getResourceSet());
        TFunction functionType = this.createAndLinkTFunction((FunctionDefinition)functionExpr, preLinkingPhase);
        this.addFormalParametersWithInferredType(functionType, functionExpr, builtInTypeScope, preLinkingPhase);
        this.setReturnTypeWithInferredType(functionType, functionExpr, builtInTypeScope, preLinkingPhase);
        this.addTypeVariables(functionType, (GenericDeclaration)functionExpr, preLinkingPhase);
        this._n4JSTypesBuilderHelper.setDeclaredThisTypeFromAnnotation(functionType, (FunctionDefinition)functionExpr, preLinkingPhase);
        this._n4JSTypesBuilderHelper.copyAnnotations((TAnnotableElement)functionType, (AnnotableElement)functionExpr, preLinkingPhase);
        EList _internalTypes = target.getInternalTypes();
        _internalTypes.add((Object)functionType);
    }

    private void addFormalParametersWithInferredType(TFunction functionType, FunctionExpression functionExpr, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        Functions.Function1 _function = it -> this._n4JSFormalParameterTypesBuilder.createFormalParameter((FormalParameter)it, (TypeRef)TypeUtils.createDeferredTypeRef(), builtInTypeScope, preLinkingPhase);
        Iterables.addAll((Collection)functionType.getFpars(), (Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)functionExpr.getFpars(), (Functions.Function1)_function)));
    }

    private void setReturnTypeWithInferredType(TFunction functionType, FunctionExpression functionExpr, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            TypeRef _elvis = null;
            TypeRef _copyWithProxies = (TypeRef)TypeUtils.copyWithProxies((EObject)functionExpr.getReturnTypeRef());
            if (_copyWithProxies != null) {
                _elvis = _copyWithProxies;
            } else {
                DeferredTypeRef _createDeferredTypeRef = TypeUtils.createDeferredTypeRef();
                _elvis = _createDeferredTypeRef;
            }
            functionType.setReturnTypeRef(_elvis);
        }
    }

    private TFunction createAndLinkTFunction(FunctionDefinition functionDef, boolean preLinkingPhase) {
        TFunction functionType = this.createTFunction(functionDef);
        if (functionDef instanceof FunctionDeclaration) {
            functionType.setExportedName(((FunctionDeclaration)functionDef).getExportedName());
            functionType.setExternal(((FunctionDeclaration)functionDef).isExternal());
        }
        functionType.setName(functionDef.getName());
        functionType.setDeclaredAsync(functionDef.isAsync());
        functionType.setDeclaredGenerator(functionDef.isGenerator());
        functionType.setAstElement((EObject)functionDef);
        functionDef.setDefinedType((Type)functionType);
        return functionType;
    }

    private TFunction createTFunction(FunctionDefinition functionDef) {
        boolean _isMigrationDefinition = MigrationUtils.isMigrationDefinition(functionDef);
        if (_isMigrationDefinition) {
            return this._n4IDLMigrationTypesBuilder.createTMigration();
        }
        return TypesFactory.eINSTANCE.createTFunction();
    }
}

