/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.xpect.common.XpectCommentRemovalUtil;
import org.eclipse.n4js.xpect.ui.common.XpectN4JSES5GeneratorHelper;
import org.eclipse.n4js.xpect.ui.common.XpectN4JSES5TranspilerHelper;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.expectation.impl.AbstractExpectation;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.Assert;

public class OutputXpectMethod {
    private static final TestConfig[] DEFAULT_CONFIGS = new TestConfig[]{new TestConfig(GeneratorOption.MAX_TRANSPILE_OPTIONS), new TestConfig(GeneratorOption.DEFAULT_OPTIONS)};
    @Inject
    private XpectN4JSES5TranspilerHelper xpectN4JSES5TranpilerHelper;
    @Inject
    private XpectN4JSES5GeneratorHelper xpectGenerator;
    private static final Pattern NORMALIZE_WHITE_SPACE = Pattern.compile("(\\s)+");

    @Xpect
    public void output(@StringExpectation(whitespaceSensitive=false) IStringExpectation expectation, @ThisResource XtextResource resource, ISetupInitializer<Object> init, FileSetupContext fileSetupContext) throws IOException {
        TestExecutor func = config -> {
            String executionResult = this.xpectN4JSES5TranpilerHelper.doCompileAndExecute(resource, init, fileSetupContext, true, null, config.options);
            try {
                expectation.assertEquals((Object)executionResult);
            }
            catch (Throwable th) {
                expectation.assertEquals((Object)("======================================================================\nKind information from OutputXpectMethod:\nfollowing output was produced using generator options \"" + Joiner.on((String)", ").join((Object[])config.options) + "\"\n" + "======================================================================\n" + executionResult));
            }
        };
        OutputXpectMethod.runWithDefaultConfigs(func);
    }

    @Xpect
    public void outputRegex(@StringExpectation(whitespaceSensitive=true) IStringExpectation expectation, @ThisResource XtextResource resource, ISetupInitializer<Object> init, FileSetupContext fileSetupContext) throws IOException {
        TestExecutor func = config -> {
            String executionResult = this.xpectN4JSES5TranpilerHelper.doCompileAndExecute(resource, init, fileSetupContext, true, null, config.options);
            AbstractExpectation abstractEexpectation = (AbstractExpectation)expectation;
            String escapedActual = abstractEexpectation.getTargetSyntaxLiteral().escape(executionResult);
            String expected = abstractEexpectation.getExpectation();
            String escapedExpected = expected.replace("\r", "").replace("\n", "(\r?\n)");
            if (!Pattern.compile(escapedExpected).matcher(escapedActual).matches()) {
                Assert.assertEquals((String)"Regex did not match (Compare view not accurate, did not removed regex expressions)", (Object)OutputXpectMethod.regexToString(expected), (Object)OutputXpectMethod.regexToString(executionResult));
            }
        };
        OutputXpectMethod.runWithDefaultConfigs(func);
    }

    @Deprecated
    @Xpect
    public void compileResult(@StringExpectation(whitespaceSensitive=true) IStringExpectation expectation, @ThisResource XtextResource resource) {
        String compileResult = this.getCompileResult((Resource)resource, false);
        expectation.assertEquals((Object)compileResult);
    }

    @Xpect
    public void compileResultContains(@StringExpectation(whitespaceSensitive=true) IStringExpectation expectation, @ThisResource XtextResource resource) {
        String compileResult = this.getCompileResult((Resource)resource, false);
        OutputXpectMethod.assertExpectationContained(expectation, compileResult, "compile result");
    }

    private String getCompileResult(Resource resource, boolean replaceQuotes) {
        Script root = (Script)resource.getContents().get(0);
        StringBuilder compileResultSb = new StringBuilder();
        StringBuilder errorResultSb = new StringBuilder();
        if (this.xpectGenerator.isCompilable(resource, errorResultSb)) {
            compileResultSb.append(this.xpectGenerator.compile(root, GeneratorOption.MAX_TRANSPILE_OPTIONS, replaceQuotes));
        }
        String compileResult = "";
        compileResult = errorResultSb.length() > 0 ? errorResultSb.toString() : compileResultSb.toString();
        String newCompileResult = compileResult;
        do {
            compileResult = newCompileResult;
            newCompileResult = XpectCommentRemovalUtil.removeAllXpectComments((String)newCompileResult);
        } while (compileResult.length() != newCompileResult.length());
        return compileResult;
    }

    private static void assertExpectationContained(IStringExpectation expectation, String actual, String nameOfActual) {
        String expectationStr = ((AbstractExpectation)expectation).getExpectation();
        String expectationStrNormalized = NORMALIZE_WHITE_SPACE.matcher(expectationStr).replaceAll(" ").trim();
        String actualStrNormalized = NORMALIZE_WHITE_SPACE.matcher(actual).replaceAll(" ").trim();
        if (!actualStrNormalized.contains(expectationStrNormalized)) {
            Assert.fail((String)("Expectation string not contained in " + nameOfActual + " (after white-space normalization)\n" + "------ expectation string:\n" + expectationStr + "\n" + "------ " + nameOfActual + ":\n" + actual));
        }
    }

    private static String regexToString(String input) {
        StringBuffer buffer = new StringBuffer(input.length());
        int i = 0;
        while (i < input.length()) {
            if (input.charAt(i) == '\\') {
                buffer.append(".\\.");
            } else if (input.charAt(i) == '\n') {
                buffer.append("\\n");
            } else if (input.charAt(i) == '\r') {
                buffer.append("\\r");
            } else if (input.charAt(i) == '\t') {
                buffer.append("\\t");
            } else {
                buffer.append(input.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    private static void runWithDefaultConfigs(TestExecutor func) throws IOException {
        TestConfig[] testConfigArray = DEFAULT_CONFIGS;
        int n = DEFAULT_CONFIGS.length;
        int n2 = 0;
        while (n2 < n) {
            TestConfig config = testConfigArray[n2];
            func.accept(config);
            ++n2;
        }
    }

    private static final class TestConfig {
        GeneratorOption[] options;

        public TestConfig(GeneratorOption ... options) {
            this.options = options;
        }
    }

    @FunctionalInterface
    private static interface TestExecutor {
        public void accept(TestConfig var1) throws IOException;
    }
}

