/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class N4JSSuperValidator
extends AbstractN4JSDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public Boolean checkSuper(SuperLiteral superLiteral) {
        boolean _xblockexpression = false;
        EObject container = superLiteral.eContainer();
        N4MemberDeclaration containingMemberDecl = (N4MemberDeclaration)EcoreUtil2.getContainerOfType((EObject)container, N4MemberDeclaration.class);
        boolean _xifexpression = false;
        boolean _isSuperMemberAccess = superLiteral.isSuperMemberAccess();
        if (_isSuperMemberAccess) {
            _xifexpression = this.internalCheckSuperMemberAccess(superLiteral, containingMemberDecl);
        } else {
            boolean _xifexpression_1 = false;
            boolean _isSuperConstructorAccess = superLiteral.isSuperConstructorAccess();
            if (_isSuperConstructorAccess) {
                _xifexpression_1 = this.internalCheckSuperConstructorAccess(superLiteral, containingMemberDecl, (ParameterizedCallExpression)container);
            } else if (container instanceof NewExpression) {
                String message = IssueCodes.getMessageForKEY_SUP_NEW_NOT_SUPPORTED();
                this.addIssue(message, superLiteral.eContainer(), (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_NEW_NOT_SUPPORTED", new String[0]);
            } else {
                String message_1 = IssueCodes.getMessageForKEY_SUP_INVALID_USAGE();
                this.addIssue(message_1, superLiteral.eContainer(), (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_INVALID_USAGE", new String[0]);
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean internalCheckSuperConstructorAccess(SuperLiteral superLiteral, N4MemberDeclaration containingMemberDecl, ParameterizedCallExpression cexpr) {
        boolean _xifexpression = false;
        boolean _holdsExpressionOfExpressionStmt = this.holdsExpressionOfExpressionStmt(superLiteral, cexpr);
        if (_holdsExpressionOfExpressionStmt) {
            boolean _xblockexpression = false;
            EObject _eContainer = cexpr.eContainer();
            ExpressionStatement exprStmt = (ExpressionStatement)_eContainer;
            _xifexpression = _xblockexpression = this.holdsDirectlyContainedInConstructor(superLiteral, exprStmt, containingMemberDecl) && this.holdsNoThisOrReturnBefore(superLiteral, exprStmt, containingMemberDecl);
        }
        return _xifexpression;
    }

    private boolean holdsExpressionOfExpressionStmt(SuperLiteral superLiteral, ParameterizedCallExpression cexpr) {
        EObject _eContainer = cexpr.eContainer();
        if (_eContainer instanceof ExpressionStatement) {
            return true;
        }
        this.addIssue(IssueCodes.getMessageForKEY_SUP_CTOR_EXPRSTMT(), (EObject)cexpr, (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_CTOR_EXPRSTMT", new String[0]);
        return false;
    }

    private boolean holdsDirectlyContainedInConstructor(SuperLiteral superLiteral, ExpressionStatement exprStmt, N4MemberDeclaration containingMemberDecl) {
        boolean _not_1;
        boolean _not;
        EObject block = exprStmt.eContainer();
        boolean bl = _not = !(containingMemberDecl instanceof N4MethodDeclaration) || !Objects.equal((Object)containingMemberDecl.getName(), (Object)"constructor");
        if (_not) {
            return false;
        }
        boolean bl2 = _not_1 = !(block instanceof Block) || block.eContainer() != containingMemberDecl;
        if (_not_1) {
            EObject _xifexpression = null;
            _xifexpression = block instanceof Block ? ((Block)block).eContainer() : block;
            String msg = IssueCodes.getMessageForKEY_SUP_CTOR_NESTED(this.validatorMessageHelper.descriptionWithLine(_xifexpression));
            this.addIssue(msg, superLiteral.eContainer(), (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_CTOR_NESTED", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsNoThisOrReturnBefore(SuperLiteral superLiteral, ExpressionStatement exprStmt, N4MemberDeclaration containingMemberDecl) {
        EList _statements = this.getBody(containingMemberDecl).getStatements();
        for (Statement stmt : _statements) {
            if (stmt == exprStmt) {
                return true;
            }
            if (stmt instanceof ReturnStatement) {
                String msg = IssueCodes.getMessageForKEY_SUP_CTOR_INVALID_EXPR_BEFORE(this.validatorMessageHelper.descriptionWithLine((EObject)stmt));
                this.addIssue(msg, superLiteral.eContainer(), (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_CTOR_INVALID_EXPR_BEFORE", new String[0]);
                return false;
            }
            Predicate _function = it -> !(it instanceof FunctionOrFieldAccessor);
            Functions.Function1 _function_1 = it -> it instanceof ThisLiteral || it instanceof ReturnStatement;
            EObject thisKeyword = (EObject)IteratorExtensions.findFirst((Iterator)EcoreUtilN4.getAllContentsFiltered((EObject)stmt, (Predicate)_function), (Functions.Function1)_function_1);
            if (thisKeyword == null) continue;
            String msg_1 = IssueCodes.getMessageForKEY_SUP_CTOR_INVALID_EXPR_BEFORE(this.validatorMessageHelper.descriptionWithLine(thisKeyword));
            this.addIssue(msg_1, superLiteral.eContainer(), (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_CTOR_INVALID_EXPR_BEFORE", new String[0]);
            return false;
        }
        String msg = IssueCodes.getMessageForKEY_SUP_CTOR_NESTED(this.validatorMessageHelper.descriptionWithLine(exprStmt.eContainer()));
        this.addIssue(msg, superLiteral.eContainer(), (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_CTOR_NESTED", new String[0]);
        return false;
    }

    private boolean internalCheckSuperMemberAccess(SuperLiteral superLiteral, N4MemberDeclaration containingMemberDecl) {
        return this.holdsSuperCallInMethodOrFieldAccessor(superLiteral, containingMemberDecl) && this.holdsSuperCallNotNested(superLiteral, containingMemberDecl) && this.holdsSuperIsReceiverOfCall(superLiteral) && this.holdsSuperMethodIsConcrete(superLiteral);
    }

    private boolean holdsSuperMethodIsConcrete(SuperLiteral superLiteral) {
        IdentifiableElement _property;
        TMethod method;
        boolean _isAbstract;
        EObject literalContainer = superLiteral.eContainer();
        if (literalContainer instanceof ParameterizedPropertyAccessExpression && ((ParameterizedPropertyAccessExpression)literalContainer).getProperty() instanceof TMethod && (_isAbstract = (method = (TMethod)(_property = ((ParameterizedPropertyAccessExpression)literalContainer).getProperty())).isAbstract())) {
            this.addIssue(IssueCodes.getMessageForCLF_CANNOT_CALL_ABSTRACT_SUPER_METHOD(), literalContainer, (EStructuralFeature)N4JSPackage.Literals.PARAMETERIZED_PROPERTY_ACCESS_EXPRESSION__PROPERTY, "CLF_CANNOT_CALL_ABSTRACT_SUPER_METHOD", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsSuperIsReceiverOfCall(SuperLiteral superLiteral) {
        if (superLiteral.eContainer() instanceof ParameterizedPropertyAccessExpression && ((ParameterizedPropertyAccessExpression)superLiteral.eContainer()).getProperty() instanceof TField) {
            EObject _eContainer = superLiteral.eContainer();
            this.addIssue(IssueCodes.getMessageForKEY_SUP_ACCESS_FIELD(), (EObject)((ParameterizedPropertyAccessExpression)_eContainer), (EStructuralFeature)N4JSPackage.Literals.PARAMETERIZED_PROPERTY_ACCESS_EXPRESSION__PROPERTY, "KEY_SUP_ACCESS_FIELD", new String[0]);
            return false;
        }
        EObject _eContainer_1 = superLiteral.eContainer();
        if (_eContainer_1 instanceof IndexedAccessExpression) {
            EObject _eContainer_2 = superLiteral.eContainer();
            this.addIssue(IssueCodes.getMessageForKEY_SUP_CALL_NO_INDEXACCESS(), (EObject)((IndexedAccessExpression)_eContainer_2), (EStructuralFeature)N4JSPackage.Literals.EXPRESSION_WITH_TARGET__TARGET, "KEY_SUP_CALL_NO_INDEXACCESS", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsSuperCallNotNested(SuperLiteral superLiteral, N4MemberDeclaration containingMemberDecl) {
        boolean _tripleNotEquals;
        FunctionOrFieldAccessor _containerOfType = (FunctionOrFieldAccessor)EcoreUtil2.getContainerOfType((EObject)superLiteral.eContainer(), FunctionOrFieldAccessor.class);
        boolean bl = _tripleNotEquals = _containerOfType != containingMemberDecl;
        if (_tripleNotEquals) {
            this.addIssue(IssueCodes.getMessageForKEY_SUP_NESTED(), superLiteral.eContainer(), (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_NESTED", new String[0]);
            return false;
        }
        return true;
    }

    public boolean holdsSuperCallInMethodOrFieldAccessor(SuperLiteral superLiteral, N4MemberDeclaration containingMemberDecl) {
        if (!(containingMemberDecl instanceof N4MethodDeclaration || containingMemberDecl instanceof N4GetterDeclaration || containingMemberDecl instanceof N4SetterDeclaration)) {
            return false;
        }
        EObject _eContainer = null;
        if (containingMemberDecl != null) {
            _eContainer = containingMemberDecl.eContainer();
        }
        if (_eContainer instanceof N4InterfaceDeclaration) {
            this.addIssue(IssueCodes.getMessageForKEY_SUP_ACCESS_INVALID_LOC_INTERFACE(), superLiteral.eContainer(), (EStructuralFeature)superLiteral.eContainmentFeature(), "KEY_SUP_ACCESS_INVALID_LOC_INTERFACE", new String[0]);
            return false;
        }
        return true;
    }
}

