/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.n4js.ide.server.codeActions.CodeActionAcceptor;
import org.eclipse.n4js.ide.server.codeActions.Fix;
import org.eclipse.n4js.ide.server.codeActions.Fixes;
import org.eclipse.n4js.ide.server.codeActions.ICodeActionAcceptor;
import org.eclipse.n4js.ide.server.codeActions.N4JSQuickfixProvider;
import org.eclipse.n4js.ide.server.codeActions.N4JSSourceActionProvider;
import org.eclipse.n4js.ide.server.codeActions.QuickfixContext;
import org.eclipse.n4js.ide.server.codeActions.SourceAction;
import org.eclipse.n4js.ide.xtext.server.DiagnosticIssueConverter;
import org.eclipse.n4js.ide.xtext.server.XLanguageServerImpl;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.validation.Issue;

@Singleton
public class N4JSCodeActionService
implements ICodeActionService2 {
    final Class<?>[] quickfixProviders = new Class[]{N4JSQuickfixProvider.class};
    final Class<?>[] sourceActionProviders = new Class[]{N4JSSourceActionProvider.class};
    @Inject
    private XLanguageServerImpl languageServer;
    @Inject
    private XWorkspaceManager workspaceManager;
    @Inject
    private DiagnosticIssueConverter diagnosticIssueConverter;
    @Inject
    private UriExtensions uriExtensions;
    @Inject
    private OperationCanceledManager cancelManager;
    private final Multimap<String, QuickFixImplementation> quickfixMap = HashMultimap.create();
    private final List<SourceActionImplementation> sourceActions = new ArrayList<SourceActionImplementation>();

    @Inject
    public void init(Injector injector) {
        int modifiers;
        Method method;
        int n;
        int n2;
        Method[] methodArray;
        Method[] methods;
        Class<?>[] classArray = this.quickfixProviders;
        int n3 = this.quickfixProviders.length;
        int n4 = 0;
        while (n4 < n3) {
            Class<?> quickFixProvider = classArray[n4];
            Object qpInstance = injector.getInstance(quickFixProvider);
            methodArray = methods = quickFixProvider.getMethods();
            n2 = methods.length;
            n = 0;
            while (n < n2) {
                method = methodArray[n];
                modifiers = method.getModifiers();
                if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) {
                    Fix fix;
                    Fixes fixes = method.getAnnotation(Fixes.class);
                    if (fixes != null) {
                        Fix[] fixArray = fixes.value();
                        int n5 = fixArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            fix = fixArray[n6];
                            this.acceptFix(fix, qpInstance, method);
                            ++n6;
                        }
                    }
                    if ((fix = method.getAnnotation(Fix.class)) != null) {
                        this.acceptFix(fix, qpInstance, method);
                    }
                }
                ++n;
            }
            ++n4;
        }
        classArray = this.sourceActionProviders;
        n3 = this.sourceActionProviders.length;
        n4 = 0;
        while (n4 < n3) {
            Class<?> sourceActionProvider = classArray[n4];
            Object providerInstance = injector.getInstance(sourceActionProvider);
            methodArray = methods = sourceActionProvider.getMethods();
            n2 = methods.length;
            n = 0;
            while (n < n2) {
                SourceAction ann;
                method = methodArray[n];
                modifiers = method.getModifiers();
                if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && (ann = method.getAnnotation(SourceAction.class)) != null) {
                    this.sourceActions.add(new SourceActionImplementation(providerInstance, method));
                }
                ++n;
            }
            ++n4;
        }
    }

    private void acceptFix(Fix fix, Object instance, Method method) {
        String issueCode = fix.value();
        if (!Strings.isNullOrEmpty((String)issueCode)) {
            QuickFixImplementation impl = new QuickFixImplementation(instance, method, fix.multiFix());
            this.quickfixMap.put((Object)issueCode, (Object)impl);
        }
    }

    public List<Either<Command, CodeAction>> getCodeActions(ICodeActionService2.Options options) {
        CodeActionAcceptor acceptor = new CodeActionAcceptor();
        List diagnostics = null;
        if (options.getCodeActionParams() != null && options.getCodeActionParams().getContext() != null) {
            diagnostics = options.getCodeActionParams().getContext().getDiagnostics();
        }
        if (diagnostics == null) {
            diagnostics = Collections.emptyList();
        }
        for (Diagnostic diag : diagnostics) {
            this.cancelManager.checkCanceled(options.getCancelIndicator());
            this.findQuickfixes(diag.getCode(), options, acceptor);
        }
        this.findSourceActions(options, acceptor);
        this.cancelManager.checkCanceled(options.getCancelIndicator());
        return acceptor.getList();
    }

    public void findQuickfixes(String code, ICodeActionService2.Options options, CodeActionAcceptor acceptor) {
        for (QuickFixImplementation qfix : this.quickfixMap.get((Object)code)) {
            ICodeActionAcceptor accTmp = qfix.multiFix ? new MultiQuickfixAcceptor(qfix.id, acceptor) : acceptor;
            qfix.compute(code, options, accTmp);
        }
    }

    private void findSourceActions(ICodeActionService2.Options options, CodeActionAcceptor acceptor) {
        for (SourceActionImplementation impl : this.sourceActions) {
            impl.compute(options, acceptor);
        }
    }

    public WorkspaceEdit applyToFile(String code, String id, ICodeActionService2.Options options) {
        WorkspaceEdit result = new WorkspaceEdit();
        QuickFixImplementation quickfix = this.findOriginatingQuickfix(code, id);
        if (quickfix == null) {
            return result;
        }
        TextEditCollector collector = new TextEditCollector();
        XProjectManager projectManager = this.getCurrentProject(options);
        String uriString = options.getCodeActionParams().getTextDocument().getUri();
        URI uri = this.uriExtensions.toUri(uriString);
        Collection<Issue> issues = projectManager.getProjectStateHolder().getValidationIssues().get(uri);
        for (Issue issue : issues) {
            if (!code.equals(issue.getCode())) continue;
            ICodeActionService2.Options newOptions = this.copyOptions(options, options.getCodeActionParams().getTextDocument(), issue);
            quickfix.compute(code, newOptions, collector);
        }
        result.setChanges(collector.allEdits);
        return result;
    }

    public WorkspaceEdit applyToProject(String code, String id, ICodeActionService2.Options options) {
        WorkspaceEdit result = new WorkspaceEdit();
        QuickFixImplementation quickfix = this.findOriginatingQuickfix(code, id);
        if (quickfix == null) {
            return result;
        }
        TextEditCollector collector = new TextEditCollector();
        XProjectManager projectManager = this.getCurrentProject(options);
        Map<URI, Collection<Issue>> validationIssues = projectManager.getProjectStateHolder().getValidationIssues();
        for (Map.Entry<URI, Collection<Issue>> entry : validationIssues.entrySet()) {
            URI uri = entry.getKey();
            Collection<Issue> issues = entry.getValue();
            TextDocumentIdentifier docIdentifier = new TextDocumentIdentifier(this.uriExtensions.toUriString(uri));
            for (Issue issue : issues) {
                if (!code.equals(issue.getCode())) continue;
                ICodeActionService2.Options newOptions = this.copyOptions(options, docIdentifier, issue);
                quickfix.compute(code, newOptions, collector);
            }
        }
        result.setChanges(collector.allEdits);
        return result;
    }

    private ICodeActionService2.Options copyOptions(ICodeActionService2.Options options, TextDocumentIdentifier docIdentifier, Issue issue) {
        Diagnostic diagnostic = this.diagnosticIssueConverter.toDiagnostic(issue, this.workspaceManager);
        CodeActionContext context = new CodeActionContext(Collections.singletonList(diagnostic));
        CodeActionParams codeActionParams = new CodeActionParams(docIdentifier, diagnostic.getRange(), context);
        ICodeActionService2.Options newOptions = this.languageServer.toOptions(codeActionParams, options.getCancelIndicator());
        return newOptions;
    }

    private XProjectManager getCurrentProject(ICodeActionService2.Options options) {
        String uriString = options.getCodeActionParams().getTextDocument().getUri();
        URI uri = this.uriExtensions.toUri(uriString);
        XProjectManager projectManager = this.workspaceManager.getProjectManager(uri);
        return projectManager;
    }

    private QuickFixImplementation findOriginatingQuickfix(String code, String id) {
        for (QuickFixImplementation quickfix : this.quickfixMap.get((Object)code)) {
            if (!quickfix.id.equals(id)) continue;
            return quickfix;
        }
        return null;
    }

    private static abstract class CodeActionImplementation {
        final Object instance;
        final Method method;
        final String id;

        private CodeActionImplementation(Object instance, Method method) {
            this.instance = instance;
            this.method = method;
            this.id = method.getName();
        }
    }

    private static class MultiQuickfixAcceptor
    implements ICodeActionAcceptor {
        final String quickfixId;
        final CodeActionAcceptor acceptor;

        private MultiQuickfixAcceptor(String quickfixId, CodeActionAcceptor acceptor) {
            this.quickfixId = quickfixId;
            this.acceptor = acceptor;
        }

        @Override
        public void acceptQuickfixCodeAction(QuickfixContext context, String title, List<TextEdit> textEdits) {
            this.acceptor.acceptQuickfixCodeAction(context, title, textEdits);
            this.acceptor.acceptQuickfixCommand(context, String.valueOf(title) + " (entire file)", "n4js.composite.fix.file", title, context.issueCode, this.quickfixId, context.options.getCodeActionParams());
            this.acceptor.acceptQuickfixCommand(context, String.valueOf(title) + " (entire project)", "n4js.composite.fix.project", title, context.issueCode, this.quickfixId, context.options.getCodeActionParams());
        }

        @Override
        public void acceptQuickfixCommand(QuickfixContext context, String title, String commandID, Object ... arguments) {
            this.acceptor.acceptQuickfixCommand(context, title, commandID, arguments);
        }

        @Override
        public void acceptSourceAction(String title, String kind, String commandId, Object ... arguments) {
            throw new IllegalStateException("cannot create source actions with code action acceptor " + MultiQuickfixAcceptor.class);
        }
    }

    private static class QuickFixImplementation
    extends CodeActionImplementation {
        final boolean multiFix;

        private QuickFixImplementation(Object instance, Method method, boolean multiFix) {
            super(instance, method);
            this.multiFix = multiFix;
        }

        void compute(String code, ICodeActionService2.Options options, ICodeActionAcceptor acceptor) {
            XtextResource resource = options.getResource();
            if (!(resource instanceof N4JSResource)) {
                return;
            }
            QuickfixContext context = new QuickfixContext((N4JSResource)resource, code, options);
            try {
                this.method.invoke(this.instance, context, acceptor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class SourceActionImplementation
    extends CodeActionImplementation {
        private SourceActionImplementation(Object instance, Method method) {
            super(instance, method);
        }

        void compute(ICodeActionService2.Options options, ICodeActionAcceptor acceptor) {
            CodeActionParams params = options.getCodeActionParams();
            try {
                this.method.invoke(this.instance, params, acceptor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class TextEditCollector
    implements ICodeActionAcceptor {
        private final Map<String, List<TextEdit>> allEdits = new HashMap<String, List<TextEdit>>();

        private TextEditCollector() {
        }

        @Override
        public void acceptQuickfixCommand(QuickfixContext context, String title, String commandID, Object ... arguments) {
            throw new UnsupportedOperationException("TODO implement composite post-text-edit-apply actions if necessary");
        }

        @Override
        public void acceptQuickfixCodeAction(QuickfixContext context, String title, List<TextEdit> textEdits) {
            String uriString = context.options.getCodeActionParams().getTextDocument().getUri();
            this.allEdits.computeIfAbsent(uriString, ignore -> new ArrayList()).addAll(textEdits);
        }

        @Override
        public void acceptSourceAction(String title, String kind, String commandId, Object ... arguments) {
            throw new IllegalStateException("cannot create source actions with code action acceptor " + TextEditCollector.class);
        }
    }
}

