/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping.builtin;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.n4js.ts.scoping.builtin.BasicResourceSetProvider;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInSchemeRegistrar;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInSchemeResourceLocator;
import org.eclipse.n4js.ts.scoping.builtin.ResourceSetWithBuiltInSchemeProvider;
import org.eclipse.n4js.xtext.resourceset.EmptyAuthorityAddingNormalizer;
import org.eclipse.n4js.xtext.resourceset.XtextResourceLocator;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.UriExtensions;

@Singleton
public class ConfiguredResourceSetProvider
extends BasicResourceSetProvider {
    private final BuiltInSchemeRegistrar builtInSchemeRegistrar;
    private final ClassLoader classLoader;
    private final ResourceSet resourceSetWithBuiltIns;
    private final UriExtensions uriExtensions;

    @Inject
    public ConfiguredResourceSetProvider(BuiltInSchemeRegistrar builtInSchemeRegistrar, ClassLoader classLoader, ResourceSetWithBuiltInSchemeProvider builtInProvider, UriExtensions uriExtensions) {
        this.builtInSchemeRegistrar = builtInSchemeRegistrar;
        this.classLoader = classLoader;
        this.uriExtensions = uriExtensions;
        this.resourceSetWithBuiltIns = builtInProvider.getResourceSet();
    }

    @Override
    public SynchronizedXtextResourceSet get() {
        SynchronizedXtextResourceSet result = super.get();
        result.setClasspathURIContext((Object)this.classLoader);
        this.initialize(result);
        return result;
    }

    protected void initialize(SynchronizedXtextResourceSet resourceSet) {
        this.attachXtextResourceLocator(resourceSet);
        this.attachBuiltInSchemeResourceLocator(resourceSet);
        resourceSet.setURIConverter((URIConverter)new EmptyAuthorityAddingNormalizer(resourceSet.getURIConverter(), this.uriExtensions));
        this.builtInSchemeRegistrar.registerScopes((ResourceSet)resourceSet, this.resourceSetWithBuiltIns);
    }

    private ResourceSetImpl.ResourceLocator attachBuiltInSchemeResourceLocator(SynchronizedXtextResourceSet result) {
        return new BuiltInSchemeResourceLocator((ResourceSetImpl)result, this.resourceSetWithBuiltIns);
    }

    private ResourceSetImpl.ResourceLocator attachXtextResourceLocator(SynchronizedXtextResourceSet resourceSet) {
        return new XtextResourceLocator((XtextResourceSet)resourceSet);
    }
}

