/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.organize.imports.ScriptDependencyResolver;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.ParameterizedTypeRef_IM;
import org.eclipse.n4js.transpiler.im.ReferencingElement_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.StaticPolyfillHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class StaticPolyfillTransformation
extends Transformation {
    @Inject
    private StaticPolyfillHelper staticPolyfillHelper;
    private Set<SymbolTableEntryOriginal> referencedElements = CollectionLiterals.newHashSet();
    private Set<String> referencedElementsAliases = CollectionLiterals.newHashSet();

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        N4JSResource fillingResource;
        boolean isAware = N4JSLanguageUtils.isContainedInStaticPolyfillAware((AnnotableElement)this.getState().resource.getScript());
        if (isAware && (fillingResource = this.staticPolyfillHelper.getStaticPolyfillResource((Resource)this.getState().resource)) != null) {
            this.referencedElements.clear();
            Consumer<N4ClassDeclaration> _function = it -> this.doStaticPolyfilling((N4ClassDeclaration)it);
            this.collectNodes((EObject)this.getState().im, N4ClassDeclaration.class, false).forEach(_function);
            Consumer<SymbolTableEntryOriginal> _function_1 = it -> this.addImportIfRequired((SymbolTableEntryOriginal)it, fillingResource);
            this.referencedElements.forEach(_function_1);
        }
    }

    private void doStaticPolyfilling(N4ClassDeclaration classDecl) {
        TClass defCls = this.getState().info.getOriginalDefinedType(classDecl);
        N4ClassDeclaration filler = this.staticPolyfillHelper.getStaticPolyfill((Type)defCls);
        if (filler != null) {
            this.doStaticPolyfilling(classDecl, filler);
        }
    }

    private void doStaticPolyfilling(N4ClassDeclaration classFilled, N4ClassDeclaration classFiller) {
        Functions.Function1 _function = it -> it.getDeclaredType_IM();
        Set currentIfcs = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)classFilled.getImplementedInterfaceRefs(), ParameterizedTypeRef_IM.class), (Functions.Function1)_function), TInterface.class));
        Consumer<ParameterizedTypeRef> _function_1 = it -> this.insertImplementedInterface((N4ClassDefinition)classFilled, (ParameterizedTypeRef)it, currentIfcs);
        classFiller.getImplementedInterfaceRefs().forEach(_function_1);
        Consumer<N4MemberDeclaration> _function_2 = it -> this.insertMember((N4ClassDefinition)classFilled, (N4MemberDeclaration)it);
        classFiller.getOwnedMembers().forEach(_function_2);
    }

    private void insertImplementedInterface(N4ClassDefinition classFilled, ParameterizedTypeRef ifcRefToBeInserted, Set<TInterface> currentIfcs) {
        Type ifcType = ifcRefToBeInserted.getDeclaredType();
        if (ifcType instanceof TInterface) {
            boolean _not;
            boolean _contains = currentIfcs.contains(ifcType);
            boolean bl = _not = !_contains;
            if (_not) {
                SymbolTableEntryOriginal ifcSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)ifcType, true);
                EList _implementedInterfaceRefs = classFilled.getImplementedInterfaceRefs();
                ParameterizedTypeRef_IM __ParameterizedTypeRef = TranspilerBuilderBlocks._ParameterizedTypeRef((SymbolTableEntry)ifcSTE);
                _implementedInterfaceRefs.add((Object)__ParameterizedTypeRef);
            }
        }
    }

    private void insertMember(N4ClassDefinition classFilled, N4MemberDeclaration memberToBeInserted) {
        Functions.Function1 _function = it -> it.eClass() == memberToBeInserted.eClass() && Objects.equal((Object)it.getName(), (Object)memberToBeInserted.getName());
        N4MemberDeclaration existing = (N4MemberDeclaration)IterableExtensions.findFirst((Iterable)classFilled.getOwnedMembers(), (Functions.Function1)_function);
        N4MemberDeclaration copy = (N4MemberDeclaration)this.copyAlienElement((EObject)memberToBeInserted);
        Functions.Function1 _function_1 = it -> it.getRewiredTarget();
        List _list = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)copy.eAllContents(), ReferencingElement_IM.class), (Functions.Function1)_function_1), SymbolTableEntryOriginal.class));
        Iterables.addAll(this.referencedElements, (Iterable)_list);
        if (existing != null) {
            this.replace(existing, copy);
        } else {
            EList _ownedMembersRaw = classFilled.getOwnedMembersRaw();
            _ownedMembersRaw.add((Object)copy);
        }
        this.getState().info.setOriginalDefinedMember(copy, memberToBeInserted.getDefinedTypeElement());
    }

    private void addImportIfRequired(SymbolTableEntryOriginal ste, N4JSResource fillingResource) {
        boolean _tripleEquals;
        ImportSpecifier _importSpecifier = ste.getImportSpecifier();
        boolean bl = _tripleEquals = _importSpecifier == null;
        if (_tripleEquals) {
            boolean isNested;
            IdentifiableElement originalTarget = ste.getOriginalTarget();
            boolean bl2 = isNested = originalTarget instanceof TMember || originalTarget instanceof TEnumLiteral;
            if (!isNested) {
                boolean isLocal;
                Resource _eResource = originalTarget.eResource();
                boolean bl3 = isLocal = _eResource == this.getState().resource;
                if (!isLocal && ScriptDependencyResolver.shouldBeImported((TModule)fillingResource.getModule(), (EObject)originalTarget)) {
                    this.addImport(ste, fillingResource);
                }
            }
        }
    }

    private void addImport(SymbolTableEntryOriginal ste, N4JSResource fillingResource) {
        EObject impDecl_original;
        IdentifiableElement importedElement = ste.getOriginalTarget();
        boolean isNamespace = importedElement instanceof ModuleNamespaceVirtualType;
        TModule _xifexpression = null;
        _xifexpression = isNamespace ? ((ModuleNamespaceVirtualType)importedElement).getModule() : (TModule)EcoreUtil2.getContainerOfType((EObject)importedElement, TModule.class);
        TModule remoteModule = _xifexpression;
        Functions.Function1 _function = it -> {
            TModule _module = it.getModule();
            return _module == remoteModule;
        };
        Functions.Function1 _function_1 = it -> it.getImportSpecifiers();
        Iterable impSpecsForContainingModule = Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)fillingResource.getScript().getScriptElements(), ImportDeclaration.class), (Functions.Function1)_function), (Functions.Function1)_function_1));
        ImportSpecifier _xifexpression_1 = null;
        if (isNamespace) {
            Functions.Function1 _function_2 = it -> {
                Type _definedType = it.getDefinedType();
                return _definedType == importedElement;
            };
            _xifexpression_1 = (ImportSpecifier)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)impSpecsForContainingModule, NamespaceImportSpecifier.class), (Functions.Function1)_function_2);
        } else {
            Functions.Function1 _function_3 = it -> {
                TExportableElement _importedElement = it.getImportedElement();
                return _importedElement == importedElement;
            };
            _xifexpression_1 = (ImportSpecifier)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)impSpecsForContainingModule, NamedImportSpecifier.class), (Functions.Function1)_function_3);
        }
        ImportSpecifier impSpec_original = _xifexpression_1;
        EObject _eContainer = null;
        if (impSpec_original != null) {
            _eContainer = impSpec_original.eContainer();
        }
        if ((impDecl_original = _eContainer) != null && impSpec_original != null) {
            String _exportedName;
            String _elvis = null;
            String _elvis_1 = null;
            String _alias = StaticPolyfillTransformation.getAlias(impSpec_original);
            _elvis_1 = _alias != null ? _alias : (_exportedName = ste.getExportedName());
            _elvis = _elvis_1 != null ? _elvis_1 : "unnamed";
            String alias = this.chooseNewUniqueAlias(_elvis);
            Object _xifexpression_2 = null;
            _xifexpression_2 = isNamespace ? TranspilerBuilderBlocks._NamespaceImportSpecifier((String)alias, (boolean)true) : TranspilerBuilderBlocks._NamedImportSpecifier((String)ste.getExportedName(), (String)alias, (boolean)true);
            NamespaceImportSpecifier impSpec = _xifexpression_2;
            ImportDeclaration impDecl = TranspilerBuilderBlocks._ImportDecl((ImportSpecifier[])new ImportSpecifier[]{impSpec});
            this.getState().im.getScriptElements().add(0, (Object)impDecl);
            ste.setName(alias);
            ste.setImportSpecifier((ImportSpecifier)impSpec);
            this.getState().tracer.setOriginalASTNode((EObject)impDecl, impDecl_original);
            this.getState().tracer.setOriginalASTNode((EObject)impSpec, (EObject)impSpec_original);
            this.getState().info.setImportedModule(impDecl, remoteModule);
        }
    }

    private String chooseNewUniqueAlias(String baseName) {
        String alias = null;
        int cnt = 0;
        do {
            String _xifexpression = null;
            _xifexpression = cnt == 0 ? "" : Integer.toString(cnt);
            String cntStr = _xifexpression;
            alias = String.valueOf(baseName) + cntStr + "$polyfilled";
            ++cnt;
        } while (this.referencedElementsAliases.contains(alias));
        this.referencedElementsAliases.add(alias);
        return alias;
    }

    private static final String getAlias(ImportSpecifier impSpec) {
        String _switchResult = null;
        boolean _matched = false;
        if (impSpec instanceof NamedImportSpecifier) {
            _matched = true;
            _switchResult = ((NamedImportSpecifier)impSpec).getAlias();
        }
        if (!_matched && impSpec instanceof NamespaceImportSpecifier) {
            _matched = true;
            _switchResult = ((NamespaceImportSpecifier)impSpec).getAlias();
        }
        return _switchResult;
    }
}

