/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.labeling;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.n4js.ide.server.hover.N4JSElementSignatureProvider;
import org.eclipse.n4js.jsdoc.JSDoc2HoverSerializer;
import org.eclipse.n4js.jsdoc.N4JSDocletParser;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.ui.labeling.TypesHoverProvider;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.labeling.helper.ImageFileNameCalculationHelper;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.osgi.framework.Bundle;

public class N4JSHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject
    @Extension
    private N4JSElementKeywordProvider _n4JSElementKeywordProvider;
    @Inject
    private N4JSElementSignatureProvider signatureProvider;
    @Inject
    private TypesHoverProvider typesHoverProvider;
    @Inject
    private OperationCanceledManager cancelManager;
    @Inject
    private N4JSDocletParser docletParser;
    private static final String MDN_STRING_START = "@see <a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/";
    private static final String MDN_STRING_END = "\">MDN Documentation</a>";
    @Inject
    private ImageFileNameCalculationHelper h;

    protected String getFirstLine(EObject o) {
        if (o instanceof LiteralOrComputedPropertyName) {
            return this.getFirstLine(((LiteralOrComputedPropertyName)o).eContainer());
        }
        EObject id = this.getIdentifiableElement(o);
        URL image = this.getImageURL(id);
        String keyword = this._n4JSElementKeywordProvider.keyword((Object)id);
        String label = this.getLabel(o);
        return TypesHoverProvider.composeFirstLine((URL)image, (String)keyword, (String)label);
    }

    private EObject getIdentifiableElement(EObject o) {
        IdentifiableElement _switchResult = null;
        boolean _matched = false;
        if (o instanceof IdentifierRef) {
            _matched = true;
            _switchResult = ((IdentifierRef)o).getId();
        }
        if (!_matched && o instanceof ParameterizedPropertyAccessExpression) {
            _matched = true;
            _switchResult = ((ParameterizedPropertyAccessExpression)o).getProperty();
        }
        if (!_matched && o instanceof LiteralOrComputedPropertyName) {
            _matched = true;
            _switchResult = ((LiteralOrComputedPropertyName)o).eContainer();
        }
        if (!_matched && o instanceof ParameterizedTypeRef) {
            _matched = true;
            _switchResult = ((ParameterizedTypeRef)o).getDeclaredType();
        }
        if (!_matched) {
            _switchResult = o;
        }
        IdentifiableElement result = _switchResult;
        return result;
    }

    protected String getLabel(EObject o) {
        String _xblockexpression = null;
        String label = this.signatureProvider.get(o);
        _xblockexpression = UtilN4.sanitizeForHTML((String)label);
        return _xblockexpression;
    }

    protected String getDocumentation(EObject o) {
        String jsdocString;
        block12: {
            try {
                EObject id = this.getIdentifiableElement(o);
                jsdocString = super.getDocumentation(id);
                boolean _matched = false;
                if (id instanceof TObjectPrototype) {
                    _matched = true;
                    boolean _isDeclaredProvidedByRuntime = ((TObjectPrototype)id).isDeclaredProvidedByRuntime();
                    if (_isDeclaredProvidedByRuntime) {
                        jsdocString = this.addMDNLink(((TObjectPrototype)id).getName(), jsdocString);
                    }
                }
                if (!_matched && id instanceof TField) {
                    _matched = true;
                    Type type = ((TField)id).getTypeRef().getDeclaredType();
                    if (type instanceof TObjectPrototype) {
                        jsdocString = this.addMDNLink(((TObjectPrototype)type).getName(), jsdocString);
                    }
                }
                if (!_matched && id instanceof N4FieldDeclaration) {
                    _matched = true;
                    Type type = ((N4FieldDeclaration)id).getDeclaredTypeRef().getDeclaredType();
                    if (type instanceof TObjectPrototype) {
                        jsdocString = this.addMDNLink(((TObjectPrototype)type).getName(), jsdocString);
                    }
                }
                if (!_matched && id instanceof TMethod) {
                    _matched = true;
                    EObject type = ((TMethod)id).eContainer();
                    if (type instanceof TObjectPrototype) {
                        String _name = ((TObjectPrototype)type).getName();
                        String _plus = String.valueOf(_name) + "/";
                        String _name_1 = ((TMethod)id).getName();
                        String _plus_1 = String.valueOf(_plus) + _name_1;
                        jsdocString = this.addMDNLink(_plus_1, jsdocString);
                    }
                }
                if (jsdocString != null) break block12;
                return null;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    return "Error generating documentation:  " + ex;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        Doclet doclet = this.docletParser.parse(jsdocString);
        String hoverHTML = JSDoc2HoverSerializer.toJSDocString((EObject)doclet);
        return hoverHTML;
    }

    private String addMDNLink(String name, String jsdocString) {
        String mdnString = MDN_STRING_START + name + MDN_STRING_END;
        if (jsdocString == null) {
            return mdnString;
        }
        return String.valueOf(jsdocString) + "\n\n" + mdnString;
    }

    protected boolean hasHover(EObject o) {
        return this.doHasHover(o);
    }

    private boolean _doHasHover(EObject o) {
        EObject tElem = N4JSASTUtils.getCorrespondingTypeModelElement((EObject)o);
        boolean _xifexpression = false;
        _xifexpression = tElem == null ? super.hasHover(o) : this.typesHoverProvider.hasHover(tElem);
        return _xifexpression;
    }

    private boolean _doHasHover(ParameterizedPropertyAccessExpression ppae) {
        return true;
    }

    private boolean _doHasHover(IdentifierRef identifierRef) {
        return true;
    }

    private boolean _doHasHover(VariableDeclaration vd) {
        return true;
    }

    private boolean _doHasHover(PropertyNameValuePair nameValuePair) {
        return true;
    }

    private boolean _doHasHover(FormalParameter fp) {
        return true;
    }

    private boolean _doHasHover(FunctionExpression fe) {
        return true;
    }

    private boolean _doHasHover(N4TypeDeclaration md) {
        return true;
    }

    private boolean _doHasHover(LiteralOrComputedPropertyName name) {
        EObject _eContainer = name.eContainer();
        return _eContainer instanceof N4MemberDeclaration;
    }

    private boolean _doHasHover(ParameterizedTypeRef ptr) {
        return true;
    }

    protected XtextBrowserInformationControlInput getHoverInfo(EObject element, IRegion hoverRegion, XtextBrowserInformationControlInput previous) {
        Object _xtrycatchfinallyexpression = null;
        try {
            return super.getHoverInfo(element, hoverRegion, previous);
        }
        catch (Throwable _t) {
            Object _xifexpression;
            if (_t instanceof Throwable) {
                boolean _not;
                Throwable t = _t;
                _xifexpression = null;
                boolean _isOperationCanceledException = this.cancelManager.isOperationCanceledException(t);
                boolean bl = _not = !_isOperationCanceledException;
                if (_not) {
                    throw Exceptions.sneakyThrow((Throwable)t);
                }
            } else {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xtrycatchfinallyexpression = _xifexpression;
            return _xtrycatchfinallyexpression;
        }
    }

    private URL getImageURL(EObject obj) {
        block9: {
            String fn = this.h.getImageFileName(obj);
            if (fn != null) {
                IPath path;
                URL url;
                Path folder;
                Bundle bundle;
                block8: {
                    IPath pathHighRes;
                    int lastDotIndex = fn.lastIndexOf(".");
                    String name = fn.substring(0, lastDotIndex);
                    String extn = fn.substring(lastDotIndex);
                    String fnHighRes = String.valueOf(name) + "@2x" + extn;
                    bundle = N4JSActivator.getInstance().getBundle();
                    URL urlHighRes = FileLocator.find((Bundle)bundle, (IPath)(pathHighRes = (folder = new Path("icons/")).append(fnHighRes)), null);
                    if (urlHighRes != null) {
                        try {
                            URL file = FileLocator.toFileURL((URL)urlHighRes);
                            boolean _exists = Files.exists(Paths.get(file.toURI()), new LinkOption[0]);
                            if (_exists) {
                                return file;
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Exception) break block8;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                }
                if ((url = FileLocator.find((Bundle)bundle, (IPath)(path = folder.append(fn)), null)) != null) {
                    try {
                        return FileLocator.toFileURL((URL)url);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IOException) break block9;
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
        }
        return null;
    }

    private boolean doHasHover(EObject nameValuePair) {
        if (nameValuePair instanceof PropertyNameValuePair) {
            return this._doHasHover((PropertyNameValuePair)nameValuePair);
        }
        if (nameValuePair instanceof ParameterizedTypeRef) {
            return this._doHasHover((ParameterizedTypeRef)nameValuePair);
        }
        if (nameValuePair instanceof FormalParameter) {
            return this._doHasHover((FormalParameter)nameValuePair);
        }
        if (nameValuePair instanceof FunctionExpression) {
            return this._doHasHover((FunctionExpression)nameValuePair);
        }
        if (nameValuePair instanceof IdentifierRef) {
            return this._doHasHover((IdentifierRef)nameValuePair);
        }
        if (nameValuePair instanceof N4TypeDeclaration) {
            return this._doHasHover((N4TypeDeclaration)nameValuePair);
        }
        if (nameValuePair instanceof ParameterizedPropertyAccessExpression) {
            return this._doHasHover((ParameterizedPropertyAccessExpression)nameValuePair);
        }
        if (nameValuePair instanceof VariableDeclaration) {
            return this._doHasHover((VariableDeclaration)nameValuePair);
        }
        if (nameValuePair instanceof LiteralOrComputedPropertyName) {
            return this._doHasHover((LiteralOrComputedPropertyName)nameValuePair);
        }
        if (nameValuePair != null) {
            return this._doHasHover(nameValuePair);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(nameValuePair).toString());
    }
}

