/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.compiler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.n4js.cli.N4jscConsole;
import org.eclipse.n4js.cli.compiler.N4jscIssueSerializer;
import org.eclipse.n4js.ide.client.AbstractN4JSLanguageClient;

@Singleton
public class N4jscLanguageClient
extends AbstractN4JSLanguageClient {
    private long trnspCount = 0L;
    private long delCount = 0L;
    private long errCount = 0L;
    private long wrnCount = 0L;
    @Inject
    protected N4jscIssueSerializer issueSerializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        List issueList = diagnostics.getDiagnostics();
        if (issueList.isEmpty()) {
            return;
        }
        N4jscLanguageClient n4jscLanguageClient = this;
        synchronized (n4jscLanguageClient) {
            N4jscConsole.println(this.issueSerializer.uri(diagnostics.getUri()));
            for (Diagnostic diag : issueList) {
                N4jscConsole.println(this.issueSerializer.diagnostics(diag));
                switch (diag.getSeverity()) {
                    case Error: {
                        ++this.errCount;
                        break;
                    }
                    case Warning: {
                        ++this.wrnCount;
                        break;
                    }
                }
            }
        }
    }

    public void showMessage(MessageParams messageParams) {
        N4jscConsole.println(messageParams.getMessage());
    }

    public void logMessage(MessageParams message) {
        N4jscConsole.println(message.getMessage());
    }

    public void afterDelete(URI file) {
        ++this.delCount;
    }

    public void afterGenerate(URI source, URI generated) {
        ++this.trnspCount;
    }

    public long getWarningsCount() {
        return this.wrnCount;
    }

    public long getErrorsCount() {
        return this.errCount;
    }

    public long getDeletionsCount() {
        return this.delCount;
    }

    public long getTranspilationsCount() {
        return this.trnspCount;
    }

    public void resetCounters() {
        this.trnspCount = 0L;
        this.delCount = 0L;
        this.errCount = 0L;
        this.wrnCount = 0L;
    }
}

