/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.validation;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.internal.RaceDetectionHelper;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.validation.N4JSResourceValidator;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;

public class SourceContainerAwareResourceValidator
extends N4JSResourceValidator {
    private final IN4JSEclipseCore eclipseCore;
    private final OperationCanceledManager operationCanceledManager;

    @Inject
    private SourceContainerAwareResourceValidator(IN4JSEclipseCore eclipseCore, OperationCanceledManager operationCanceledManager) {
        this.eclipseCore = eclipseCore;
        this.operationCanceledManager = operationCanceledManager;
    }

    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator cancelIndicator) {
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        if (!this.isInSourceFolder(resource)) {
            return Collections.emptyList();
        }
        RaceDetectionHelper.log((String)"Validating: %s", (Object)resource.getURI());
        List res = super.validate(resource, mode, cancelIndicator);
        return res;
    }

    private boolean isInSourceFolder(Resource resource) {
        URI uri = resource.getURI();
        Optional sourceContainerOpt = this.eclipseCore.findN4JSSourceContainer(uri);
        if (sourceContainerOpt.isPresent()) {
            IN4JSSourceContainer sourceContainer = (IN4JSSourceContainer)sourceContainerOpt.get();
            return !sourceContainer.isExternal();
        }
        return false;
    }
}

