/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JType;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJAbstractType;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJImport;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJNode;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJPackage;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTJCompilationUnit
extends ASTJNode<CompilationUnit>
implements JCompilationUnit {
    public static final String NAME_PROPERTY = "ASTJCompilationUnit.name";
    protected static final Pattern HEADER_PATTERN = Pattern.compile("^(?:(?:/\\*(?:.|[\\n\\r])*?\\*/)|(?://.*(?:[\\n\\r])+)|(?:\\s+))+");
    private Map<ASTNode, String> allTrackedContentsMap = new HashMap<ASTNode, String>();
    private Set<ASTNode> commentedOutNodes = null;
    protected String headerString = null;
    protected char[] originalContents;

    public ASTJCompilationUnit(CompilationUnit compilationUnit) {
        super(compilationUnit);
    }

    @Override
    public void dispose() {
        this.allTrackedContentsMap.clear();
        this.headerString = null;
        this.originalContents = null;
        if (this.commentedOutNodes != null) {
            this.commentedOutNodes.clear();
            this.commentedOutNodes = null;
        }
        super.dispose();
    }

    public void setOriginalContents(char[] originalContents) {
        this.originalContents = originalContents;
    }

    public char[] getOriginalContents() {
        return this.originalContents;
    }

    @Override
    public String getName() {
        JType type = this.getFacadeHelper().getMainType(this);
        return type != null ? String.valueOf(type.getName()) + ".java" : (String)this.getWrappedObject().getProperty(NAME_PROPERTY);
    }

    @Override
    public void setName(String name) {
        JType type = this.getFacadeHelper().getMainType(this);
        if (type != null) {
            type.setName(name);
        } else {
            ((CompilationUnit)this.getASTNode()).setProperty(NAME_PROPERTY, (Object)name);
        }
    }

    @Override
    protected String computeQualifiedName() {
        return this.getName();
    }

    @Override
    public List<JNode> getChildren() {
        if (!this.isDisposed()) {
            JNode child;
            CompilationUnit astCompilationUnit = (CompilationUnit)this.getASTNode();
            ArrayList<JNode> children = new ArrayList<JNode>();
            PackageDeclaration astPackage = astCompilationUnit.getPackage();
            if (astPackage != null && (child = this.getFacadeHelper().convertToNode(astPackage)) != null) {
                children.add(child);
            }
            ListRewrite importsListRewrite = this.rewriter.getListRewrite((ASTNode)astCompilationUnit, CompilationUnit.IMPORTS_PROPERTY);
            for (Object importDeclaration : importsListRewrite.getRewrittenList()) {
                JNode child2 = this.getFacadeHelper().convertToNode(importDeclaration);
                if (child2 == null) continue;
                children.add(child2);
            }
            ListRewrite typesListRewrite = this.rewriter.getListRewrite((ASTNode)astCompilationUnit, CompilationUnit.TYPES_PROPERTY);
            for (Object type : typesListRewrite.getRewrittenList()) {
                JNode child3 = this.getFacadeHelper().convertToNode(type);
                if (child3 == null) continue;
                children.add(child3);
            }
            if (!children.isEmpty()) {
                return Collections.unmodifiableList(children);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String getHeader() {
        if (this.headerString == null) {
            Matcher matcher = HEADER_PATTERN.matcher(new String(this.originalContents));
            if (matcher.find()) {
                String headerString = matcher.group();
                return headerString;
            }
            return "";
        }
        return this.headerString;
    }

    @Override
    public void setHeader(String header) {
        if (header != null) {
            this.headerString = header;
        }
    }

    protected void setHeader(IDocument targetDoc) {
        String targetDocString = targetDoc.get();
        Matcher matcher = HEADER_PATTERN.matcher(targetDocString);
        targetDocString = matcher.find() ? this.headerString.concat(targetDocString.substring(matcher.end())) : this.headerString.concat(targetDocString);
        targetDoc.set(targetDocString);
    }

    @Override
    public String getContents() {
        String contents;
        Document targetDoc;
        TextEdit edits;
        NodeContentsReplacer contentsReplacer = null;
        if (this.allTrackedContentsMap != null && !this.allTrackedContentsMap.isEmpty()) {
            contentsReplacer = new NodeContentsReplacer();
        }
        NodeCommenter commenter = null;
        if (this.commentedOutNodes != null && !this.commentedOutNodes.isEmpty()) {
            commenter = new NodeCommenter();
        }
        if ((edits = this.rewriter.rewriteAST((IDocument)(targetDoc = new Document(contents = new String(this.originalContents))), this.getFacadeHelper().getJavaCoreOptions())).getChildrenSize() != 0 || edits.getLength() != 0 || commenter != null || contentsReplacer != null || this.headerString != null) {
            try {
                edits.apply((IDocument)targetDoc);
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            try {
                TextEdit additionalEdits = null;
                if (contentsReplacer != null) {
                    additionalEdits = contentsReplacer.createEdits(additionalEdits, (IDocument)targetDoc);
                }
                if (commenter != null) {
                    additionalEdits = commenter.createEdits(additionalEdits, (IDocument)targetDoc);
                }
                if (additionalEdits != null) {
                    additionalEdits.apply((IDocument)targetDoc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.headerString != null) {
                this.setHeader((IDocument)targetDoc);
            }
            contents = targetDoc.get();
        }
        return contents;
    }

    @Override
    public boolean addChild(ASTJNode<?> child) {
        if (child.getParent() != null) {
            return false;
        }
        if (child instanceof ASTJImport) {
            this.insertLast(child, CompilationUnit.IMPORTS_PROPERTY);
        } else if (child instanceof ASTJAbstractType) {
            this.insertLast(child, CompilationUnit.TYPES_PROPERTY);
        } else if (child instanceof ASTJPackage) {
            this.setNodeProperty((ASTNode)this.getASTNode(), child.getASTNode(), (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY);
        } else {
            return false;
        }
        child.setParent(this);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean insertSibling(ASTJNode<?> node, ASTJNode<?> newSibling, boolean before) {
        if (newSibling.getParent() != null) {
            return false;
        }
        if (newSibling instanceof ASTJImport) {
            if (node instanceof ASTJImport) {
                this.insert(newSibling, CompilationUnit.IMPORTS_PROPERTY, node, before);
            } else if (node instanceof ASTJPackage) {
                this.insertFirst(newSibling, CompilationUnit.IMPORTS_PROPERTY);
            } else {
                if (!(node instanceof ASTJAbstractType)) return false;
                this.insertLast(newSibling, CompilationUnit.IMPORTS_PROPERTY);
            }
        } else if (newSibling instanceof ASTJAbstractType) {
            if (node instanceof ASTJAbstractType) {
                this.insert(newSibling, CompilationUnit.TYPES_PROPERTY, node, before);
            } else if (node instanceof ASTJImport) {
                this.insertFirst(newSibling, CompilationUnit.TYPES_PROPERTY);
            } else {
                if (!(node instanceof ASTJPackage)) return false;
                this.insertFirst(newSibling, CompilationUnit.TYPES_PROPERTY);
            }
        } else {
            if (!(newSibling instanceof ASTJPackage)) return false;
            this.setNodeProperty((ASTNode)this.getASTNode(), newSibling.getASTNode(), (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY);
        }
        newSibling.setParent(this);
        return true;
    }

    @Override
    public boolean remove(ASTJNode<?> node) {
        if (node.getParent() != this) {
            return false;
        }
        if (node instanceof ASTJImport) {
            this.remove(node, CompilationUnit.IMPORTS_PROPERTY);
        } else if (node instanceof ASTJAbstractType) {
            this.remove(node, CompilationUnit.TYPES_PROPERTY);
        } else if (node instanceof ASTJPackage) {
            this.setNodeProperty((ASTNode)this.getASTNode(), null, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY);
        } else {
            return false;
        }
        node.setParent(null);
        return true;
    }

    protected Map<ASTNode, String> getAllTrackedContentsMap() {
        return this.allTrackedContentsMap;
    }

    protected Set<ASTNode> getCommentedOutNodes() {
        if (this.commentedOutNodes == null) {
            this.commentedOutNodes = new HashSet<ASTNode>();
        }
        return this.commentedOutNodes;
    }

    protected abstract class AbstractRewriter {
        protected AbstractRewriter() {
        }

        public TextEdit createEdits(TextEdit existingEdits, IDocument doc) {
            if (existingEdits == null) {
                existingEdits = new MultiTextEdit();
            }
            return this.addEdits(existingEdits, doc);
        }

        protected abstract TextEdit addEdits(TextEdit var1, IDocument var2);
    }

    protected class NodeCommenter
    extends AbstractRewriter {
        protected static final String LINE_COMMENT_STRING = "//";
        protected static final String EMPTY_STRING = "";
        protected Map<ASTNode, ITrackedNodePosition> commentedOutPositions = new HashMap<ASTNode, ITrackedNodePosition>();
        protected LineBreakInserter lineBreakInserter;
        protected Map<Integer, InsertEdit> addedInsertEdits = new HashMap<Integer, InsertEdit>();
        protected List<TextEdit> textEditsToRevert = new ArrayList<TextEdit>();
        protected IDocument doc;

        public NodeCommenter() {
            for (ASTNode node : ASTJCompilationUnit.this.getCommentedOutNodes()) {
                try {
                    this.commentedOutPositions.put(node, ASTJCompilationUnit.this.rewriter.track(node));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        protected TextEdit addEdits(TextEdit existingEdits, IDocument doc) {
            this.doc = doc;
            this.lineBreakInserter = new LineBreakInserter();
            for (Map.Entry<ASTNode, ITrackedNodePosition> entry : this.commentedOutPositions.entrySet()) {
                node = entry.getKey();
                nodePosition = entry.getValue();
                try {
                    firstLine = this.addLineBreakBeforeNode(existingEdits, nodePosition, node);
                    lastLine = doc.getLineOfOffset(nodePosition.getStartPosition() + nodePosition.getLength());
                    this.commentOutLines(existingEdits, firstLine, lastLine);
                    if (firstLine == lastLine && ASTJCompilationUnit.this.getAllTrackedContentsMap().containsKey(node)) {
                        this.findAndCommentOutReplaceEdit(existingEdits, nodePosition);
                    }
                    this.addLineBreakAfterNode(existingEdits, nodePosition, node);
                    this.textEditsToRevert.clear();
                    continue;
                }
                catch (Exception e) {
                    ** for (edit : this.textEditsToRevert)
                }
lbl-1000:
                // 1 sources

                {
                    existingEdits.removeChild(edit);
                    continue;
                }
lbl20:
                // 1 sources

                this.textEditsToRevert.clear();
            }
            return existingEdits;
        }

        protected int addLineBreakBeforeNode(TextEdit existingEdits, ITrackedNodePosition nodePosition, ASTNode node) throws BadLocationException {
            InsertEdit lineBreakEdit = this.lineBreakInserter.createLineBreakBeforeNode(nodePosition, node);
            if (lineBreakEdit != null) {
                InsertEdit existingEdit = this.addedInsertEdits.get(lineBreakEdit.getOffset());
                if (existingEdit != null) {
                    existingEdits.removeChild((TextEdit)existingEdit);
                    this.addedInsertEdits.values().remove(existingEdit);
                }
                existingEdits.addChild((TextEdit)lineBreakEdit);
                this.textEditsToRevert.add((TextEdit)lineBreakEdit);
                this.addedInsertEdits.put(lineBreakEdit.getOffset(), lineBreakEdit);
                return this.doc.getLineOfOffset(lineBreakEdit.getOffset()) + 1;
            }
            return this.doc.getLineOfOffset(nodePosition.getStartPosition());
        }

        protected void commentOutLines(TextEdit existingEdits, int firstLine, int lastLine) throws BadLocationException {
            int i = firstLine;
            while (i <= lastLine) {
                InsertEdit edit = new InsertEdit(this.doc.getLineOffset(i), LINE_COMMENT_STRING);
                try {
                    existingEdits.addChild((TextEdit)edit);
                    this.textEditsToRevert.add((TextEdit)edit);
                    this.addedInsertEdits.put(edit.getOffset(), edit);
                }
                catch (MalformedTreeException e) {
                    TextEdit causeEdit = e.getChild();
                    if (causeEdit instanceof ReplaceEdit) {
                        ReplaceEdit newReplaceEdit = this.commentOutReplaceEdit((ReplaceEdit)causeEdit);
                        i = this.doc.getLineOfOffset(newReplaceEdit.getOffset() + newReplaceEdit.getLength());
                    }
                    throw e;
                }
                ++i;
            }
        }

        protected ReplaceEdit commentOutReplaceEdit(ReplaceEdit replaceEdit) {
            TextEdit parent = replaceEdit.getParent();
            String newText = this.commentOutEachLine(replaceEdit.getText());
            ReplaceEdit newEdit = new ReplaceEdit(replaceEdit.getOffset(), replaceEdit.getLength(), newText);
            parent.removeChild((TextEdit)replaceEdit);
            parent.addChild((TextEdit)newEdit);
            return newEdit;
        }

        protected void findAndCommentOutReplaceEdit(TextEdit existingEdits, ITrackedNodePosition nodePosition) {
            ReplaceEdit dummyEdit = new ReplaceEdit(nodePosition.getStartPosition() + 1, 0, EMPTY_STRING);
            try {
                try {
                    existingEdits.addChild((TextEdit)dummyEdit);
                }
                catch (MalformedTreeException e) {
                    TextEdit causeEdit = e.getChild();
                    if (causeEdit instanceof ReplaceEdit) {
                        this.commentOutReplaceEdit((ReplaceEdit)causeEdit);
                    }
                    try {
                        existingEdits.removeChild((TextEdit)dummyEdit);
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    existingEdits.removeChild((TextEdit)dummyEdit);
                }
                catch (Exception exception) {}
            }
        }

        protected String commentOutEachLine(String text) {
            StringBuilder sb = new StringBuilder(text.length() + text.length() / 10);
            char[] textContent = text.toCharArray();
            int lastPos = 0;
            int currentPos = 0;
            int i = 0;
            while (i < textContent.length) {
                if (textContent[i] == '\n') {
                    currentPos = i;
                } else if (textContent[i] == '\r') {
                    currentPos = i + 1 < textContent.length && textContent[i + 1] == '\n' ? ++i : i;
                }
                if (lastPos != currentPos) {
                    sb.append(textContent, lastPos, currentPos - lastPos + 1);
                    sb.append(LINE_COMMENT_STRING);
                    lastPos = ++currentPos;
                }
                ++i;
            }
            if (currentPos < textContent.length) {
                sb.append(textContent, currentPos, textContent.length - currentPos);
            }
            return sb.toString();
        }

        protected void addLineBreakAfterNode(TextEdit existingEdits, ITrackedNodePosition nodePosition, ASTNode node) throws BadLocationException {
            InsertEdit existingEdit;
            InsertEdit lineBreakEdit = this.lineBreakInserter.createLineBreakAfterNode(nodePosition, node);
            if (lineBreakEdit != null && (existingEdit = this.addedInsertEdits.get(lineBreakEdit.getOffset())) == null) {
                existingEdits.addChild((TextEdit)lineBreakEdit);
                this.textEditsToRevert.add((TextEdit)lineBreakEdit);
                this.addedInsertEdits.put(lineBreakEdit.getOffset(), lineBreakEdit);
            }
        }

        protected class LineBreakInserter {
            protected char[] charContent = this.getDocument().get().toCharArray();

            protected LineBreakInserter() {
            }

            protected IDocument getDocument() {
                return NodeCommenter.this.doc;
            }

            protected InsertEdit createLineBreakBeforeNode(ITrackedNodePosition nodePosition, ASTNode node) throws BadLocationException {
                InsertEdit insertEdit;
                int startPos = nodePosition.getStartPosition();
                IRegion lineInfo = this.getDocument().getLineInformationOfOffset(startPos);
                if (node.getNodeType() == 72 && (insertEdit = this.commentOutEnumConstantSeparator((EnumConstantDeclaration)node, lineInfo, nodePosition)) != null) {
                    return insertEdit;
                }
                if (!this.isWhitespace(lineInfo.getOffset(), startPos)) {
                    return new InsertEdit(startPos, this.createLineBreakString(lineInfo.getOffset(), true));
                }
                return null;
            }

            protected InsertEdit createLineBreakAfterNode(ITrackedNodePosition nodePosition, ASTNode node) throws BadLocationException {
                int endPos = nodePosition.getStartPosition() + nodePosition.getLength();
                IRegion lineInfo = this.getDocument().getLineInformationOfOffset(endPos);
                if (node.getNodeType() == 72) {
                    return this.createLineBreakAfterEnumConstant(node, lineInfo, nodePosition);
                }
                if (!this.isWhitespace(endPos, lineInfo.getOffset() + lineInfo.getLength())) {
                    return new InsertEdit(endPos, this.createLineBreakString(lineInfo.getOffset(), false));
                }
                return null;
            }

            protected String getIndent(int lineStart) {
                if (lineStart >= 0 && lineStart < this.charContent.length) {
                    int i = lineStart;
                    while (i < this.charContent.length && IndentManipulation.isIndentChar((char)this.charContent[i])) {
                        ++i;
                    }
                    return new String(this.charContent, lineStart, i - lineStart);
                }
                return NodeCommenter.EMPTY_STRING;
            }

            protected boolean isWhitespace(int start, int end) {
                if (start >= 0 && end < this.charContent.length && start <= end) {
                    int i = start;
                    while (i < end) {
                        if (!Character.isWhitespace(this.charContent[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }

            protected String createLineBreakString(int startOfLineOffset, boolean isCommentedOut) throws BadLocationException {
                return this.createLineBreakString(this.getDocument().getLineDelimiter(this.getDocument().getLineOfOffset(startOfLineOffset)), startOfLineOffset, isCommentedOut);
            }

            protected String createLineBreakString(String lineDelimiter, int startOfLineOffset, boolean isCommentedOut) {
                String indent = this.getIndent(startOfLineOffset);
                StringBuilder sb = new StringBuilder(indent.length() + 10);
                sb.append(lineDelimiter);
                if (isCommentedOut) {
                    sb.append(NodeCommenter.LINE_COMMENT_STRING);
                }
                sb.append(indent);
                return sb.toString();
            }

            private InsertEdit commentOutEnumConstantSeparator(EnumConstantDeclaration enumConstant, IRegion lineInfo, ITrackedNodePosition nodePosition) throws BadLocationException {
                Object parent;
                List enumConstants;
                int constantIndex;
                ASTJNode astjNode = (ASTJNode)ASTJCompilationUnit.this.getFacadeHelper().convertToNode(enumConstant);
                if (astjNode != null && (constantIndex = (enumConstants = ((NodeCommenter)NodeCommenter.this).ASTJCompilationUnit.this.rewriter.getListRewrite(parent = ((ASTJNode)astjNode.getParent()).getASTNode(), EnumDeclaration.ENUM_CONSTANTS_PROPERTY).getRewrittenList()).indexOf(enumConstant)) > 0 && constantIndex < enumConstants.size()) {
                    ASTNode previousNode = (ASTNode)enumConstants.get(constantIndex - 1);
                    List followingConstants = enumConstants.subList(constantIndex, enumConstants.size());
                    if (!NodeCommenter.this.commentedOutPositions.containsKey(previousNode) && NodeCommenter.this.commentedOutPositions.keySet().containsAll(followingConstants)) {
                        int commaPosition = nodePosition.getStartPosition() - 1;
                        while (commaPosition >= 0 && Character.isWhitespace(this.charContent[commaPosition])) {
                            --commaPosition;
                        }
                        if (commaPosition >= 0 && this.charContent[commaPosition] == ',') {
                            int line = this.getDocument().getLineOfOffset(commaPosition);
                            int startOfLineOffset = this.getDocument().getLineOffset(line);
                            if (this.isWhitespace(startOfLineOffset, commaPosition)) {
                                return new InsertEdit(startOfLineOffset, NodeCommenter.LINE_COMMENT_STRING);
                            }
                            return new InsertEdit(commaPosition, this.createLineBreakString(this.getDocument().getLineDelimiter(line), startOfLineOffset, true));
                        }
                    }
                }
                return null;
            }

            private InsertEdit createLineBreakAfterEnumConstant(ASTNode node, IRegion lineInfo, ITrackedNodePosition nodePosition) throws BadLocationException {
                int nodeEndPos = nodePosition.getStartPosition() + nodePosition.getLength();
                int endOfLine = lineInfo.getOffset() + lineInfo.getLength();
                int i = nodeEndPos;
                while (i <= endOfLine && Character.isWhitespace(this.charContent[i])) {
                    ++i;
                }
                if (i < endOfLine) {
                    if (this.charContent[i] == ',') {
                        if (!this.isWhitespace(i + 1, endOfLine)) {
                            return new InsertEdit(i + 1, this.createLineBreakString(lineInfo.getOffset(), false));
                        }
                    } else {
                        return new InsertEdit(i, this.createLineBreakString(lineInfo.getOffset(), false));
                    }
                }
                return null;
            }
        }
    }

    protected class NodeContentsReplacer
    extends AbstractRewriter {
        protected Map<ITrackedNodePosition, String> trackedNodePositionsMap;

        public NodeContentsReplacer() {
            Map<ASTNode, String> allTrackedContentsMap = ASTJCompilationUnit.this.getAllTrackedContentsMap();
            this.trackedNodePositionsMap = new HashMap<ITrackedNodePosition, String>(Math.max((int)((float)allTrackedContentsMap.keySet().size() / 0.75f) + 1, 16));
            for (ASTNode node : allTrackedContentsMap.keySet()) {
                try {
                    ITrackedNodePosition trackedNodePosition = ASTJCompilationUnit.this.rewriter.track(node);
                    this.trackedNodePositionsMap.put(trackedNodePosition, allTrackedContentsMap.get(node));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected TextEdit addEdits(TextEdit existingEdits, IDocument doc) {
            for (Map.Entry<ITrackedNodePosition, String> entry : this.trackedNodePositionsMap.entrySet()) {
                ITrackedNodePosition position = entry.getKey();
                String contents = entry.getValue();
                try {
                    ReplaceEdit replaceEdit = new ReplaceEdit(position.getStartPosition(), position.getLength(), contents);
                    existingEdits.addChild((TextEdit)replaceEdit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return existingEdits;
        }
    }
}

