/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.smith.ui.graph.ColorUtils;
import org.eclipse.n4js.smith.ui.graph.VisualisationNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class StackNode
extends VisualisationNode {
    protected String title;
    protected String description;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    private final float parentScale;
    private final float siblingScale;
    protected StackNode parent;
    protected final List<StackNode> children = new ArrayList<StackNode>();

    public StackNode(String title, String description, float width, float height, float parentScale, float siblingScale) {
        this.title = title;
        this.description = description;
        this.width = width;
        this.height = height;
        this.parentScale = parentScale;
        this.siblingScale = siblingScale;
    }

    public void setParent(StackNode parent) {
        this.parent = parent;
    }

    public void addChild(StackNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    int getDepth() {
        int d = 0;
        StackNode node = this;
        while (node.parent != null) {
            ++d;
            node = node.parent;
        }
        return d;
    }

    int getOffset() {
        if (this.parent == null) {
            return 0;
        }
        StackNode node = this.parent;
        List<Object> layer = node == null ? Collections.emptyList() : node.children;
        int d = layer.indexOf(this);
        if (d < 0) {
            throw new RuntimeException("Cannot locate node in the graph.");
        }
        return d;
    }

    @Override
    public void paint(GC gc) {
        gc.setBackground(StackNode.getColor(this.parentScale, this.siblingScale));
        gc.setForeground(gc.getDevice().getSystemColor(2));
        gc.fillRectangle(Math.round(this.x), Math.round(this.y), Math.round(this.width), Math.round(this.height));
        gc.setBackground(Display.getDefault().getSystemColor(1));
    }

    private static Color getColor(float depthInStack, float depthInLayer) {
        float factor = 1.0f - depthInStack;
        RGB depthColor = new RGB(255, ColorUtils.clamp(255.0f * factor), 0);
        return ColorUtils.darken(depthColor, depthInLayer);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<VisualisationNode> getChildren() {
        return new LinkedList<VisualisationNode>(this.children);
    }

    @Override
    public void sortChildren(Comparator<VisualisationNode> cmp) {
        this.children.sort(cmp);
        this.children.forEach(c -> c.sortChildren(cmp));
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

