/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.outline;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;

public class JSONOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    public void createChildren(IOutlineNode parent, EObject modelElement) {
        if (modelElement instanceof JSONDocument) {
            JSONValue content = ((JSONDocument)modelElement).getContent();
            if (content.isContainer()) {
                EList children = content.getChildren();
                for (EObject child : children) {
                    this.createNode(parent, child);
                }
                return;
            }
            if (content != null) {
                this.createNode(parent, (EObject)content);
            }
            return;
        }
        if (modelElement instanceof NameValuePair) {
            NameValuePair pair = (NameValuePair)modelElement;
            JSONValue pairValue = pair.getValue();
            if (!pairValue.isContainer()) {
                return;
            }
            for (EObject child : pairValue.getChildren()) {
                this.createNode(parent, child);
            }
            return;
        }
        super.createChildren(parent, modelElement);
    }

    protected void createNode(IOutlineNode parent, EObject modelElement) {
        if (modelElement instanceof NameValuePair && !((NameValuePair)modelElement).getValue().isContainer()) {
            this.createEObjectNode(parent, modelElement, (Image)this.imageDispatcher.invoke(new Object[]{modelElement}), this.textDispatcher.invoke(new Object[]{modelElement}), true);
            return;
        }
        super.createNode(parent, modelElement);
    }
}

