/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import org.eclipse.n4js.fileextensions.FileExtensionType;
import org.eclipse.n4js.fileextensions.FileExtensionsRegistry;
import org.eclipse.n4js.generator.ISubGenerator;
import org.eclipse.n4js.generator.SubGeneratorRegistry;
import org.eclipse.n4js.json.extension.IJSONResourceDescriptionExtension;
import org.eclipse.n4js.json.extension.JSONExtensionRegistry;
import org.eclipse.n4js.json.validation.extension.IJSONValidatorExtension;
import org.eclipse.n4js.resource.packagejson.PackageJsonResourceDescriptionExtension;
import org.eclipse.n4js.tester.extension.TesterRegistry;
import org.eclipse.n4js.transpiler.es.EcmaScriptSubGenerator;
import org.eclipse.n4js.transpiler.es.n4idl.N4IDLSubGenerator;
import org.eclipse.n4js.validation.validators.packagejson.N4JSProjectSetupJsonValidatorExtension;
import org.eclipse.n4js.validation.validators.packagejson.PackageJsonValidatorExtension;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class HeadlessExtensionRegistrationHelper {
    @Inject
    private FileExtensionsRegistry n4jsFileExtensionsRegistry;
    @Inject
    private SubGeneratorRegistry subGeneratorRegistry;
    @Inject
    private EcmaScriptSubGenerator ecmaScriptSubGenerator;
    @Inject
    private N4IDLSubGenerator n4idlSubGenerator;
    @Inject
    private TesterRegistry testerRegistry;
    @Inject
    private PackageJsonValidatorExtension packageJsonValidatorExtension;
    @Inject
    private N4JSProjectSetupJsonValidatorExtension projectSetupValidatorExtension;
    @Inject
    private PackageJsonResourceDescriptionExtension packageJsonResourceDescriptionExtension;

    public void registerExtensions() {
        this.registerTestableFiles("n4js", "n4jsx");
        this.registerRunnableFiles("n4js", "js", "n4jsx", "jsx");
        this.registerTranspilableFiles("n4js", "n4jsx", "js", "jsx", "n4idl");
        this.registerTypableFiles("n4jsd", "n4js", "n4jsx", "js", "jsx", "n4idl");
        this.registerRawFiles("js", "jsx");
        this.subGeneratorRegistry.register((ISubGenerator)this.ecmaScriptSubGenerator, "n4js");
        this.subGeneratorRegistry.register((ISubGenerator)this.ecmaScriptSubGenerator, "js");
        this.subGeneratorRegistry.register((ISubGenerator)this.ecmaScriptSubGenerator, "n4jsx");
        this.subGeneratorRegistry.register((ISubGenerator)this.ecmaScriptSubGenerator, "jsx");
        this.subGeneratorRegistry.register((ISubGenerator)this.n4idlSubGenerator, "n4idl");
        this.registerJSONLanguageExtension();
    }

    public void unregisterExtensions() {
        this.testerRegistry.reset();
        this.n4jsFileExtensionsRegistry.reset();
        this.subGeneratorRegistry.reset();
    }

    private void registerTestableFiles(String ... extensions) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            this.n4jsFileExtensionsRegistry.register(extension, FileExtensionType.TESTABLE_FILE_EXTENSION);
            ++n2;
        }
    }

    private void registerRunnableFiles(String ... extensions) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            this.n4jsFileExtensionsRegistry.register(extension, FileExtensionType.RUNNABLE_FILE_EXTENSION);
            ++n2;
        }
    }

    private void registerTranspilableFiles(String ... extensions) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            this.n4jsFileExtensionsRegistry.register(extension, FileExtensionType.TRANSPILABLE_FILE_EXTENSION);
            ++n2;
        }
    }

    private void registerTypableFiles(String ... extensions) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            this.n4jsFileExtensionsRegistry.register(extension, FileExtensionType.TYPABLE_FILE_EXTENSION);
            ++n2;
        }
    }

    private void registerRawFiles(String ... extensions) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            this.n4jsFileExtensionsRegistry.register(extension, FileExtensionType.TESTABLE_FILE_EXTENSION);
            ++n2;
        }
    }

    private void registerJSONLanguageExtension() {
        IResourceServiceProvider jsonServiceProvider = (IResourceServiceProvider)IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().get("json");
        if (jsonServiceProvider == null) {
            throw new IllegalStateException("Could not obtain the IResourceServiceProvider for the JSON language.  Has the standlone setup of the JSON language been performed.");
        }
        JSONExtensionRegistry jsonExtensionRegistry = (JSONExtensionRegistry)jsonServiceProvider.get(JSONExtensionRegistry.class);
        jsonExtensionRegistry.register((IJSONValidatorExtension)this.packageJsonValidatorExtension);
        jsonExtensionRegistry.register((IJSONValidatorExtension)this.projectSetupValidatorExtension);
        jsonExtensionRegistry.register((IJSONResourceDescriptionExtension)this.packageJsonResourceDescriptionExtension);
    }
}

