/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.ReplaceRegion;

public class ChangeProvider {
    public static TextEdit insert(int line, int character, String text) {
        return ChangeProvider.replace(line, character, line, character, text);
    }

    public static TextEdit insert(Document doc, int offset, String text) {
        return ChangeProvider.replace(doc, offset, 0, text);
    }

    public static TextEdit replace(int startLine, int startChar, int endLine, int endChar, String replacementText) {
        Position posStart = new Position(startLine, startChar);
        Position posEnd = new Position(endLine, endChar);
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, replacementText);
    }

    public static TextEdit replace(Document doc, ReplaceRegion replaceRegion) {
        return ChangeProvider.replace(doc, replaceRegion.getOffset(), replaceRegion.getLength(), replaceRegion.getText());
    }

    public static TextEdit replace(Document doc, int offset, int length, String replacementText) {
        Position posStart = doc.getPosition(offset);
        Position posEnd = doc.getPosition(offset + length);
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, replacementText);
    }

    public static TextEdit insertLinesAbove(Document doc, int offset, boolean sameIndentation, String ... linesToInsert) {
        if (linesToInsert == null || linesToInsert.length == 0) {
            throw new IllegalArgumentException("must pass in at least one line to insert");
        }
        Position offsetPos = doc.getPosition(offset);
        String NL = ChangeProvider.lineDelimiter(doc, offset);
        String replacementText = Joiner.on((String)NL).join((Object[])linesToInsert);
        if (sameIndentation) {
            String lineContent = doc.getLineContent(offsetPos.getLine());
            int idx = 0;
            while (idx < lineContent.length() && Character.isWhitespace(lineContent.charAt(idx))) {
                ++idx;
            }
            String indent = lineContent.substring(0, idx);
            replacementText = String.valueOf(indent) + replacementText.replace(NL, String.valueOf(NL) + indent);
        }
        replacementText = String.valueOf(replacementText) + NL;
        Position posStart = new Position(offsetPos.getLine(), 0);
        Position posEnd = new Position(offsetPos.getLine(), 0);
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, replacementText);
    }

    public static String lineDelimiter(Document doc, int offset) {
        String sequence;
        String content = doc.getContents();
        int lineCount = doc.getLineCount();
        if (lineCount < 2) {
            return "\n";
        }
        Position offsetPos = doc.getPosition(offset);
        int line = offsetPos.getLine();
        if (line > 0) {
            int offsetOfLine = doc.getOffSet(new Position(line, 0));
            sequence = content.substring(Math.max(offsetOfLine - 2, 0), offsetOfLine);
            if (sequence.equals("\r\n")) {
                return "\r\n";
            }
            if (sequence.endsWith("\n")) {
                return "\n";
            }
        }
        if (line + 1 < lineCount) {
            int offsetOfFollowingLine = doc.getOffSet(new Position(line + 1, 0));
            sequence = content.substring(Math.max(offsetOfFollowingLine - 2, 0), offsetOfFollowingLine);
            if (sequence.equals("\r\n")) {
                return "\r\n";
            }
            if (sequence.endsWith("\n")) {
                return "\n";
            }
        }
        return "\n";
    }

    public static TextEdit removeSemanticObject(Document doc, EObject obj, boolean removeEntireLineIfEmpty) {
        if (obj == null) {
            return null;
        }
        return ChangeProvider.removeNode(doc, (INode)NodeModelUtils.findActualNodeFor((EObject)obj), removeEntireLineIfEmpty);
    }

    public static TextEdit removeNode(Document doc, INode node, boolean removeEntireLineIfEmpty) {
        if (node == null) {
            return null;
        }
        return ChangeProvider.removeText(doc, node.getOffset(), node.getLength(), removeEntireLineIfEmpty);
    }

    public static TextEdit removeText(Document doc, int offset, int length, boolean removeEntireLineIfEmpty) {
        Position posStart = doc.getPosition(offset);
        Position posEnd = doc.getPosition(offset + length);
        if (removeEntireLineIfEmpty) {
            int startLine = posStart.getLine();
            int endLine = posEnd.getLine();
            String startLineContent = doc.getLineContent(startLine);
            String endLineContent = startLine != endLine ? doc.getLineContent(endLine) : startLineContent;
            startLineContent = startLineContent.substring(0, posStart.getCharacter());
            endLineContent = endLineContent.substring(posEnd.getCharacter());
            String resultLineContent = String.valueOf(startLineContent) + endLineContent;
            if (resultLineContent.isBlank()) {
                posStart = new Position(posStart.getLine(), 0);
                posEnd = new Position(posEnd.getLine() + 1, 0);
            }
        }
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, "");
    }

    public static List<TextEdit> closeGapsIfEmpty(Document doc, List<? extends TextEdit> edits) {
        if (edits.isEmpty()) {
            return new ArrayList<TextEdit>();
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        int size = edits.size();
        int i = 0;
        while (i + 1 < size) {
            Position nextStart;
            TextEdit curr = edits.get(i);
            TextEdit next = edits.get(i + 1);
            Position currEnd = curr.getRange().getEnd();
            String gap = doc.getSubstring(new Range(currEnd, nextStart = next.getRange().getStart()));
            if (gap.isBlank()) {
                Position newEnd = new Position(nextStart.getLine(), nextStart.getCharacter());
                curr = new TextEdit(new Range(curr.getRange().getStart(), newEnd), curr.getNewText());
            }
            result.add(curr);
            ++i;
        }
        result.add(edits.get(size - 1));
        return result;
    }

    public static TextEdit deleteLine(Document doc, int offset, boolean deleteOnlyIfEmpty) {
        Position offPosition = doc.getPosition(offset);
        String lineContent = doc.getLineContent(offPosition.getLine());
        if (deleteOnlyIfEmpty && !lineContent.isBlank()) {
            return null;
        }
        Position posStart = new Position(offPosition.getLine(), 0);
        Position posEnd = new Position(offPosition.getLine() + 1, 0);
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, "");
    }
}

