/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IAmbiguousLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.CandidateCompareResult;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public abstract class AbstractAmbiguousLinkingCandidate<Candidate extends AbstractPendingLinkingCandidate<?>>
implements ILinkingCandidate,
IAmbiguousLinkingCandidate {
    private final LinkedList<AbstractPendingLinkingCandidate<?>> candidates = Lists.newLinkedList();

    protected AbstractAmbiguousLinkingCandidate(Candidate first, AbstractPendingLinkingCandidate<?> second) {
        this.addCandidate((AbstractPendingLinkingCandidate<?>)first);
        this.addCandidate(second);
    }

    @Override
    public List<? extends ILinkingCandidate> getAlternatives() {
        return Collections.unmodifiableList(this.candidates);
    }

    protected final void addCandidate(AbstractPendingLinkingCandidate<?> next) {
        this.candidates.add(next);
    }

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        if (other instanceof AbstractPendingLinkingCandidate) {
            AbstractPendingLinkingCandidate right = (AbstractPendingLinkingCandidate)other;
            CandidateCompareResult candidateCompareResult = this.compareTo(right);
            switch (candidateCompareResult) {
                case AMBIGUOUS: {
                    this.addCandidate(right);
                }
                case EQUALLY_INVALID: 
                case THIS: {
                    return this;
                }
            }
            return other;
        }
        throw new IllegalArgumentException("other was " + other);
    }

    protected CandidateCompareResult compareTo(AbstractPendingLinkingCandidate<?> right) {
        Candidate primaryCandidate = this.getPrimaryCandidate();
        CandidateCompareResult result = ((AbstractPendingLinkingCandidate)primaryCandidate).compareTo(right);
        return result;
    }

    protected final Candidate getPrimaryCandidate() {
        return (Candidate)this.candidates.getFirst();
    }

    @Override
    public void applyToComputationState() {
        Candidate candidate = this.getPrimaryCandidate();
        ((AbstractLinkingCandidate)candidate).getState().getResolvedTypes().reassignLinkingInformation((XExpression)((AbstractLinkingCandidate)candidate).getExpression(), this);
        ((AbstractLinkingCandidate)candidate).applyToComputationState();
    }

    @Override
    public void applyToModel(IResolvedTypes resolvedTypes) {
        this.getPrimaryCandidate().applyToModel(resolvedTypes);
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        Candidate candidate = this.getPrimaryCandidate();
        if (((AbstractPendingLinkingCandidate)candidate).validate(result)) {
            StringBuilder messageBuilder = new StringBuilder("Ambiguous ").append(this.getSyntaxDescriptions()).append(".\n");
            messageBuilder.append("The ").append(this.getFeatureTypeName()).append("s");
            Iterator iter = this.candidates.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                AbstractPendingLinkingCandidate next = (AbstractPendingLinkingCandidate)iter.next();
                if (!first) {
                    if (iter.hasNext()) {
                        messageBuilder.append(",");
                    } else {
                        messageBuilder.append(" and");
                    }
                } else {
                    first = false;
                }
                messageBuilder.append("\n\t");
                if (!next.getDeclaredTypeParameters().isEmpty()) {
                    messageBuilder.append(next.getFeatureTypeParametersAsString(true)).append(' ');
                }
                JvmIdentifiableElement feature = next.getFeature();
                messageBuilder.append(feature.getSimpleName());
                messageBuilder.append(next.getFeatureParameterTypesAsString());
                String declarator = this.getDeclaratorSimpleName(feature);
                if (declarator == null) continue;
                messageBuilder.append(" in ").append(declarator);
            }
            if (this.candidates.size() == 2) {
                messageBuilder.append("\nboth match.");
            } else {
                messageBuilder.append("\nall match.");
            }
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.ambiguous_feature_call", messageBuilder.toString(), (EObject)this.getExpression(), this.getFeatureToMark(), -1, this.getDiagnosticData());
            result.accept((Object)diagnostic);
            return false;
        }
        return false;
    }

    protected abstract String[] getDiagnosticData();

    protected String getFeatureTypeName() {
        return ((AbstractPendingLinkingCandidate)this.getPrimaryCandidate()).getFeatureTypeName();
    }

    protected abstract String getSyntaxDescriptions();

    protected String getDeclaratorSimpleName(JvmIdentifiableElement element) {
        if (element instanceof JvmConstructor) {
            return null;
        }
        if (element instanceof JvmMember) {
            return ((JvmMember)element).getDeclaringType().getSimpleName();
        }
        return null;
    }

    protected abstract EStructuralFeature getFeatureToMark();

    @Override
    public JvmIdentifiableElement getFeature() {
        return ((AbstractPendingLinkingCandidate)this.getPrimaryCandidate()).getFeature();
    }

    @Override
    public XExpression getExpression() {
        return ((AbstractLinkingCandidate)this.getPrimaryCandidate()).getExpression();
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        return ((AbstractLinkingCandidate)this.getPrimaryCandidate()).getTypeArguments();
    }
}

