/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.jface.viewers.TreePath;

class HasChildrenUpdate
extends ViewerUpdateMonitor
implements IHasChildrenUpdate {
    private boolean fHasChildren = false;
    private List<ViewerUpdateMonitor> fBatchedRequests = null;

    public HasChildrenUpdate(TreeModelContentProvider provider, Object viewerInput, TreePath elementPath, Object element, IElementContentProvider elementContentProvider) {
        super(provider, viewerInput, elementPath, element, elementContentProvider, provider.getPresentationContext());
    }

    @Override
    protected void performUpdate() {
        TreeModelContentProvider contentProvider = this.getContentProvider();
        TreePath elementPath = this.getElementPath();
        if (!this.fHasChildren) {
            contentProvider.clearFilters(elementPath);
        }
        if (DebugUIPlugin.DEBUG_CONTENT_PROVIDER) {
            DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext());
        }
        contentProvider.getViewer().setHasChildren(elementPath, this.fHasChildren);
        if (this.fHasChildren) {
            contentProvider.getViewer().autoExpand(elementPath);
        }
        if (elementPath.getSegmentCount() > 0) {
            this.getContentProvider().getStateTracker().restorePendingStateOnUpdate(this.getElementPath(), -1, true, false, false);
        }
    }

    @Override
    public void setHasChilren(boolean hasChildren) {
        this.fHasChildren = hasChildren;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("IHasChildrenUpdate: ");
        buf.append(this.getElement());
        return buf.toString();
    }

    @Override
    boolean coalesce(ViewerUpdateMonitor request) {
        if (request instanceof HasChildrenUpdate) {
            if (this.getElementPath().equals((Object)request.getElementPath())) {
                return true;
            }
            if (this.getElementContentProvider().equals(request.getElementContentProvider())) {
                if (this.fBatchedRequests == null) {
                    this.fBatchedRequests = new ArrayList<ViewerUpdateMonitor>();
                    this.fBatchedRequests.add(this);
                }
                this.fBatchedRequests.add(request);
                return true;
            }
        }
        return false;
    }

    @Override
    void startRequest() {
        if (this.fBatchedRequests == null) {
            this.getElementContentProvider().update(new IHasChildrenUpdate[]{this});
        } else {
            IHasChildrenUpdate[] updates = this.fBatchedRequests.toArray(new IHasChildrenUpdate[this.fBatchedRequests.size()]);
            int i = 1;
            while (i < updates.length) {
                this.getContentProvider().updateStarted((ViewerUpdateMonitor)((Object)updates[i]));
                ++i;
            }
            this.getElementContentProvider().update(updates);
        }
    }

    @Override
    boolean containsUpdate(TreePath path) {
        if (this.getElementPath().equals((Object)path)) {
            return true;
        }
        if (this.fBatchedRequests != null) {
            int i = 0;
            while (i < this.fBatchedRequests.size()) {
                if (this.fBatchedRequests.get(i).getElementPath().equals((Object)path)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    int getPriority() {
        return 1;
    }

    @Override
    TreePath getSchedulingPath() {
        TreePath path = this.getElementPath();
        if (path.getSegmentCount() > 0) {
            return path.getParentPath();
        }
        return path;
    }

    boolean hasChildren() {
        return this.fHasChildren;
    }

    @Override
    protected boolean doEquals(ViewerUpdateMonitor update) {
        return update instanceof HasChildrenUpdate && this.getViewerInput().equals(update.getViewerInput()) && this.getElementPath().equals((Object)update.getElementPath());
    }

    @Override
    protected int doHashCode() {
        return this.getClass().hashCode() + this.getViewerInput().hashCode() + this.getElementPath().hashCode();
    }
}

