/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.XpectStandaloneSetup;
import org.eclipse.xpect.registry.ITestSuiteInfo;
import org.eclipse.xpect.runner.ErrorReportingRunner;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.TestExecutor;
import org.eclipse.xpect.runner.TestRunner;
import org.eclipse.xpect.runner.TestTitleProvider;
import org.eclipse.xpect.runner.XpectFileRunner;
import org.eclipse.xpect.runner.XpectTestFiles;
import org.eclipse.xpect.runner.XpectTestRunner;
import org.eclipse.xpect.runner.XpectURIProvider;
import org.eclipse.xpect.state.Configuration;
import org.eclipse.xpect.state.ResolvedConfiguration;
import org.eclipse.xpect.state.StateContainer;
import org.eclipse.xpect.util.AnnotationUtil;
import org.eclipse.xpect.util.IssueVisualizer;
import org.eclipse.xpect.util.XpectJavaModelManager;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceFactory;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.junit.ComparisonFailure;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

@XpectImport(value={TestTitleProvider.class})
public class XpectRunner
extends ParentRunner<Runner> {
    public static XpectRunner INSTANCE = null;
    public static ClassLoader testClassloader = null;
    private List<Runner> children;
    private Collection<URI> files;
    private final StateContainer state;
    private final IXpectURIProvider uriProvider;
    private final Injector xpectInjector;
    private final XpectJavaModel xpectJavaModel;

    public XpectRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        INSTANCE = this;
        testClassloader = testClass.getClassLoader();
        this.uriProvider = this.findUriProvider(testClass);
        this.xpectInjector = this.findXpectInjector();
        this.xpectJavaModel = XpectJavaModelManager.createJavaModel(testClass);
        this.state = TestExecutor.createState(this.createRootConfiguration());
    }

    protected Runner createChild(URI uri) {
        try {
            XtextResource resource = this.loadXpectResource(uri);
            XpectFile file = this.loadXpectFile(resource);
            Configuration cfg = this.createChildConfiguration(file);
            StateContainer childState = new StateContainer(this.state, new ResolvedConfiguration(this.state.getConfiguration(), cfg));
            return childState.get(XpectFileRunner.class, new Object[0]).get();
        }
        catch (Throwable t) {
            return new ErrorReportingRunner(this, uri, t);
        }
    }

    protected Configuration createChildConfiguration(XpectFile file) {
        return TestExecutor.createFileConfiguration(file);
    }

    protected List<Runner> createChildren(Class<?> clazz) {
        ArrayList result = Lists.newArrayList();
        for (URI uri : this.getFiles()) {
            result.add(this.createChild(uri));
        }
        return result;
    }

    protected Configuration createRootConfiguration() {
        Configuration config = TestExecutor.createRootConfiguration(this.xpectJavaModel);
        config.addDefaultValue(this);
        config.addDefaultValue(IXpectURIProvider.class, this.uriProvider);
        config.addFactory(XpectFileRunner.class);
        config.addFactory(XpectTestRunner.class);
        config.addFactory(TestRunner.class);
        return config;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected IXpectURIProvider findUriProvider(Class<?> clazz) throws InitializationError {
        String baseDir = System.getProperty("xpectBaseDir");
        String files = System.getProperty("xpectFiles");
        if (!Strings.isEmpty((String)baseDir) || !Strings.isEmpty((String)files)) {
            XpectTestFiles.Builder builder = new XpectTestFiles.Builder().relativeTo(XpectTestFiles.FileRoot.PROJECT);
            if (!Strings.isEmpty((String)baseDir)) {
                builder.withBaseDir(baseDir);
            }
            if (files != null) {
                String[] stringArray = files.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    String trimmed = file.trim();
                    if (!"".equals(trimmed)) {
                        builder.addFile(trimmed);
                    }
                    ++n2;
                }
            }
            return builder.create(clazz);
        }
        IXpectURIProvider provider = AnnotationUtil.newInstanceViaMetaAnnotation(clazz, XpectURIProvider.class, IXpectURIProvider.class);
        if (provider != null) {
            return provider;
        }
        return new XpectTestFiles.Builder().relativeTo(XpectTestFiles.FileRoot.CLASS).create(clazz);
    }

    protected Injector findXpectInjector() {
        IResourceServiceProvider rssp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"foo.xpect"));
        if (rssp != null) {
            return (Injector)rssp.get(Injector.class);
        }
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            return new XpectStandaloneSetup().createInjectorAndDoEMFRegistration();
        }
        throw new IllegalStateException("The language *.xpect is not activated");
    }

    public List<Runner> getChildren() {
        if (this.children == null) {
            this.children = this.createChildren(this.getTestClass().getJavaClass());
        }
        return this.children;
    }

    protected Collection<URI> getFiles() {
        if (this.files == null) {
            this.files = this.uriProvider.getAllURIs();
        }
        return this.files;
    }

    public StateContainer getState() {
        return this.state;
    }

    public IXpectURIProvider getUriProvider() {
        return this.uriProvider;
    }

    protected Injector getXpectInjector() {
        return this.xpectInjector;
    }

    public XpectJavaModel getXpectJavaModel() {
        return this.xpectJavaModel;
    }

    protected XpectFile loadXpectFile(XtextResource res) throws IOException {
        XpectFile file;
        XpectFile xpectFile = file = !res.getContents().isEmpty() ? (XpectFile)res.getContents().get(0) : null;
        if (file == null) {
            throw new IllegalStateException("Resource for " + res.getURI() + " is empty.");
        }
        this.validate(file);
        this.validate(res);
        return file;
    }

    protected XtextResource loadXpectResource(URI uri) throws IOException {
        XtextResource resource = (XtextResource)((XtextResourceFactory)this.getXpectInjector().getInstance(XtextResourceFactory.class)).createResource(uri);
        this.getXpectJavaModel().eResource().getResourceSet().getResources().add((Object)resource);
        resource.load(null);
        return resource;
    }

    public void run(RunNotifier notifier) {
        if (this.getChildren().isEmpty()) {
            notifier.fireTestRunStarted(this.getDescription());
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("No Tests found via " + this.getUriProvider())));
        } else {
            try {
                super.run(notifier);
            }
            finally {
                try {
                    this.state.invalidate();
                }
                catch (Throwable t) {
                    notifier.fireTestFailure(new Failure(this.getDescription(), t));
                }
            }
        }
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        try {
            child.run(notifier);
        }
        catch (Throwable t) {
            notifier.fireTestFailure(new Failure(child.getDescription(), t));
        }
    }

    protected void validate(XpectFile file) {
        XpectJavaModel model = file.getJavaModel();
        if (model == null || model.eIsProxy()) {
            String fileName = file.eResource().getURI().lastSegment();
            String registry = ITestSuiteInfo.Registry.INSTANCE.toString();
            throw new IllegalStateException("Could not find test suite for " + fileName + ". Registry:\n" + registry);
        }
    }

    protected void validate(XtextResource res) {
        IResourceValidator validator = (IResourceValidator)res.getResourceServiceProvider().get(IResourceValidator.class);
        List issues = validator.validate((Resource)res, CheckMode.ALL, CancelIndicator.NullImpl);
        if (!issues.isEmpty()) {
            String document = res.getParseResult().getRootNode().getText();
            String errors = new IssueVisualizer().visualize(document, issues);
            throw new ComparisonFailure("Errors in " + res.getURI(), document.trim(), errors.trim());
        }
    }
}

